/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.assets;

import com.android.assetstudiolib.TextRenderUtil;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.ui.properties.core.IntProperty;
import com.android.tools.idea.ui.properties.core.IntValueProperty;
import com.android.tools.idea.ui.properties.core.StringProperty;
import com.android.tools.idea.ui.properties.core.StringValueProperty;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class TextAsset
extends BaseAsset {
    private static final String PREFERRED_FONT = "Roboto";
    private final StringProperty myText = new StringValueProperty("Aa");
    private final StringProperty myFontFamily = new StringValueProperty();
    private final IntProperty myFontSize = new IntValueProperty(144);

    public TextAsset() {
        List<String> fontFamilies = TextAsset.getAllFontFamilies();
        assert (fontFamilies.size() > 0);
        if (fontFamilies.contains(PREFERRED_FONT)) {
            this.myFontFamily.set(PREFERRED_FONT);
        } else {
            this.myFontFamily.set(fontFamilies.get(0));
        }
    }

    @NotNull
    public static List<String> getAllFontFamilies() {
        ArrayList arrayList = Lists.newArrayList((Object[])GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/TextAsset", "getAllFontFamilies"));
        }
        return arrayList;
    }

    @NotNull
    public StringProperty text() {
        StringProperty stringProperty = this.myText;
        if (stringProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/TextAsset", "text"));
        }
        return stringProperty;
    }

    @NotNull
    public StringProperty fontFamily() {
        StringProperty stringProperty = this.myFontFamily;
        if (stringProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/TextAsset", "fontFamily"));
        }
        return stringProperty;
    }

    @Override
    @NotNull
    protected BufferedImage createAsImage(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/android/tools/idea/npw/assetstudio/assets/TextAsset", "createAsImage"));
        }
        TextRenderUtil.Options options = new TextRenderUtil.Options();
        options.font = Font.decode(this.myFontFamily + " " + this.myFontSize.get());
        options.foregroundColor = color.getRGB();
        BufferedImage bufferedImage = TextRenderUtil.renderTextImage((String)((String)this.myText.get()), (int)1, (TextRenderUtil.Options)options);
        if (bufferedImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/TextAsset", "createAsImage"));
        }
        return bufferedImage;
    }
}

