/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.npw.project.AndroidProjectPaths;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public final class AssetStudioUtils {
    public static boolean resourceExists(@NotNull AndroidProjectPaths paths, @NotNull ResourceFolderType resourceType, @NotNull String name) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/android/tools/idea/npw/assetstudio/AssetStudioUtils", "resourceExists"));
        }
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceType", "com/android/tools/idea/npw/assetstudio/AssetStudioUtils", "resourceExists"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/npw/assetstudio/AssetStudioUtils", "resourceExists"));
        }
        File resDir = paths.getResDirectory();
        if (resDir == null) {
            return false;
        }
        File[] resTypes = resDir.listFiles();
        if (resTypes == null) {
            return false;
        }
        for (File resTypeDir : resTypes) {
            File[] files;
            if (!resTypeDir.isDirectory() || !resourceType.equals((Object)ResourceFolderType.getFolderType((String)resTypeDir.getName())) || (files = resTypeDir.listFiles()) == null) continue;
            for (File f : files) {
                if (!FileUtil.getNameWithoutExtension((File)f).equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean resourceExists(@NotNull AndroidFacet facet, @NotNull ResourceType resourceType, @NotNull String name) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/npw/assetstudio/AssetStudioUtils", "resourceExists"));
        }
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceType", "com/android/tools/idea/npw/assetstudio/AssetStudioUtils", "resourceExists"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/npw/assetstudio/AssetStudioUtils", "resourceExists"));
        }
        AppResourceRepository repository = facet.getAppResources(true);
        return repository.hasResourceItem(resourceType, name);
    }

    private AssetStudioUtils() {
    }
}

