/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ThreadSafe
public final class AdbErrors {
    private static volatile List<String> ourAdbErrorList;

    private AdbErrors() {
    }

    @NotNull
    public static synchronized String[] getErrors() {
        String[] stringArray = ourAdbErrorList != null ? ArrayUtil.toStringArray(ourAdbErrorList) : ArrayUtil.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/AdbErrors", "getErrors"));
        }
        return stringArray;
    }

    public static synchronized void clear() {
        if (ourAdbErrorList != null) {
            ourAdbErrorList.clear();
        }
    }

    public static synchronized void reportError(@NotNull String message, @Nullable String tag) {
        String fullMessage;
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/logcat/AdbErrors", "reportError"));
        }
        String string = fullMessage = tag != null ? tag + ": " + message : message;
        if (ourAdbErrorList == null) {
            ourAdbErrorList = new ArrayList<String>();
        }
        ourAdbErrorList.add(fullMessage);
    }
}

