/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.editor.dependencies;

import com.android.tools.idea.gradle.structure.configurables.editor.dependencies.AddDependencyPanel;
import com.android.tools.idea.gradle.structure.configurables.editor.dependencies.ArtifactRepositorySearch;
import com.android.tools.idea.gradle.structure.configurables.editor.dependencies.DependenciesPanel;
import com.android.tools.idea.gradle.structure.configurables.editor.dependencies.LibrarySearch;
import com.android.tools.idea.structure.dialog.HeaderPanel;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

class LibrariesPanel
extends AddDependencyPanel {
    private static final List<PopularLibrary> POPULAR_LIBRARIES = Lists.newArrayList();

    LibrariesPanel(@NotNull DependenciesPanel dependenciesPanel, @NotNull List<ArtifactRepositorySearch> searches) {
        if (dependenciesPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependenciesPanel", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/LibrariesPanel", "<init>"));
        }
        if (searches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searches", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/LibrariesPanel", "<init>"));
        }
        super("Library", PlatformIcons.LIBRARY_ICON);
        OnePixelSplitter splitter = new OnePixelSplitter(false, "psd.dependencies.libraries.splitter.proportion", 0.8f);
        JPanel librarySearchPanel = new JPanel(new BorderLayout());
        librarySearchPanel.add((Component)new HeaderPanel("Library Search"), "North");
        librarySearchPanel.add((Component)new LibrarySearch(dependenciesPanel, searches).getPanel(), "Center");
        splitter.setFirstComponent((JComponent)librarySearchPanel);
        splitter.setSecondComponent((JComponent)new PopularLibrariesPanel(dependenciesPanel));
        this.add((Component)splitter, "Center");
    }

    static {
        POPULAR_LIBRARIES.add(new PopularLibrary("appcompat-v7", "com.android.support:appcompat-v7:23.0.0"));
        POPULAR_LIBRARIES.add(new PopularLibrary("cardview-v7", "com.android.support:cardview-v7:23.0.0"));
        POPULAR_LIBRARIES.add(new PopularLibrary("dagger", "com.google.dagger:dagger:2.0.2"));
        POPULAR_LIBRARIES.add(new PopularLibrary("design", "com.android.support:design:23.0.0"));
        POPULAR_LIBRARIES.add(new PopularLibrary("guava", "com.google.guava:guava:18.0"));
        POPULAR_LIBRARIES.add(new PopularLibrary("gridlayout-v7", "com.android.support:gridlayout-v7:23.0.0"));
        POPULAR_LIBRARIES.add(new PopularLibrary("gson", "org.immutables:gson:2.1.0"));
        POPULAR_LIBRARIES.add(new PopularLibrary("play-services", "com.google.android.gms:play-services:7.8.0"));
        POPULAR_LIBRARIES.add(new PopularLibrary("recyclerview-v7", "com.android.support:recyclerview-v7:23.0.0"));
        POPULAR_LIBRARIES.add(new PopularLibrary("support-annotations", "com.android.support:support-annotations:23.0.0"));
        POPULAR_LIBRARIES.add(new PopularLibrary("support-v13", "com.android.support:support-v13:23.0.0"));
    }

    private static class PopularLibrary {
        @NotNull
        final String name;
        @NotNull
        final String coordinate;

        PopularLibrary(@NotNull String name, @NotNull String coordinate) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/LibrariesPanel$PopularLibrary", "<init>"));
            }
            if (coordinate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coordinate", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/LibrariesPanel$PopularLibrary", "<init>"));
            }
            this.name = name;
            this.coordinate = coordinate;
        }
    }

    private static class PopularLibrariesPanel
    extends JPanel {
        PopularLibrariesPanel(final @NotNull DependenciesPanel dependenciesPanel) {
            if (dependenciesPanel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependenciesPanel", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/LibrariesPanel$PopularLibrariesPanel", "<init>"));
            }
            super(new BorderLayout());
            JTextPane textPane = new JTextPane();
            textPane.setEditable(false);
            textPane.setEditorKit(UIUtil.getHTMLEditorKit());
            StringBuilder buffer = new StringBuilder(860);
            for (PopularLibrary library : POPULAR_LIBRARIES) {
                buffer.append(String.format("<a href='%1$s'>", library.coordinate)).append(library.name).append("</a><br/>");
            }
            textPane.setText(buffer.toString());
            textPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            textPane.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

                protected void hyperlinkActivated(HyperlinkEvent e) {
                    String coordinate = e.getDescription();
                    assert (StringUtil.isNotEmpty((String)coordinate));
                    dependenciesPanel.addLibraryDependency(coordinate);
                }
            });
            this.add((Component)new HeaderPanel("Popular Libraries"), "North");
            this.add((Component)new JBScrollPane((Component)textPane), "Center");
            this.setBorder(IdeBorderFactory.createBorder((int)4));
        }
    }
}

