/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.entity;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class GradleEditorSourceBinding
implements Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final RangeMarker myRangeMarker;

    public GradleEditorSourceBinding(@NotNull Project project, @NotNull VirtualFile file, @NotNull RangeMarker rangeMarker) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/editor/entity/GradleEditorSourceBinding", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/editor/entity/GradleEditorSourceBinding", "<init>"));
        }
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/android/tools/idea/gradle/editor/entity/GradleEditorSourceBinding", "<init>"));
        }
        this.myProject = project;
        this.myFile = file;
        this.myRangeMarker = rangeMarker;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/entity/GradleEditorSourceBinding", "getProject"));
        }
        return project;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/entity/GradleEditorSourceBinding", "getFile"));
        }
        return virtualFile;
    }

    @NotNull
    public RangeMarker getRangeMarker() {
        RangeMarker rangeMarker = this.myRangeMarker;
        if (rangeMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/entity/GradleEditorSourceBinding", "getRangeMarker"));
        }
        return rangeMarker;
    }

    public void dispose() {
        this.myRangeMarker.dispose();
    }

    public String toString() {
        if (this.myRangeMarker.isValid()) {
            return String.format("%s: [%d;%d)", this.myFile.getName(), this.myRangeMarker.getStartOffset(), this.myRangeMarker.getEndOffset());
        }
        return "<disposed>";
    }
}

