/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.java;

import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslReference;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.java.LanguageLevelUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public class JavaVersionDslElement
extends GradleDslElement {
    private GradleDslExpression myInternalVersionElement;
    private boolean myUseAssignment;
    @Nullable
    private LanguageLevel myUnsavedValue;

    public JavaVersionDslElement(@Nullable GradleDslElement parent, @NotNull GradleDslExpression dslElement, @NotNull String name) {
        if (dslElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dslElement", "com/android/tools/idea/gradle/dsl/parser/java/JavaVersionDslElement", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/java/JavaVersionDslElement", "<init>"));
        }
        super(parent, null, name);
        assert (dslElement instanceof GradleDslLiteral || dslElement instanceof GradleDslReference);
        if (dslElement.getPsiElement() instanceof GrAssignmentExpression) {
            this.myUseAssignment = true;
        }
        this.myInternalVersionElement = dslElement;
    }

    public JavaVersionDslElement(@Nullable GradleDslElement parent, @NotNull String name, @NotNull boolean useAssignment) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/java/JavaVersionDslElement", "<init>"));
        }
        super(parent, null, name);
        this.myUseAssignment = useAssignment;
    }

    public GrExpression getPsiElement() {
        if (this.myInternalVersionElement != null) {
            GroovyPsiElement psiElement = this.myInternalVersionElement.getPsiElement();
            if (psiElement instanceof GrCommandArgumentList) {
                return (GrExpression)psiElement.getParent();
            }
            return (GrExpression)psiElement;
        }
        return null;
    }

    @Override
    public void setPsiElement(@Nullable GroovyPsiElement psiElement) {
    }

    @Override
    @NotNull
    protected Collection<GradleDslElement> getChildren() {
        List<GradleDslElement> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/java/JavaVersionDslElement", "getChildren"));
        }
        return list;
    }

    @Nullable
    public LanguageLevel getVersion() {
        if (this.myUnsavedValue != null) {
            return this.myUnsavedValue;
        }
        String text = this.getVersionText();
        if (text != null) {
            return LanguageLevelUtil.parseFromGradleString(text);
        }
        return null;
    }

    @Nullable
    private String getVersionText() {
        GrLiteral literal;
        GradleDslReference referenceElement;
        GradleDslLiteral valueLiteral = null;
        if (this.myInternalVersionElement instanceof GradleDslReference && (valueLiteral = (referenceElement = (GradleDslReference)this.myInternalVersionElement).getValue(GradleDslLiteral.class)) == null) {
            String resolvedReference = referenceElement.getValue(String.class);
            if (resolvedReference != null) {
                return resolvedReference;
            }
            return referenceElement.getReferenceText();
        }
        if (this.myInternalVersionElement instanceof GradleDslLiteral) {
            valueLiteral = (GradleDslLiteral)this.myInternalVersionElement;
        }
        if (valueLiteral != null && (literal = valueLiteral.getLiteral()) != null) {
            return literal.getText();
        }
        return null;
    }

    public void setVersion(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/android/tools/idea/gradle/dsl/parser/java/JavaVersionDslElement", "setVersion"));
        }
        this.myUnsavedValue = languageLevel;
        this.setModified(true);
    }

    @Override
    protected void apply() {
        GrExpression psiElement = this.getPsiElement();
        if (this.myUnsavedValue == null || psiElement == null) {
            return;
        }
        String groovyString = LanguageLevelUtil.convertToGradleString(this.myUnsavedValue, this.getVersionText());
        GrExpression newVersionPsi = GroovyPsiElementFactory.getInstance((Project)psiElement.getProject()).createExpressionFromText((CharSequence)groovyString);
        GrExpression oldVersionPsi = this.myUseAssignment ? ((GrAssignmentExpression)psiElement).getRValue() : ((GrApplicationStatement)psiElement).getExpressionArguments()[0];
        assert (oldVersionPsi != null);
        oldVersionPsi.replace((PsiElement)newVersionPsi);
    }

    @Override
    protected void reset() {
        this.myUnsavedValue = null;
    }

    @Override
    @Nullable
    public GroovyPsiElement create() {
        GrExpression valuePsi;
        GrExpression newExpressionPsi;
        GrExpression psiElement = this.getPsiElement();
        if (psiElement != null) {
            return psiElement;
        }
        GradlePropertiesDslElement parent = (GradlePropertiesDslElement)this.myParent;
        assert (parent != null);
        GroovyPsiElement javaPsiElement = parent.create();
        assert (javaPsiElement != null);
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)javaPsiElement.getProject());
        JavaVersionDslElement anchor = null;
        if ("sourceCompatibility".equals(this.myName)) {
            anchor = parent.getProperty("targetCompatibility", JavaVersionDslElement.class);
        } else if ("targetCompatibility".equals(this.myName)) {
            anchor = parent.getProperty("sourceCompatibility", JavaVersionDslElement.class);
        }
        GrExpression anchorPsiElement = null;
        String anchorText = null;
        if (anchor != null) {
            anchorPsiElement = anchor.getPsiElement();
            anchorText = anchor.getVersionText();
        }
        if (anchorPsiElement == null) {
            anchorPsiElement = javaPsiElement.getLastChild();
        }
        if (anchorText == null) {
            anchorText = "1.6";
        }
        if (this.myUseAssignment) {
            GrExpression expression = factory.createExpressionFromText((CharSequence)(this.myName + " = " + anchorText));
            newExpressionPsi = (GrExpression)javaPsiElement.addBefore((PsiElement)expression, (PsiElement)anchorPsiElement);
            valuePsi = ((GrAssignmentExpression)newExpressionPsi).getRValue();
        } else {
            GrExpression expression = factory.createExpressionFromText((CharSequence)(this.myName + " " + anchorText));
            newExpressionPsi = (GrExpression)javaPsiElement.addBefore((PsiElement)expression, (PsiElement)anchorPsiElement);
            valuePsi = ((GrApplicationStatement)newExpressionPsi).getExpressionArguments()[0];
        }
        if (valuePsi instanceof GrLiteral) {
            this.myInternalVersionElement = new GradleDslLiteral((GradleDslElement)parent, (GroovyPsiElement)newExpressionPsi, this.myName, (GrLiteral)valuePsi);
        } else if (valuePsi instanceof GrReferenceExpression) {
            this.myInternalVersionElement = new GradleDslReference((GradleDslElement)parent, (GroovyPsiElement)newExpressionPsi, this.myName, (GrReferenceExpression)valuePsi);
        }
        return this.getPsiElement();
    }

    @Override
    protected void delete() {
        GrExpression psiElement = this.getPsiElement();
        if (psiElement != null) {
            PsiElement parent = psiElement.getParent();
            psiElement.delete();
            JavaVersionDslElement.deleteIfEmpty(parent);
        }
    }
}

