/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArtifactDependencyModel
extends DependencyModel {
    @NotNull
    public abstract String name();

    @Nullable
    public abstract String group();

    @Nullable
    public abstract String version();

    public abstract void setVersion(@NotNull String var1);

    @Nullable
    public abstract String classifier();

    @Nullable
    public abstract String extension();

    @NotNull
    static List<ArtifactDependencyModel> create(@NotNull GradleDslElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel", "create"));
        }
        ArrayList results = Lists.newArrayList();
        assert (element instanceof GradleDslExpression || element instanceof GradleDslExpressionMap);
        if (element instanceof GradleDslExpressionMap) {
            results.add(new MapNotation((GradleDslExpressionMap)element));
        } else if (element instanceof GradleDslMethodCall) {
            String name = element.getName();
            if (!"project".equals(name) && !"fileTree".equals(name)) {
                for (GradleDslElement argument : ((GradleDslMethodCall)element).getArguments()) {
                    results.addAll(ArtifactDependencyModel.create(argument));
                }
            }
        } else {
            ArtifactDependencySpec spec;
            GradleDslExpression expression = (GradleDslExpression)element;
            String value = expression.getValue(String.class);
            if (value != null && (spec = ArtifactDependencySpec.create(value)) != null) {
                results.add(new CompactNotation((GradleDslExpression)element, spec));
            }
        }
        ArrayList arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel", "create"));
        }
        return arrayList;
    }

    static void createAndAddToList(@NotNull GradleDslElementList list, @NotNull String configurationName, @NotNull ArtifactDependencySpec dependency) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel", "createAndAddToList"));
        }
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel", "createAndAddToList"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel", "createAndAddToList"));
        }
        GradleDslLiteral literal = new GradleDslLiteral(list, configurationName);
        literal.setValue(dependency.compactNotation());
        list.addNewElement(literal);
    }

    @NotNull
    public ArtifactDependencySpec getSpec() {
        ArtifactDependencySpec artifactDependencySpec = new ArtifactDependencySpec(this.name(), this.group(), this.version(), this.classifier(), this.extension());
        if (artifactDependencySpec == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel", "getSpec"));
        }
        return artifactDependencySpec;
    }

    private static class CompactNotation
    extends ArtifactDependencyModel {
        @NotNull
        private GradleDslExpression myDslExpression;
        @NotNull
        private ArtifactDependencySpec mySpec;

        CompactNotation(@NotNull GradleDslExpression dslExpression, @NotNull ArtifactDependencySpec spec) {
            if (dslExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dslExpression", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel$CompactNotation", "<init>"));
            }
            if (spec == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "spec", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel$CompactNotation", "<init>"));
            }
            this.myDslExpression = dslExpression;
            this.mySpec = spec;
        }

        @Override
        @NotNull
        public String name() {
            String string = this.mySpec.name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel$CompactNotation", "name"));
            }
            return string;
        }

        @Override
        @Nullable
        public String group() {
            return this.mySpec.group;
        }

        @Override
        @Nullable
        public String version() {
            return this.mySpec.version;
        }

        @Override
        public void setVersion(@NotNull String version) {
            if (version == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel$CompactNotation", "setVersion"));
            }
            this.mySpec.version = version;
            this.myDslExpression.setValue(this.mySpec.toString());
        }

        @Override
        @Nullable
        public String classifier() {
            return this.mySpec.classifier;
        }

        @Override
        @Nullable
        public String extension() {
            return this.mySpec.extension;
        }

        @Override
        @NotNull
        protected GradleDslElement getDslElement() {
            GradleDslExpression gradleDslExpression = this.myDslExpression;
            if (gradleDslExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel$CompactNotation", "getDslElement"));
            }
            return gradleDslExpression;
        }
    }

    private static class MapNotation
    extends ArtifactDependencyModel {
        @NotNull
        private GradleDslExpressionMap myDslElement;

        MapNotation(@NotNull GradleDslExpressionMap dslElement) {
            if (dslElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dslElement", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel$MapNotation", "<init>"));
            }
            this.myDslElement = dslElement;
        }

        @Override
        @NotNull
        public String name() {
            String value = this.myDslElement.getProperty("name", String.class);
            assert (value != null);
            String string = value;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel$MapNotation", "name"));
            }
            return string;
        }

        @Override
        @Nullable
        public String group() {
            return this.myDslElement.getProperty("group", String.class);
        }

        @Override
        @Nullable
        public String version() {
            return this.myDslElement.getProperty("version", String.class);
        }

        @Override
        public void setVersion(@NotNull String version) {
            if (version == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel$MapNotation", "setVersion"));
            }
            this.myDslElement.setNewLiteral("version", version);
        }

        @Override
        @Nullable
        public String classifier() {
            return this.myDslElement.getProperty("classifier", String.class);
        }

        @Override
        @Nullable
        public String extension() {
            return this.myDslElement.getProperty("ext", String.class);
        }

        @Override
        @NotNull
        protected GradleDslElement getDslElement() {
            GradleDslExpressionMap gradleDslExpressionMap = this.myDslElement;
            if (gradleDslExpressionMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModel$MapNotation", "getDslElement"));
            }
            return gradleDslExpressionMap;
        }
    }
}

