/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.tools.idea.stats.UsageTracker;
import com.google.common.collect.Maps;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class InstantRunStatsService {
    public static final int UPLOAD_INTERVAL_MINUTES = 10;
    private final Object LOCK = new Object();
    private UUID mySessionId;
    private long myBuildStartTime;
    private StringBuilder[] myDeployTimesByType = new StringBuilder[DeployType.values().length];
    private int myDeployTimesLength = 0;
    private int myDeployStartedCount;
    private int[] myDeployTypeCounts = new int[DeployType.values().length];
    private int myRestartLaunchCount;

    public static InstantRunStatsService get(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/fd/InstantRunStatsService", "get"));
        }
        return (InstantRunStatsService)ServiceManager.getService((Project)project, InstantRunStatsService.class);
    }

    private InstantRunStatsService() {
        JobScheduler.getScheduler().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                InstantRunStatsService.this.uploadStats();
            }
        }, 10L, 10L, TimeUnit.MINUTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyBuildStarted() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myBuildStartTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDeployStarted() {
        Object object = this.LOCK;
        synchronized (object) {
            ++this.myDeployStartedCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDeployType(@NotNull DeployType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/fd/InstantRunStatsService", "notifyDeployType"));
        }
        Object object = this.LOCK;
        synchronized (object) {
            int ordinal;
            long buildAndDeployTime = System.currentTimeMillis() - this.myBuildStartTime;
            if (type == DeployType.FULLAPK || type == DeployType.LEGACY || type == DeployType.SPLITAPK) {
                this.resetSession();
            } else if (this.myDeployTimesLength > 1950) {
                this.uploadStats();
            }
            int n = ordinal = type.ordinal();
            this.myDeployTypeCounts[n] = this.myDeployTypeCounts[n] + 1;
            StringBuilder timings = this.myDeployTimesByType[ordinal];
            if (timings == null) {
                timings = new StringBuilder(256);
            } else if (timings.length() > 0) {
                timings.append("a");
                ++this.myDeployTimesLength;
            }
            String timeInSeconds = Long.toString(buildAndDeployTime / 1000L);
            timings.append(timeInSeconds);
            this.myDeployTimesLength += timeInSeconds.length();
            this.myDeployTimesByType[ordinal] = timings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetSession() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.mySessionId != null) {
                this.uploadStats();
            }
            this.mySessionId = UUID.randomUUID();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementRestartLaunchCount() {
        Object object = this.LOCK;
        synchronized (object) {
            ++this.myRestartLaunchCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadStats() {
        String sessionId;
        int restartCount;
        int deployCount;
        int[] deployTypeCount = new int[this.myDeployTypeCounts.length];
        String[] deployTimings = new String[this.myDeployTimesByType.length];
        Object object = this.LOCK;
        synchronized (object) {
            int i;
            if (this.myDeployStartedCount == 0) {
                return;
            }
            deployCount = this.myDeployStartedCount;
            restartCount = this.myRestartLaunchCount;
            System.arraycopy(this.myDeployTypeCounts, 0, deployTypeCount, 0, this.myDeployTypeCounts.length);
            this.myDeployStartedCount = 0;
            this.myRestartLaunchCount = 0;
            for (i = 0; i < this.myDeployTypeCounts.length; ++i) {
                this.myDeployTypeCounts[i] = 0;
            }
            for (i = 0; i < this.myDeployTimesByType.length; ++i) {
                if (this.myDeployTimesByType[i] == null) continue;
                deployTimings[i] = this.myDeployTimesByType[i].toString();
                this.myDeployTimesByType[i].setLength(0);
                this.myDeployTimesLength = 0;
            }
            sessionId = this.mySessionId.toString();
        }
        HashMap kv = Maps.newHashMap();
        kv.put("deploycount", Integer.toString(deployCount));
        kv.put("restartBuild", Integer.toString(restartCount));
        kv.put("sessionId", sessionId);
        for (DeployType type : DeployType.values()) {
            kv.put(type.toString(), Integer.toString(deployTypeCount[type.ordinal()]));
        }
        UsageTracker.getInstance().trackInstantRunStats(kv);
        kv = Maps.newHashMap();
        for (DeployType type : DeployType.values()) {
            String deployTiming = deployTimings[type.ordinal()];
            if (StringUtil.isEmpty((String)deployTiming)) continue;
            kv.put(type.toString(), deployTiming);
        }
        if (kv.isEmpty()) {
            return;
        }
        kv.put("timeUnit", "seconds");
        UsageTracker.getInstance().trackInstantRunTimings(kv);
    }

    public static enum DeployType {
        LEGACY,
        FULLAPK,
        HOTSWAP,
        SPLITAPK,
        DEX;

    }
}

