/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.builder.model.BuildType;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.InstantRun;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleVersion;
import com.android.sdklib.AndroidVersion;
import com.android.tools.fd.client.InstantRunBuildInfo;
import com.android.tools.idea.fd.BooleanStatus;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantRunGradleUtils {
    public static BooleanStatus getIrSupportStatus(@NotNull Module module, @NotNull AndroidVersion deviceVersion) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/fd/InstantRunGradleUtils", "getIrSupportStatus"));
        }
        if (deviceVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceVersion", "com/android/tools/idea/fd/InstantRunGradleUtils", "getIrSupportStatus"));
        }
        if (!InstantRunSettings.isInstantRunEnabled()) {
            return BooleanStatus.failure("not enabled in settings");
        }
        return InstantRunGradleUtils.getIrSupportStatus(InstantRunGradleUtils.getAppModel(module), deviceVersion);
    }

    @NotNull
    public static BooleanStatus getIrSupportStatus(@Nullable AndroidGradleModel model, @Nullable AndroidVersion deviceVersion) {
        ProductFlavor mergedFlavor;
        if (model == null) {
            BooleanStatus booleanStatus = BooleanStatus.failure("no gradle model");
            if (booleanStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunGradleUtils", "getIrSupportStatus"));
            }
            return booleanStatus;
        }
        BooleanStatus status = InstantRunGradleUtils.getIrSupportStatus(model);
        if (!status.success) {
            BooleanStatus booleanStatus = status;
            if (booleanStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunGradleUtils", "getIrSupportStatus"));
            }
            return booleanStatus;
        }
        if (deviceVersion == null) {
            BooleanStatus booleanStatus = BooleanStatus.SUCCESS;
            if (booleanStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunGradleUtils", "getIrSupportStatus"));
            }
            return booleanStatus;
        }
        Variant variant = model.getSelectedVariant();
        BuildTypeContainer buildTypeContainer = model.findBuildType(model.getSelectedVariant().getBuildType());
        assert (buildTypeContainer != null);
        BuildType buildType = buildTypeContainer.getBuildType();
        if (InstantRunGradleUtils.isLegacyMultiDex(buildType, mergedFlavor = variant.getMergedFlavor())) {
            if (deviceVersion.isGreaterOrEqualThan(AndroidVersion.ART_RUNTIME.getApiLevel())) {
                BooleanStatus booleanStatus = BooleanStatus.SUCCESS;
                if (booleanStatus == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunGradleUtils", "getIrSupportStatus"));
                }
                return booleanStatus;
            }
            BooleanStatus booleanStatus = BooleanStatus.failure("Instant Run does not support deploying build variants with multidex enabled, to a target with API level 20 or below.<br><br>To use Instant Run with a multidex enabled build variant, deploy to a target with API level 21 or higher.");
            if (booleanStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunGradleUtils", "getIrSupportStatus"));
            }
            return booleanStatus;
        }
        BooleanStatus booleanStatus = BooleanStatus.SUCCESS;
        if (booleanStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunGradleUtils", "getIrSupportStatus"));
        }
        return booleanStatus;
    }

    @NotNull
    private static BooleanStatus getIrSupportStatus(@NotNull AndroidGradleModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/fd/InstantRunGradleUtils", "getIrSupportStatus"));
        }
        String version = model.getAndroidProject().getModelVersion();
        if (!InstantRunGradleUtils.modelSupportsInstantRun(model)) {
            String msg = "Android Plugin for Gradle version " + version + " does not support Instant Run. Please update to version " + "2.1.0-beta3";
            BooleanStatus booleanStatus = BooleanStatus.failure(msg);
            if (booleanStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunGradleUtils", "getIrSupportStatus"));
            }
            return booleanStatus;
        }
        if (InstantRunGradleUtils.variantSupportsInstantRun(model)) {
            BooleanStatus booleanStatus = BooleanStatus.SUCCESS;
            if (booleanStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunGradleUtils", "getIrSupportStatus"));
            }
            return booleanStatus;
        }
        String msg = "variant '" + model.getSelectedVariant().getName() + "' uses an unsupported feature (e.g. ProGuard)";
        BooleanStatus booleanStatus = BooleanStatus.failure(msg);
        if (booleanStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunGradleUtils", "getIrSupportStatus"));
        }
        return booleanStatus;
    }

    private static boolean isLegacyMultiDex(@NotNull BuildType buildType, @NotNull ProductFlavor mergedFlavor) {
        if (buildType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildType", "com/android/tools/idea/fd/InstantRunGradleUtils", "isLegacyMultiDex"));
        }
        if (mergedFlavor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergedFlavor", "com/android/tools/idea/fd/InstantRunGradleUtils", "isLegacyMultiDex"));
        }
        if (buildType.getMultiDexEnabled() != null) {
            return buildType.getMultiDexEnabled();
        }
        if (mergedFlavor.getMultiDexEnabled() != null) {
            return mergedFlavor.getMultiDexEnabled();
        }
        return false;
    }

    public static boolean variantSupportsInstantRun(@NotNull AndroidGradleModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/fd/InstantRunGradleUtils", "variantSupportsInstantRun"));
        }
        try {
            return model.getSelectedVariant().getMainArtifact().getInstantRun().isSupportedByArtifact();
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean modelSupportsInstantRun(@NotNull AndroidGradleModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/fd/InstantRunGradleUtils", "modelSupportsInstantRun"));
        }
        GradleVersion modelVersion = model.getModelVersion();
        return modelVersion == null || modelVersion.compareTo(InstantRunManager.MINIMUM_GRADLE_PLUGIN_VERSION) >= 0;
    }

    @NotNull
    public static String getIncrementalDexTask(@NotNull AndroidGradleModel model, @NotNull Module module) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/fd/InstantRunGradleUtils", "getIncrementalDexTask"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/fd/InstantRunGradleUtils", "getIncrementalDexTask"));
        }
        assert (InstantRunGradleUtils.modelSupportsInstantRun(model)) : module;
        String taskName = model.getSelectedVariant().getMainArtifact().getInstantRun().getIncrementalAssembleTaskName();
        String gradlePath = GradleUtil.getGradlePath(module);
        if (gradlePath != null) {
            taskName = gradlePath + ":" + taskName;
        }
        String string = taskName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunGradleUtils", "getIncrementalDexTask"));
        }
        return string;
    }

    @Nullable
    public static AndroidGradleModel getAppModel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/fd/InstantRunGradleUtils", "getAppModel"));
        }
        AndroidFacet facet = InstantRunGradleUtils.findAppModule(module, module.getProject());
        if (facet == null) {
            return null;
        }
        return AndroidGradleModel.get(facet);
    }

    @Nullable
    public static AndroidFacet findAppModule(@Nullable Module module, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/fd/InstantRunGradleUtils", "findAppModule"));
        }
        if (module != null) {
            assert (module.getProject() == project);
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet != null && !facet.isLibraryProject()) {
                return facet;
            }
        }
        for (Module m : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(m);
            if (facet == null || facet.isLibraryProject()) continue;
            return facet;
        }
        return null;
    }

    @Nullable
    public static InstantRunBuildInfo getBuildInfo(AndroidGradleModel model) {
        String xml;
        File buildInfo = InstantRunGradleUtils.getLocalBuildInfoFile(model);
        if (!buildInfo.exists()) {
            return null;
        }
        try {
            xml = Files.toString((File)buildInfo, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            return null;
        }
        return InstantRunBuildInfo.get((String)xml);
    }

    @NotNull
    private static File getLocalBuildInfoFile(@NotNull AndroidGradleModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/fd/InstantRunGradleUtils", "getLocalBuildInfoFile"));
        }
        InstantRun instantRun = model.getSelectedVariant().getMainArtifact().getInstantRun();
        File file = instantRun.getInfoFile();
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunGradleUtils", "getLocalBuildInfoFile"));
        }
        return file;
    }
}

