/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation.macros;

import com.android.tools.idea.editors.navigation.macros.CodeTemplate;
import com.android.tools.idea.editors.navigation.macros.Unifier;
import com.intellij.psi.PsiElement;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class MultiMatch {
    public final CodeTemplate macro;
    public final Map<String, CodeTemplate> subMacros = new LinkedHashMap<String, CodeTemplate>();

    public MultiMatch(CodeTemplate macro) {
        this.macro = macro;
    }

    public void addSubMacro(String name, CodeTemplate macro) {
        this.subMacros.put(name, macro);
    }

    @Nullable
    public Bindings<PsiElement> match(PsiElement element) {
        Map<String, PsiElement> bindings = Unifier.match(this.macro, element);
        if (bindings == null) {
            return null;
        }
        HashMap subBindings = new HashMap();
        for (Map.Entry<String, CodeTemplate> entry : this.subMacros.entrySet()) {
            String name = entry.getKey();
            CodeTemplate template = entry.getValue();
            Map<String, PsiElement> subBinding = Unifier.match(template, bindings.get(name));
            if (subBinding == null) {
                return null;
            }
            subBindings.put(name, subBinding);
        }
        return new Bindings<PsiElement>(bindings, subBindings);
    }

    public static class Bindings<T> {
        public final Map<String, T> bindings;
        public final Map<String, Map<String, T>> subBindings;

        Bindings(Map<String, T> bindings, Map<String, Map<String, T>> subBindings) {
            this.bindings = bindings;
            this.subBindings = subBindings;
        }

        public T get(String key) {
            return this.bindings.get(key);
        }

        public String toString() {
            return "Bindings{bindings=" + this.bindings + ", subBindings=" + this.subBindings + '}';
        }
    }
}

