/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof.views;

import com.android.tools.idea.editors.hprof.views.GoToInstanceListener;
import com.android.tools.idea.editors.hprof.views.InstanceReferenceTreeView;
import com.android.tools.perflib.heap.Instance;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class GoToInstanceAction
extends AnAction {
    private final EventDispatcher<GoToInstanceListener> myEventDispatcher;

    public GoToInstanceAction(@NotNull JComponent ancestorComponent) {
        if (ancestorComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ancestorComponent", "com/android/tools/idea/editors/hprof/views/GoToInstanceAction", "<init>"));
        }
        super("Go to Instance");
        this.myEventDispatcher = EventDispatcher.create(GoToInstanceListener.class);
        this.registerCustomShortcutSet(ActionManager.getInstance().getAction("GotoDeclaration").getShortcutSet(), ancestorComponent);
    }

    public void addListener(@NotNull GoToInstanceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/hprof/views/GoToInstanceAction", "addListener"));
        }
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(e.getData(InstanceReferenceTreeView.NAVIGATABLE_INSTANCE) != null);
    }

    public void actionPerformed(AnActionEvent e) {
        Instance instance = (Instance)e.getData(InstanceReferenceTreeView.NAVIGATABLE_INSTANCE);
        if (instance == null) {
            return;
        }
        for (GoToInstanceListener listener : this.myEventDispatcher.getListeners()) {
            listener.goToInstance(instance);
        }
    }
}

