/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace;

import com.android.tools.idea.editors.gfxtrace.UiCallback;

public abstract class UiErrorCallback<T, U, E>
extends UiCallback<T, ResultOrError<U, E>> {
    @Override
    protected final void onUiThread(ResultOrError<U, E> result) {
        if (result.hasResult()) {
            this.onUiThreadSuccess(result.getResult());
        } else {
            this.onUiThreadError(result.getError());
        }
    }

    protected abstract void onUiThreadSuccess(U var1);

    protected abstract void onUiThreadError(E var1);

    public ResultOrError<U, E> success(U result) {
        return new ResultOrError(result, null);
    }

    public ResultOrError<U, E> error(E error) {
        return new ResultOrError(null, error);
    }

    public static class ResultOrError<T, E> {
        private final T myResult;
        private final E myError;

        private ResultOrError(T result, E error) {
            this.myResult = result;
            this.myError = error;
        }

        public T getResult() {
            return this.myResult;
        }

        public E getError() {
            return this.myError;
        }

        public boolean hasResult() {
            return this.myResult != null;
        }

        public boolean hasError() {
            return this.myError != null;
        }
    }
}

