/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager.legacy;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.devices.Device;
import com.android.sdklib.repositoryv2.targets.SystemImageManager;
import com.android.tools.idea.avdmanager.AvdEditWizard;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.sdkv2.StudioLoggerProgressIndicator;
import com.android.tools.idea.wizard.dynamic.ScopedDataBinder;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkinChooser
extends ComboboxWithBrowseButton
implements ItemListener,
ItemSelectable {
    private List<ItemListener> myListeners = Lists.newArrayList();
    private static final ProgressIndicator LOGGER = new StudioLoggerProgressIndicator(SkinChooser.class);

    public SkinChooser(@Nullable Project project) {
        this.setItems(SkinChooser.getSkins());
        this.getComboBox().setRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                File skinFile = (File)value;
                String skinPath = skinFile.getPath();
                if (skinFile.equals(AvdWizardConstants.NO_SKIN)) {
                    this.append("No Skin");
                } else if (skinPath.contains("/sdk/platforms/")) {
                    this.append(skinPath.replaceAll(".*/sdk/platforms/(.*)/skins/(.*)", "$2 ($1)"));
                } else if (skinPath.contains("/sdk/system-images/")) {
                    this.append(skinPath.replaceAll(".*/sdk/system-images/(.*)/(.*)/(.*)/skins/(.*)", "$4 ($1 $3)"));
                } else {
                    this.append(skinFile.getName());
                }
            }
        });
        FileChooserDescriptor skinChooserDescriptor = new FileChooserDescriptor(false, true, false, false, false, false);
        this.addBrowseFolderListener("Select Custom Skin", "Select the directory containing your custom skin definition", project, skinChooserDescriptor, (TextComponentAccessor)new TextComponentAccessor<JComboBox>(){

            public String getText(JComboBox component) {
                return ((File)component.getSelectedItem()).getPath();
            }

            public void setText(JComboBox component, @NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/avdmanager/legacy/SkinChooser$2", "setText"));
                }
                List items = SkinChooser.getSkins();
                File f = new File(text);
                items.add(f);
                SkinChooser.this.setItems(items);
                SkinChooser.this.getComboBox().setSelectedItem(f);
            }
        });
        this.getComboBox().addItemListener(this);
        this.setTextFieldPreferredWidth(20);
    }

    private void setItems(List<File> items) {
        this.getComboBox().setModel(new CollectionComboBoxModel(items));
    }

    private static List<File> getSkins() {
        List<Device> devices = DeviceManagerConnection.getDefaultDeviceManagerConnection().getDevices();
        TreeSet result = Sets.newTreeSet();
        for (Device device : devices) {
            File skinFile = AvdEditWizard.resolveSkinPath(device.getDefaultHardware().getSkinFile(), null, FileOpUtils.create());
            if (skinFile == null || !skinFile.exists()) continue;
            result.add(skinFile);
        }
        SystemImageManager systemImageManager = AndroidSdkUtils.tryToChooseSdkHandler().getSystemImageManager(LOGGER);
        for (ISystemImage image : systemImageManager.getImages()) {
            for (File skin : image.getSkins()) {
                if (!skin.exists()) continue;
                result.add(skin);
            }
        }
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(AvdWizardConstants.NO_SKIN);
        arrayList.addAll(result);
        return arrayList;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemEvent newEvent = new ItemEvent(this, e.getID(), e.getItem(), e.getStateChange());
        for (ItemListener listener : this.myListeners) {
            listener.itemStateChanged(newEvent);
        }
    }

    public ScopedDataBinder.ComponentBinding<File, SkinChooser> getBinding() {
        return new ScopedDataBinder.ComponentBinding<File, SkinChooser>(){

            @Override
            public void addItemListener(@NotNull ItemListener listener, @NotNull SkinChooser component) {
                if (listener == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/avdmanager/legacy/SkinChooser$3", "addItemListener"));
                }
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/legacy/SkinChooser$3", "addItemListener"));
                }
                SkinChooser.this.myListeners.add(listener);
            }

            @Override
            public void setValue(@Nullable File newValue, @NotNull SkinChooser component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/legacy/SkinChooser$3", "setValue"));
                }
                component.getComboBox().setSelectedItem(newValue);
            }

            @Override
            @Nullable
            public File getValue(@NotNull SkinChooser component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/legacy/SkinChooser$3", "getValue"));
                }
                return (File)component.getComboBox().getSelectedItem();
            }
        };
    }

    @Override
    public Object[] getSelectedObjects() {
        return this.getComboBox().getSelectedObjects();
    }

    @Override
    public void addItemListener(ItemListener l) {
        this.getComboBox().addItemListener(l);
    }

    @Override
    public void removeItemListener(ItemListener l) {
        this.getComboBox().removeItemListener(l);
    }
}

