/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.tools.idea.avdmanager.AccelerationErrorCode;
import com.android.tools.idea.avdmanager.AccelerationErrorSolution;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.HyperlinkLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AccelerationErrorNotificationPanel
extends EditorNotificationPanel {
    public AccelerationErrorNotificationPanel(@NotNull AccelerationErrorCode error, @NotNull Project project, @Nullable Runnable refresh) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/avdmanager/AccelerationErrorNotificationPanel", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/avdmanager/AccelerationErrorNotificationPanel", "<init>"));
        }
        this.setText(error.getProblem());
        Runnable action = AccelerationErrorSolution.getActionForFix(error, project, refresh, null);
        HyperlinkLabel link = this.createActionLabel(error.getSolution().getDescription(), action);
        link.setToolTipText(error.getSolution() != AccelerationErrorSolution.SolutionCode.NONE ? error.getSolutionMessage() : null);
    }
}

