/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.gradle.util.Projects;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class AndroidStudioActionRemover
extends AnAction {
    @NotNull
    protected final AnAction myDelegate;

    public AndroidStudioActionRemover(@NotNull AnAction delegate, @NotNull String backupText) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/android/tools/idea/actions/AndroidStudioActionRemover", "<init>"));
        }
        if (backupText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backupText", "com/android/tools/idea/actions/AndroidStudioActionRemover", "<init>"));
        }
        super(delegate.getTemplatePresentation().getTextWithMnemonic(), delegate.getTemplatePresentation().getDescription(), delegate.getTemplatePresentation().getIcon());
        this.myDelegate = delegate;
        Presentation presentation = this.getTemplatePresentation();
        if (StringUtil.isEmpty((String)presentation.getText())) {
            presentation.setText(backupText);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        this.myDelegate.actionPerformed(e);
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (project != null && Projects.requiresAndroidModel(project)) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        this.copyTextAndIcon(this.getTemplatePresentation(), this.myDelegate.getTemplatePresentation());
        this.myDelegate.update(e);
    }

    protected void copyTextAndIcon(@NotNull Presentation source, @NotNull Presentation destination) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/android/tools/idea/actions/AndroidStudioActionRemover", "copyTextAndIcon"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/android/tools/idea/actions/AndroidStudioActionRemover", "copyTextAndIcon"));
        }
        destination.setText(source.getTextWithMnemonic());
        destination.setIcon(source.getIcon());
    }
}

