/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.jps.model.impl;

import com.android.tools.idea.jps.AndroidGradleJps;
import com.android.tools.idea.jps.model.JpsAndroidGradleModuleExtension;
import com.android.tools.idea.jps.model.impl.JpsAndroidGradleModuleExtensionImpl;
import com.android.tools.idea.jps.model.impl.JpsAndroidGradleModuleProperties;
import com.google.common.collect.ImmutableList;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.JpsAndroidSdkProperties;
import org.jetbrains.jps.android.model.JpsAndroidSdkType;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.facet.JpsFacetConfigurationSerializer;
import org.jetbrains.jps.model.serialization.library.JpsSdkPropertiesSerializer;

public class JpsAndroidGradleModelSerializerExtension
extends JpsModelSerializerExtension {
    private static final List<? extends JpsFacetConfigurationSerializer<JpsAndroidGradleModuleExtension>> FACET_PROPERTY_LOADERS = ImmutableList.of((Object)((Object)new JpsAndroidGradleFacetConfigurationSerializer()));
    private static final JpsAndroidSdkPropertiesSerializer SDK_PROPERTY_LOADER = new JpsAndroidSdkPropertiesSerializer();
    private static final String EXTERNAL_SYSTEM_ID_ATTRIBUTE = "external.system.id";
    private static final String GRADLE_EXTERNAL_SYSTEM_ID = "GRADLE";

    @NotNull
    public List<? extends JpsFacetConfigurationSerializer<?>> getFacetConfigurationSerializers() {
        List<? extends JpsFacetConfigurationSerializer<JpsAndroidGradleModuleExtension>> list = FACET_PROPERTY_LOADERS;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/jps/model/impl/JpsAndroidGradleModelSerializerExtension", "getFacetConfigurationSerializers"));
        }
        return list;
    }

    public void loadModuleOptions(@NotNull JpsModule module, @NotNull Element rootElement) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/jps/model/impl/JpsAndroidGradleModelSerializerExtension", "loadModuleOptions"));
        }
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/android/tools/idea/jps/model/impl/JpsAndroidGradleModelSerializerExtension", "loadModuleOptions"));
        }
        String externalSystemId = rootElement.getAttributeValue(EXTERNAL_SYSTEM_ID_ATTRIBUTE);
        if (GRADLE_EXTERNAL_SYSTEM_ID.equals(externalSystemId)) {
            AndroidGradleJps.getOrCreateGradleSystemExtension(module);
        }
    }

    public void saveModuleOptions(@NotNull JpsModule module, @NotNull Element rootElement) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/jps/model/impl/JpsAndroidGradleModelSerializerExtension", "saveModuleOptions"));
        }
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/android/tools/idea/jps/model/impl/JpsAndroidGradleModelSerializerExtension", "saveModuleOptions"));
        }
        if (AndroidGradleJps.getGradleSystemExtension(module) != null) {
            rootElement.setAttribute(EXTERNAL_SYSTEM_ID_ATTRIBUTE, GRADLE_EXTERNAL_SYSTEM_ID);
        }
    }

    @NotNull
    public List<? extends JpsSdkPropertiesSerializer<?>> getSdkPropertiesSerializers() {
        ImmutableList immutableList = ImmutableList.of((Object)((Object)SDK_PROPERTY_LOADER));
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/jps/model/impl/JpsAndroidGradleModelSerializerExtension", "getSdkPropertiesSerializers"));
        }
        return immutableList;
    }

    private static class JpsAndroidSdkPropertiesSerializer
    extends JpsSdkPropertiesSerializer<JpsSimpleElement<JpsAndroidSdkProperties>> {
        private static final String JDK_ATTR = "jdk";
        private static final String SDK_ATTR = "sdk";

        JpsAndroidSdkPropertiesSerializer() {
            super("Android SDK", (JpsSdkType)JpsAndroidSdkType.INSTANCE);
        }

        @NotNull
        public JpsSimpleElement<JpsAndroidSdkProperties> loadProperties(@Nullable Element propertiesElement) {
            String buildTarget = null;
            String jdkName = null;
            if (propertiesElement != null) {
                buildTarget = propertiesElement.getAttributeValue(SDK_ATTR);
                jdkName = propertiesElement.getAttributeValue(JDK_ATTR);
            }
            JpsSimpleElement jpsSimpleElement = JpsElementFactory.getInstance().createSimpleElement((Object)new JpsAndroidSdkProperties(buildTarget, jdkName));
            if (jpsSimpleElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/jps/model/impl/JpsAndroidGradleModelSerializerExtension$JpsAndroidSdkPropertiesSerializer", "loadProperties"));
            }
            return jpsSimpleElement;
        }

        public void saveProperties(@NotNull JpsSimpleElement<JpsAndroidSdkProperties> properties, @NotNull Element element) {
            String buildTarget;
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/jps/model/impl/JpsAndroidGradleModelSerializerExtension$JpsAndroidSdkPropertiesSerializer", "saveProperties"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/jps/model/impl/JpsAndroidGradleModelSerializerExtension$JpsAndroidSdkPropertiesSerializer", "saveProperties"));
            }
            String jdkName = ((JpsAndroidSdkProperties)properties.getData()).getJdkName();
            if (jdkName != null) {
                element.setAttribute(JDK_ATTR, jdkName);
            }
            if ((buildTarget = ((JpsAndroidSdkProperties)properties.getData()).getBuildTargetHashString()) != null) {
                element.setAttribute(SDK_ATTR, buildTarget);
            }
        }
    }

    private static class JpsAndroidGradleFacetConfigurationSerializer
    extends JpsFacetConfigurationSerializer<JpsAndroidGradleModuleExtension> {
        JpsAndroidGradleFacetConfigurationSerializer() {
            super(JpsAndroidGradleModuleExtensionImpl.KIND, "android-gradle", "Android-Gradle");
        }

        protected JpsAndroidGradleModuleExtension loadExtension(@NotNull Element facetConfigurationElement, String name, JpsElement parent, JpsModule module) {
            if (facetConfigurationElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetConfigurationElement", "com/android/tools/idea/jps/model/impl/JpsAndroidGradleModelSerializerExtension$JpsAndroidGradleFacetConfigurationSerializer", "loadExtension"));
            }
            JpsAndroidGradleModuleProperties properties = (JpsAndroidGradleModuleProperties)XmlSerializer.deserialize((Element)facetConfigurationElement, JpsAndroidGradleModuleProperties.class);
            return new JpsAndroidGradleModuleExtensionImpl(properties);
        }

        protected void saveExtension(JpsAndroidGradleModuleExtension extension, Element facetConfigurationTag, JpsModule module) {
            XmlSerializer.serializeInto((Object)extension.getProperties(), (Element)facetConfigurationTag);
        }
    }
}

