/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.developerprojects;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Data;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.developerprojects.DeveloperprojectsRequest;
import com.google.api.services.developerprojects.DeveloperprojectsRequestInitializer;
import com.google.api.services.developerprojects.model.ListProjectsResponse;
import com.google.api.services.developerprojects.model.Project;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Developerprojects
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "developerprojects/v1/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/developerprojects/v1/";

    public Developerprojects(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Developerprojects(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.19.0 of the Developer Projects API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Developerprojects.DEFAULT_ROOT_URL, Developerprojects.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Developerprojects build() {
            return new Developerprojects(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setDeveloperprojectsRequestInitializer(DeveloperprojectsRequestInitializer developerprojectsRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)developerprojectsRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public Create create(Project content) throws IOException {
            Create result = new Create(content);
            Developerprojects.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String projectId) throws IOException {
            Get result = new Get(projectId);
            Developerprojects.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Developerprojects.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DeveloperprojectsRequest<ListProjectsResponse> {
            private static final String REST_PATH = "projects";
            @Key
            private String pageToken;
            @Key(value="retrievalOptions.fieldMask")
            private java.util.List<String> retrievalOptionsFieldMask;
            @Key
            private Integer pageSize;
            @Key
            private String query;

            protected List() {
                super(Developerprojects.this, "GET", REST_PATH, null, ListProjectsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public java.util.List<String> getRetrievalOptionsFieldMask() {
                return this.retrievalOptionsFieldMask;
            }

            public List setRetrievalOptionsFieldMask(java.util.List<String> retrievalOptionsFieldMask) {
                this.retrievalOptionsFieldMask = retrievalOptionsFieldMask;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getQuery() {
                return this.query;
            }

            public List setQuery(String query) {
                this.query = query;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DeveloperprojectsRequest<Project> {
            private static final String REST_PATH = "projects/{projectId}";
            @Key
            private String projectId;
            @Key(value="options.fieldMask")
            private java.util.List<String> optionsFieldMask;

            protected Get(String projectId) {
                super(Developerprojects.this, "GET", REST_PATH, null, Project.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            public java.util.List<String> getOptionsFieldMask() {
                return this.optionsFieldMask;
            }

            public Get setOptionsFieldMask(java.util.List<String> optionsFieldMask) {
                this.optionsFieldMask = optionsFieldMask;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends DeveloperprojectsRequest<Project> {
            private static final String REST_PATH = "projects";
            @Key
            private Boolean createAppengineProject;
            @Key
            private String appengineStorageLocation;

            protected Create(Project content) {
                super(Developerprojects.this, "POST", REST_PATH, (Object)content, Project.class);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUserIp(String userIp) {
                return (Create)super.setUserIp(userIp);
            }

            public Boolean getCreateAppengineProject() {
                return this.createAppengineProject;
            }

            public Create setCreateAppengineProject(Boolean createAppengineProject) {
                this.createAppengineProject = createAppengineProject;
                return this;
            }

            public boolean isCreateAppengineProject() {
                if (this.createAppengineProject == null || this.createAppengineProject == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.createAppengineProject;
            }

            public String getAppengineStorageLocation() {
                return this.appengineStorageLocation;
            }

            public Create setAppengineStorageLocation(String appengineStorageLocation) {
                this.appengineStorageLocation = appengineStorageLocation;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }
}

