/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.schema;

import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.schema.Constant;
import com.android.tools.rpclib.schema.Type;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ConstantSet {
    private Type mType;
    private Constant[] mEntries;
    private HashMap<Object, List<Constant>> byValue;
    private HashMap<String, List<Constant>> byStrValue;
    private static final HashMap<Type, ConstantSet> mRegistry = new HashMap();

    public static void register(ConstantSet set) {
        mRegistry.put(set.getType(), set);
    }

    public static ConstantSet lookup(Type type) {
        return mRegistry.get(type);
    }

    public ConstantSet(@NotNull Decoder d) throws IOException {
        if (d == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/android/tools/rpclib/schema/ConstantSet", "<init>"));
        }
        this.mType = Type.decode(d);
        this.mEntries = new Constant[d.uint32()];
        for (int i = 0; i < this.mEntries.length; ++i) {
            this.mEntries[i] = new Constant();
            this.mEntries[i].mName = d.string();
            this.mEntries[i].mValue = this.mType.decodeValue(d);
        }
    }

    public Type getType() {
        return this.mType;
    }

    public Constant[] getEntries() {
        return this.mEntries;
    }

    private HashMap<Object, List<Constant>> byValue() {
        if (this.byValue == null) {
            this.byValue = new HashMap();
            for (Constant constant : this.mEntries) {
                List<Object> list;
                if (!this.byValue.containsKey(constant.getValue())) {
                    list = new ArrayList();
                    this.byValue.put(constant.getValue(), list);
                } else {
                    list = this.byValue.get(constant.getValue());
                }
                list.add(constant);
            }
        }
        return this.byValue;
    }

    private HashMap<String, List<Constant>> byStrValue() {
        if (this.byStrValue == null) {
            this.byStrValue = new HashMap();
            for (Constant constant : this.mEntries) {
                List<Object> list;
                String strVal = constant.getValue().toString();
                if (!this.byStrValue.containsKey(strVal)) {
                    list = new ArrayList();
                    this.byStrValue.put(strVal, list);
                } else {
                    list = this.byStrValue.get(strVal);
                }
                list.add(constant);
            }
        }
        return this.byStrValue;
    }

    public List<Constant> getByValue(Object value) {
        if (this.mEntries.length == 0) {
            return null;
        }
        if (this.mEntries[0].getClass() == value.getClass()) {
            return this.byValue().get(value);
        }
        return this.byStrValue().get(value.toString());
    }

    public void encode(@NotNull Encoder e) throws IOException {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/rpclib/schema/ConstantSet", "encode"));
        }
        this.mType.encode(e);
        for (Constant mEntry : this.mEntries) {
            e.string(mEntry.mName);
            this.mType.encodeValue(e, mEntry.mValue);
        }
    }
}

