/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.util.Collections;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.BooleanLiteral;
import lombok.ast.ClassDeclaration;
import lombok.ast.Expression;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.NormalTypeBody;
import lombok.ast.Return;
import lombok.ast.Throw;

public class BadHostnameVerifierDetector
extends Detector
implements Detector.JavaScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(BadHostnameVerifierDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("BadHostnameVerifier", "Insecure HostnameVerifier", "This check looks for implementations of `HostnameVerifier` whose `verify` method always returns true (thus trusting any hostname) which could result in insecure network traffic caused by trusting arbitrary hostnames in TLS/SSL certificates presented by peers.", Category.SECURITY, 6, Severity.WARNING, IMPLEMENTATION);

    @Override
    public List<String> applicableSuperClasses() {
        return Collections.singletonList("javax.net.ssl.HostnameVerifier");
    }

    @Override
    public void checkClass(JavaContext context, ClassDeclaration node, Node declarationOrAnonymous, JavaParser.ResolvedClass cls) {
        NormalTypeBody body;
        if (declarationOrAnonymous instanceof NormalTypeBody) {
            body = (NormalTypeBody)declarationOrAnonymous;
        } else if (node != null) {
            body = node.astBody();
        } else {
            return;
        }
        for (Node member : body.astMembers()) {
            JavaParser.ResolvedMethod method;
            JavaParser.ResolvedNode resolved;
            MethodDeclaration declaration;
            if (!(member instanceof MethodDeclaration) || !"verify".equals((declaration = (MethodDeclaration)member).astMethodName().astValue()) || declaration.astParameters().size() != 2 || !((resolved = context.resolve((Node)declaration)) instanceof JavaParser.ResolvedMethod) || (method = (JavaParser.ResolvedMethod)resolved).getArgumentCount() != 2 || !method.getArgumentType(0).matchesName("java.lang.String") || !method.getArgumentType(1).matchesName("javax.net.ssl.SSLSession")) continue;
            ComplexVisitor visitor = new ComplexVisitor(context);
            declaration.accept((AstVisitor)visitor);
            if (visitor.isComplex()) {
                return;
            }
            Location location = context.getNameLocation((Node)declaration);
            String message = String.format("`%1$s` always returns `true`, which could cause insecure network traffic due to trusting TLS/SSL server certificates for wrong hostnames", method.getName());
            context.report(ISSUE, location, message);
            break;
        }
    }

    private static class ComplexVisitor
    extends ForwardingAstVisitor {
        private final JavaContext mContext;
        private boolean mComplex;

        public ComplexVisitor(JavaContext context) {
            this.mContext = context;
        }

        public boolean visitThrow(Throw node) {
            this.mComplex = true;
            return super.visitThrow(node);
        }

        public boolean visitMethodInvocation(MethodInvocation node) {
            this.mComplex = true;
            return super.visitMethodInvocation(node);
        }

        public boolean visitReturn(Return node) {
            Expression argument = node.astValue();
            if (argument != null) {
                this.mComplex = !(argument instanceof BooleanLiteral) || !Boolean.TRUE.equals(((BooleanLiteral)argument).astValue());
            }
            return super.visitReturn(node);
        }

        public boolean isComplex() {
            return this.mComplex;
        }
    }
}

