/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.fd.client;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.fd.client.AppState;
import com.android.tools.fd.client.ApplicationPatchUtil;
import com.android.tools.fd.client.Communicator;
import com.android.tools.fd.client.InstantRunArtifact;
import com.android.tools.fd.client.InstantRunArtifactType;
import com.android.tools.fd.client.InstantRunBuildInfo;
import com.android.tools.fd.client.InstantRunPushFailedException;
import com.android.tools.fd.client.UpdateMode;
import com.android.tools.fd.client.UserFeedback;
import com.android.tools.fd.runtime.ApplicationPatch;
import com.android.tools.fd.runtime.Paths;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class InstantRunClient {
    public static final String BROKEN_RUN_AS = "run-as command broken on this device";
    private static final String LOCAL_HOST = "127.0.0.1";
    private static final int DEFAULT_LOCAL_PORT = 46622;
    private static final String CLASSES_DEX_PREFIX = "classes";
    private static final String CLASSES_DEX_SUFFIX = ".dex";
    public static final boolean USE_BUILD_ID_TEMP_FILE = !Boolean.getBoolean("instantrun.use_datadir");
    private final UserFeedback mUserFeedback;
    private final ILogger mLogger;
    private final String mPackageName;
    private final long mToken;
    private final int mLocalPort;
    public static final int TRANSFER_MODE_SLICE = 1;
    public static final int TRANSFER_MODE_HOTSWAP = 3;
    public static final int TRANSFER_MODE_RESOURCES = 4;

    public InstantRunClient(String packageName, UserFeedback userFeedback, ILogger logger, long token) {
        this(packageName, userFeedback, logger, token, 46622);
    }

    @VisibleForTesting
    public InstantRunClient(String packageName, UserFeedback userFeedback, ILogger logger, long token, int port) {
        this.mPackageName = packageName;
        this.mUserFeedback = userFeedback;
        this.mLogger = logger;
        this.mToken = token;
        this.mLocalPort = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String copyToDeviceScratchFile(IDevice device, String pkgName, String contents) throws IOException, AdbCommandRejectedException, SyncException, TimeoutException {
        File local = null;
        try {
            local = InstantRunClient.createTempFile("data", "fdr");
            Files.write((byte[])contents.getBytes(Charsets.UTF_8), (File)local);
            String string = InstantRunClient.copyToDeviceScratchFile(device, pkgName, local);
            return string;
        }
        finally {
            if (local != null) {
                local.delete();
            }
        }
    }

    private static String copyToDeviceScratchFile(IDevice device, String pkgName, File local) throws IOException, AdbCommandRejectedException, SyncException, TimeoutException {
        String remoteTmpBuildId = "/data/local/tmp/" + pkgName + "-data.fdr";
        device.pushFile(local.getAbsolutePath(), remoteTmpBuildId);
        return remoteTmpBuildId;
    }

    private static int getMaxDexFileNumber(String fileListing) {
        int max = -1;
        for (String name : Splitter.on((CharMatcher)CharMatcher.WHITESPACE).omitEmptyStrings().splitToList((CharSequence)fileListing)) {
            if (!name.startsWith(CLASSES_DEX_PREFIX) || !name.endsWith(CLASSES_DEX_SUFFIX)) continue;
            String middle = name.substring(CLASSES_DEX_PREFIX.length(), name.length() - CLASSES_DEX_SUFFIX.length());
            try {
                int version = Integer.decode(middle);
                if (version <= max) continue;
                max = version;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return max;
    }

    private static File createTempFile(String prefix, String suffix) throws IOException {
        File file = File.createTempFile(prefix, suffix);
        file.deleteOnExit();
        return file;
    }

    public AppState getAppState(IDevice device) {
        try {
            return this.talkToApp(device, new Communicator<AppState>(){

                @Override
                public AppState communicate(DataInputStream input, DataOutputStream output) throws IOException {
                    output.writeInt(2);
                    boolean foreground = input.readBoolean();
                    InstantRunClient.this.mLogger.info("Ping sent and replied successfully, application seems to be running. Foreground=" + foreground, new Object[0]);
                    return foreground ? AppState.FOREGROUND : AppState.BACKGROUND;
                }
            }, AppState.NOT_RUNNING);
        }
        catch (Throwable e) {
            return AppState.NOT_RUNNING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T talkToApp(IDevice device, Communicator<T> communicator, T errorValue) {
        try {
            device.createForward(this.mLocalPort, this.mPackageName, IDevice.DeviceUnixSocketNamespace.ABSTRACT);
            try {
                T t = InstantRunClient.talkToAppWithinPortForward(communicator, errorValue, this.mLocalPort);
                return t;
            }
            catch (UnknownHostException e) {
                this.mLogger.warning("%s", new Object[]{Throwables.getStackTraceAsString((Throwable)e)});
                return errorValue;
            }
            catch (SocketException e) {
                if (e.getMessage().equals("Broken pipe")) {
                    this.mUserFeedback.error("No connection to app; cannot sync changes");
                    T t = errorValue;
                    return t;
                }
                this.mLogger.warning("%s", new Object[]{Throwables.getStackTraceAsString((Throwable)e)});
                return errorValue;
            }
            catch (IOException e) {
                this.mLogger.warning("%s", new Object[]{Throwables.getStackTraceAsString((Throwable)e)});
                return errorValue;
            }
            catch (Throwable e) {
                this.mLogger.warning("%s", new Object[]{Throwables.getStackTraceAsString((Throwable)e)});
                T t = errorValue;
                return t;
            }
            finally {
                device.removeForward(this.mLocalPort, this.mPackageName, IDevice.DeviceUnixSocketNamespace.ABSTRACT);
            }
        }
        catch (TimeoutException e) {
            this.mLogger.warning("%s", new Object[]{Throwables.getStackTraceAsString((Throwable)e)});
            return errorValue;
        }
        catch (AdbCommandRejectedException e) {
            this.mLogger.warning("%s", new Object[]{Throwables.getStackTraceAsString((Throwable)e)});
            return errorValue;
        }
        catch (Throwable e) {
            this.mLogger.warning("%s", new Object[]{Throwables.getStackTraceAsString((Throwable)e)});
        }
        return errorValue;
    }

    /*
     * Exception decompiling
     */
    private static <T> T talkToAppWithinPortForward(Communicator<T> communicator, T errorValue, int localPort) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void showToast(IDevice device, final String message) {
        try {
            this.talkToApp(device, new Communicator<Boolean>(){

                @Override
                public Boolean communicate(DataInputStream input, DataOutputStream output) throws IOException {
                    output.writeInt(6);
                    output.writeUTF(message);
                    return false;
                }
            }, true);
        }
        catch (Throwable e) {
            this.mLogger.warning("%s", new Object[]{Throwables.getStackTraceAsString((Throwable)e)});
        }
    }

    public void restartActivity(IDevice device) {
        AppState appState = this.getAppState(device);
        if (appState == AppState.FOREGROUND || appState == AppState.BACKGROUND) {
            this.talkToApp(device, new Communicator<Boolean>(){

                @Override
                public Boolean communicate(DataInputStream input, DataOutputStream output) throws IOException {
                    output.writeInt(5);
                    InstantRunClient.this.writeToken(output);
                    return false;
                }
            }, true);
        }
    }

    public UpdateMode pushPatches(IDevice device, InstantRunBuildInfo buildInfo, UpdateMode updateMode, boolean isRestartActivity, boolean isShowToastEnabled) throws InstantRunPushFailedException {
        boolean needRestart;
        if (!buildInfo.canHotswap()) {
            updateMode = updateMode.combine(UpdateMode.COLD_SWAP);
        }
        ArrayList files = Lists.newArrayList();
        AppState appState = this.getAppState(device);
        boolean appInForeground = appState == AppState.FOREGROUND;
        boolean appRunning = appState == AppState.FOREGROUND || appState == AppState.BACKGROUND;
        List<InstantRunArtifact> artifacts = buildInfo.getArtifacts();
        block9: for (InstantRunArtifact artifact : artifacts) {
            InstantRunArtifactType type = artifact.type;
            Object file = artifact.file;
            switch (type) {
                case MAIN: 
                case SPLIT_MAIN: {
                    continue block9;
                }
                case SPLIT: {
                    assert (false) : artifact;
                    continue block9;
                }
                case RESOURCES: {
                    updateMode = updateMode.combine(UpdateMode.WARM_SWAP);
                    files.add(FileTransfer.createResourceFile((File)file));
                    continue block9;
                }
                case DEX: {
                    String name = ((File)file).getParentFile().getName() + "-" + ((File)file).getName();
                    files.add(FileTransfer.createSliceDex((File)file, name));
                    continue block9;
                }
                case RELOAD_DEX: {
                    if (appInForeground) {
                        files.add(FileTransfer.createHotswapPatch((File)file));
                        continue block9;
                    }
                    if (buildInfo.hasOneOf(InstantRunArtifactType.DEX, InstantRunArtifactType.SPLIT)) continue block9;
                    throw new InstantRunPushFailedException("Can't apply hot swap patch: app is no longer running");
                }
            }
            assert (false) : artifact;
        }
        if (appRunning) {
            ArrayList<ApplicationPatch> changes = new ArrayList<ApplicationPatch>(files.size());
            for (Object file : files) {
                try {
                    changes.add(((FileTransfer)file).getPatch());
                }
                catch (IOException e) {
                    throw new InstantRunPushFailedException("Could not read file " + file);
                }
            }
            this.pushPatches(device, buildInfo.getTimeStamp(), changes, updateMode, isRestartActivity, isShowToastEnabled);
            needRestart = false;
            if (!appInForeground || !buildInfo.canHotswap()) {
                this.stopApp(device, false);
                needRestart = true;
            }
        } else {
            this.pushFiles(files, device, buildInfo.getTimeStamp());
            needRestart = true;
        }
        this.logFilesPushed(files, needRestart);
        if (needRestart) {
            return UpdateMode.COLD_SWAP;
        }
        return updateMode;
    }

    public void pushPatches(IDevice device, String buildId, final List<ApplicationPatch> changes, UpdateMode updateMode, boolean isRestartActivity, final boolean isShowToastEnabled) {
        if (changes.isEmpty() || updateMode == UpdateMode.NO_CHANGES) {
            if (device != null) {
                this.transferLocalIdToDeviceId(device, buildId);
            }
            this.mUserFeedback.noChanges();
            return;
        }
        if (updateMode == UpdateMode.HOT_SWAP && isRestartActivity) {
            updateMode = updateMode.combine(UpdateMode.WARM_SWAP);
        }
        if (device != null) {
            final UpdateMode updateMode1 = updateMode;
            this.talkToApp(device, new Communicator<Boolean>(){

                @Override
                public Boolean communicate(DataInputStream input, DataOutputStream output) throws IOException {
                    output.writeInt(1);
                    InstantRunClient.this.writeToken(output);
                    ApplicationPatchUtil.write(output, changes, updateMode1);
                    output.writeBoolean(isShowToastEnabled);
                    input.readBoolean();
                    return false;
                }

                @Override
                int getTimeout() {
                    return 8000;
                }
            }, true);
            this.transferLocalIdToDeviceId(device, buildId);
        }
        this.mUserFeedback.notifyEnd(updateMode);
    }

    public void transferLocalIdToDeviceId(IDevice device, String buildId) {
        InstantRunClient.transferBuildIdToDevice(device, buildId, this.mPackageName, this.mLogger);
    }

    public static void transferBuildIdToDevice(IDevice device, String buildId, String applicationId, ILogger logger) {
        if (logger == null) {
            logger = new NullLogger();
        }
        try {
            if (USE_BUILD_ID_TEMP_FILE) {
                String remoteIdFile = Paths.getDeviceIdFolder(applicationId);
                File local = File.createTempFile("build-id", "txt");
                local.deleteOnExit();
                Files.write((CharSequence)buildId, (File)local, (Charset)Charsets.UTF_8);
                device.pushFile(local.getPath(), remoteIdFile);
            } else {
                String remote = InstantRunClient.copyToDeviceScratchFile(device, applicationId, buildId);
                String dataDir = Paths.getDataDirectory(applicationId);
                String cmd = "run-as " + applicationId + " mkdir -p " + dataDir + "; cat " + remote + " | run-as " + applicationId + " sh -c 'cat > " + dataDir + "/" + "build-id.txt" + "'";
                CollectingOutputReceiver receiver = new CollectingOutputReceiver();
                device.executeShellCommand(cmd, receiver);
                String output = receiver.getOutput();
                if (!output.trim().isEmpty()) {
                    logger.warning("Unexpected shell output: " + output, new Object[0]);
                }
            }
        }
        catch (IOException ioe) {
            logger.warning("Couldn't write build id file: %s", new Object[]{ioe});
        }
        catch (AdbCommandRejectedException e) {
            logger.warning("%s", new Object[]{Throwables.getStackTraceAsString((Throwable)e)});
        }
        catch (TimeoutException e) {
            logger.warning("%s", new Object[]{Throwables.getStackTraceAsString((Throwable)e)});
        }
        catch (ShellCommandUnresponsiveException e) {
            logger.warning("%s", new Object[]{Throwables.getStackTraceAsString((Throwable)e)});
        }
        catch (SyncException e) {
            logger.warning("%s", new Object[]{Throwables.getStackTraceAsString((Throwable)e)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDeviceBuildTimestamp(IDevice device) {
        try {
            if (USE_BUILD_ID_TEMP_FILE) {
                String remoteIdFile = Paths.getDeviceIdFolder(this.mPackageName);
                File localIdFile = InstantRunClient.createTempFile("build-id", "txt");
                try {
                    device.pullFile(remoteIdFile, localIdFile.getPath());
                    String string = Files.toString((File)localIdFile, (Charset)Charsets.UTF_8).trim();
                    return string;
                }
                catch (SyncException ignore) {
                    String string = null;
                    return string;
                }
                finally {
                    localIdFile.delete();
                }
            }
            String remoteIdFile = Paths.getDataDirectory(this.mPackageName) + "/" + "build-id.txt";
            CollectingOutputReceiver receiver = new CollectingOutputReceiver();
            device.executeShellCommand("run-as " + this.mPackageName + " cat " + remoteIdFile, receiver);
            String output = receiver.getOutput().trim();
            if (!output.contains(":")) {
                return output;
            }
            if (output.startsWith(remoteIdFile)) {
                return null;
            }
            String remoteTmpFile = "/data/local/tmp/build-id.txt";
            device.executeShellCommand("cp " + remoteIdFile + " " + remoteTmpFile, receiver);
            output = receiver.getOutput().trim();
            if (!output.isEmpty()) {
                this.mLogger.info(output, new Object[0]);
            }
            File localIdFile = InstantRunClient.createTempFile("build-id", "txt");
            device.pullFile(remoteTmpFile, localIdFile.getPath());
            String id = Files.toString((File)localIdFile, (Charset)Charsets.UTF_8).trim();
            localIdFile.delete();
            return id;
        }
        catch (IOException remoteIdFile) {
            return null;
        }
        catch (AdbCommandRejectedException e) {
            this.mLogger.warning("%s", new Object[]{Throwables.getStackTraceAsString((Throwable)e)});
            return null;
        }
        catch (SyncException e) {
            this.mLogger.warning("%s", new Object[]{Throwables.getStackTraceAsString((Throwable)e)});
            return null;
        }
        catch (TimeoutException e) {
            this.mLogger.warning("%s", new Object[]{Throwables.getStackTraceAsString((Throwable)e)});
            return null;
        }
        catch (ShellCommandUnresponsiveException e) {
            this.mLogger.warning("%s", new Object[]{Throwables.getStackTraceAsString((Throwable)e)});
        }
        return null;
    }

    private void writeToken(DataOutputStream output) throws IOException {
        output.writeLong(this.mToken);
    }

    public void stopApp(IDevice device, boolean sendChangeBroadcast) throws InstantRunPushFailedException {
        try {
            this.runCommand(device, "am force-stop " + this.mPackageName);
        }
        catch (Throwable t) {
            throw new InstantRunPushFailedException("Exception while stopping app: " + t.toString());
        }
        if (sendChangeBroadcast) {
            try {
                this.runCommand(device, "am broadcast -a android.intent.action.PACKAGE_CHANGED -p " + this.mPackageName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void pushFiles(List<FileTransfer> files, IDevice device, String buildId) throws InstantRunPushFailedException {
        try {
            HashSet createdDirs = Sets.newHashSet();
            for (FileTransfer file : files) {
                String cmd;
                String name;
                String folder;
                switch (file.mode) {
                    case 1: {
                        folder = Paths.getDexFileDirectory(this.mPackageName);
                        name = "slice-" + file.name;
                        break;
                    }
                    case 4: {
                        folder = Paths.getInboxDirectory(this.mPackageName);
                        name = "resources.ap_";
                        break;
                    }
                    case 3: {
                        throw new IllegalArgumentException("Hotswap patches can only be applied when the app is running");
                    }
                    default: {
                        throw new IllegalArgumentException(Integer.toString(file.mode));
                    }
                }
                String remote = InstantRunClient.copyToDeviceScratchFile(device, this.mPackageName, file.source);
                if (!createdDirs.contains(folder)) {
                    createdDirs.add(folder);
                    cmd = "run-as " + this.mPackageName + " mkdir -p " + folder;
                    if (!this.runAsCommand(device, cmd)) {
                        this.mLogger.warning("pushFiles: %s", new Object[]{"Error creating folder with: " + cmd});
                        throw new InstantRunPushFailedException("Error creating folder with: " + cmd);
                    }
                }
                if (this.runAsCommand(device, cmd = "run-as " + this.mPackageName + " cp " + remote + " " + folder + "/" + name)) continue;
                this.mLogger.warning("pushFiles: %s", new Object[]{"Error copying file with: " + cmd});
                throw new InstantRunPushFailedException("Error copying file with: " + cmd);
            }
            this.transferLocalIdToDeviceId(device, buildId);
        }
        catch (IOException ioe) {
            this.mLogger.warning("Couldn't write build id file: %s", new Object[]{ioe});
            throw new InstantRunPushFailedException("IOException while pushing files: " + ioe.toString());
        }
        catch (AdbCommandRejectedException e) {
            this.mLogger.warning("%s", new Object[]{Throwables.getStackTraceAsString((Throwable)e)});
            throw new InstantRunPushFailedException("Exception while pushing files: " + e.toString());
        }
        catch (TimeoutException e) {
            this.mLogger.warning("%s", new Object[]{Throwables.getStackTraceAsString((Throwable)e)});
            throw new InstantRunPushFailedException("Exception while pushing files: " + e.toString());
        }
        catch (ShellCommandUnresponsiveException e) {
            this.mLogger.warning("%s", new Object[]{Throwables.getStackTraceAsString((Throwable)e)});
            throw new InstantRunPushFailedException("Exception while pushing files: " + e.toString());
        }
        catch (SyncException e) {
            this.mLogger.warning("%s", new Object[]{Throwables.getStackTraceAsString((Throwable)e)});
            throw new InstantRunPushFailedException("Exception while pushing files: " + e.toString());
        }
    }

    private boolean runAsCommand(IDevice device, String cmd) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, InstantRunPushFailedException {
        String output = InstantRunClient.getCommandOutput(device, cmd).trim();
        if (!output.isEmpty()) {
            this.mLogger.warning("Unexpected shell output for " + cmd + ": " + output, new Object[0]);
            if (output.startsWith("run-as: Package '") && output.endsWith("' is unknown")) {
                throw new InstantRunPushFailedException(BROKEN_RUN_AS);
            }
            return false;
        }
        return true;
    }

    private boolean runCommand(IDevice device, String cmd) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        String output = InstantRunClient.getCommandOutput(device, cmd).trim();
        if (!output.isEmpty()) {
            this.mLogger.warning("Unexpected shell output for " + cmd + ": " + output, new Object[0]);
            return false;
        }
        return true;
    }

    private static String getCommandOutput(IDevice device, String cmd) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        device.executeShellCommand(cmd, receiver);
        return receiver.getOutput();
    }

    private void logFilesPushed(List<FileTransfer> files, boolean needRestart) {
        StringBuilder sb = new StringBuilder("Pushing files: ");
        if (needRestart) {
            sb.append("(needs restart) ");
        }
        sb.append('[');
        String separator = "";
        for (FileTransfer file : files) {
            sb.append(separator);
            sb.append(file.source.getName());
            sb.append(" as ");
            sb.append(file.name);
            separator = ", ";
        }
        sb.append(']');
        this.mLogger.info(sb.toString(), new Object[0]);
    }

    public static class FileTransfer {
        public final int mode;
        public final File source;
        public final String name;

        public FileTransfer(int mode, File source, String name) {
            this.mode = mode;
            this.source = source;
            this.name = name;
        }

        public static FileTransfer createSliceDex(File source, String name) {
            return new FileTransfer(1, source, name);
        }

        public static FileTransfer createResourceFile(File source) {
            return new FileTransfer(4, source, "resources.ap_");
        }

        public static FileTransfer createHotswapPatch(File source) {
            return new FileTransfer(3, source, "classes.dex.3");
        }

        public ApplicationPatch getPatch() throws IOException {
            String path;
            byte[] bytes = Files.toByteArray((File)this.source);
            switch (this.mode) {
                case 1: {
                    path = "slice-" + this.name;
                    break;
                }
                case 3: 
                case 4: {
                    path = this.name;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Integer.toString(this.mode));
                }
            }
            return new ApplicationPatch(path, bytes);
        }

        public String toString() {
            return this.source + " as " + this.name + " with mode " + this.mode;
        }
    }
}

