/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.chartlib;

import java.util.AbstractList;

class CircularArrayList<T>
extends AbstractList<T> {
    private final T[] mData;
    private int mSize;
    private int mStart;

    CircularArrayList(int alloc) {
        this.mData = new Object[alloc];
        this.mSize = 0;
        this.mStart = 0;
    }

    @Override
    public T get(int i) {
        if (i < 0 || i >= this.mSize) {
            throw new IndexOutOfBoundsException();
        }
        return this.mData[(this.mStart + i) % this.mSize];
    }

    @Override
    public boolean add(T t) {
        if (this.mSize == this.mData.length) {
            this.mData[this.mStart] = t;
            this.mStart = (this.mStart + 1) % this.mSize;
        } else {
            this.mData[this.mSize] = t;
            ++this.mSize;
        }
        return true;
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public void clear() {
        this.mStart = 0;
        this.mSize = 0;
    }
}

