/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ResourceItem
implements Comparable<ResourceItem> {
    private static final Comparator<ResourceFile> sComparator = new Comparator<ResourceFile>(){

        @Override
        public int compare(ResourceFile file1, ResourceFile file2) {
            FolderConfiguration fc1 = file1.getFolder().getConfiguration();
            FolderConfiguration fc2 = file2.getFolder().getConfiguration();
            return fc1.compareTo(fc2);
        }
    };
    private final String mName;
    private final List<ResourceFile> mFiles = new ArrayList<ResourceFile>();

    public ResourceItem(String name) {
        this.mName = name;
    }

    public final String getName() {
        return this.mName;
    }

    @Override
    public int compareTo(ResourceItem other) {
        return this.mName.compareTo(other.mName);
    }

    public boolean isEditableDirectly() {
        return !this.hasAlternates();
    }

    public boolean isDeclaredInline() {
        return false;
    }

    public ResourceValue getResourceValue(ResourceType type, FolderConfiguration referenceConfig, boolean isFramework) {
        ResourceFile match = (ResourceFile)referenceConfig.findMatchingConfigurable(this.mFiles);
        if (match != null) {
            return match.getValue(type, this.mName);
        }
        return null;
    }

    protected void add(ResourceFile file) {
        this.mFiles.add(file);
    }

    protected void removeFile(ResourceFile file) {
        this.mFiles.remove(file);
    }

    protected boolean hasNoSourceFile() {
        return this.mFiles.isEmpty();
    }

    protected void reset() {
        this.mFiles.clear();
    }

    public ResourceFile[] getSourceFileArray() {
        ArrayList<ResourceFile> list = new ArrayList<ResourceFile>();
        list.addAll(this.mFiles);
        Collections.sort(list, sComparator);
        return list.toArray(new ResourceFile[list.size()]);
    }

    public List<ResourceFile> getSourceFileList() {
        return Collections.unmodifiableList(this.mFiles);
    }

    public boolean hasAlternates() {
        for (ResourceFile file : this.mFiles) {
            if (file.getFolder().getConfiguration().isDefault()) continue;
            return true;
        }
        return false;
    }

    public boolean hasDefault() {
        for (ResourceFile file : this.mFiles) {
            if (!file.getFolder().getConfiguration().isDefault()) continue;
            return true;
        }
        return this.mFiles.isEmpty();
    }

    public int getAlternateCount() {
        int count = 0;
        for (ResourceFile file : this.mFiles) {
            if (file.getFolder().getConfiguration().isDefault()) continue;
            ++count;
        }
        return count;
    }

    public String getXmlString(ResourceType type, boolean system) {
        if (type == ResourceType.ID && this.isDeclaredInline()) {
            return (system ? "@android:" : "@+") + type.getName() + "/" + this.mName;
        }
        return (system ? "@android:" : "@") + type.getName() + "/" + this.mName;
    }

    public String toString() {
        return "ResourceItem [mName=" + this.mName + ", mFiles=" + this.mFiles + "]";
    }
}

