/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.results.GoogleCloudTestProxy;
import com.intellij.execution.testframework.sm.runner.states.AbstractState;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GoogleCloudTestingScheduledState
extends AbstractState {
    private final GoogleCloudTestProxy myTestProxy;
    private boolean myDefectFound;
    private boolean isActive;

    public GoogleCloudTestingScheduledState(@NotNull GoogleCloudTestProxy testProxy) {
        if (testProxy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testProxy", "com/google/gct/testing/results/GoogleCloudTestingScheduledState", "<init>"));
        }
        this.myDefectFound = false;
        this.isActive = false;
        this.myTestProxy = testProxy;
    }

    public void makeActive() {
        this.isActive = true;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean wasLaunched() {
        return false;
    }

    public boolean isFinal() {
        return false;
    }

    public boolean isInProgress() {
        return false;
    }

    public boolean isDefect() {
        if (this.myDefectFound) {
            return true;
        }
        List<? extends GoogleCloudTestProxy> children = this.myTestProxy.getChildren();
        for (GoogleCloudTestProxy googleCloudTestProxy : children) {
            if (!googleCloudTestProxy.isDefect()) continue;
            this.myDefectFound = true;
            return true;
        }
        return false;
    }

    public boolean wasTerminated() {
        return false;
    }

    public TestStateInfo.Magnitude getMagnitude() {
        return TestStateInfo.Magnitude.SCHEDULED_INDEX;
    }

    public String toString() {
        return "SCHEDULED";
    }
}

