/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.results.GoogleCloudTestProxy;
import com.google.gct.testing.results.GoogleCloudTestResultsViewer;
import com.google.gct.testing.results.GoogleCloudTestingResultsForm;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.HyperLink;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.sm.SMRunnerUtil;
import com.intellij.execution.testframework.sm.runner.ui.AttachToProcessListener;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.testframework.ui.TestResultsPanel;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ModalityState;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoogleCloudTestingConsoleView
extends BaseTestsOutputConsoleView {
    private final ExecutionEnvironment myEnvironment;
    private GoogleCloudTestingResultsForm myResultsViewer;
    @Nullable
    private final String mySplitterProperty;
    private final List<AttachToProcessListener> myAttachToProcessListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public GoogleCloudTestingConsoleView(TestConsoleProperties consoleProperties, ExecutionEnvironment environment) {
        this(consoleProperties, environment, null);
    }

    public GoogleCloudTestingConsoleView(TestConsoleProperties consoleProperties, ExecutionEnvironment environment, @Nullable String splitterProperty) {
        super(consoleProperties, null);
        this.myEnvironment = environment;
        this.mySplitterProperty = splitterProperty;
    }

    protected TestResultsPanel createTestResultsPanel() {
        this.myResultsViewer = new GoogleCloudTestingResultsForm(this.myProperties.getConfiguration(), this.getConsole().getComponent(), this.getConsole().createConsoleActions(), this.myProperties, this.mySplitterProperty);
        return this.myResultsViewer;
    }

    public void initUI() {
        super.initUI();
        this.myResultsViewer.addEventsListener(new GoogleCloudTestResultsViewer.SMEventsAdapter(){

            @Override
            public void onSelected(final @Nullable GoogleCloudTestProxy selectedTestProxy, @NotNull GoogleCloudTestResultsViewer viewer, @NotNull TestFrameworkRunningModel model) {
                if (viewer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/google/gct/testing/results/GoogleCloudTestingConsoleView$1", "onSelected"));
                }
                if (model == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/google/gct/testing/results/GoogleCloudTestingConsoleView$1", "onSelected"));
                }
                if (selectedTestProxy == null) {
                    return;
                }
                SMRunnerUtil.runInEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        GoogleCloudTestingConsoleView.this.getPrinter().updateOnTestSelected((AbstractTestProxy)selectedTestProxy);
                    }
                }, (ModalityState)ModalityState.NON_MODAL);
            }
        });
    }

    public GoogleCloudTestingResultsForm getResultsViewer() {
        return this.myResultsViewer;
    }

    public void print(final @NotNull String s, final @NotNull ConsoleViewContentType contentType) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/google/gct/testing/results/GoogleCloudTestingConsoleView", "print"));
        }
        if (contentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentType", "com/google/gct/testing/results/GoogleCloudTestingConsoleView", "print"));
        }
        this.myResultsViewer.getRoot().addLast(new Printable(){

            public void printOn(Printer printer) {
                printer.print(s, contentType);
            }
        });
    }

    public void printHyperlink(String hyperlinkText, HyperlinkInfo info) {
        this.myResultsViewer.getRoot().addLast((Printable)new HyperLink(hyperlinkText, info));
    }

    public void attachToProcess(ProcessHandler processHandler) {
        super.attachToProcess(processHandler);
        for (AttachToProcessListener listener : this.myAttachToProcessListeners) {
            listener.onAttachToProcess(processHandler);
        }
    }

    public void addAttachToProcessListener(@NotNull AttachToProcessListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/google/gct/testing/results/GoogleCloudTestingConsoleView", "addAttachToProcessListener"));
        }
        this.myAttachToProcessListeners.add(listener);
    }

    public void remoteAttachToProcessListener(@NotNull AttachToProcessListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/google/gct/testing/results/GoogleCloudTestingConsoleView", "remoteAttachToProcessListener"));
        }
        this.myAttachToProcessListeners.remove(listener);
    }

    public void dispose() {
        this.myAttachToProcessListeners.clear();
        super.dispose();
    }
}

