/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.android;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.DeviceSelectionUtils;
import com.android.tools.idea.run.TargetDeviceFilter;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetConfigurable;
import com.android.tools.idea.run.editor.DeployTargetConfigurableContext;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.gct.testing.android.CloudDebuggingTargetConfigurable;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudDebuggingTargetProvider
extends DeployTargetProvider {
    public static final String ID = "CLOUD_DEVICE_DEBUGGING";
    private String myCloudDeviceSerialNumber;

    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/testing/android/CloudDebuggingTargetProvider", "getId"));
        }
        return ID;
    }

    @NotNull
    public String getDisplayName() {
        if ("Cloud Test Lab Debugging Device" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/testing/android/CloudDebuggingTargetProvider", "getDisplayName"));
        }
        return "Cloud Test Lab Debugging Device";
    }

    @NotNull
    public DeployTargetState createState() {
        State state = new State();
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/testing/android/CloudDebuggingTargetProvider", "createState"));
        }
        return state;
    }

    public DeployTargetConfigurable createConfigurable(@NotNull Project project, Disposable parentDisposable, @NotNull DeployTargetConfigurableContext context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/google/gct/testing/android/CloudDebuggingTargetProvider", "createConfigurable"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/google/gct/testing/android/CloudDebuggingTargetProvider", "createConfigurable"));
        }
        return new CloudDebuggingTargetConfigurable();
    }

    public DeployTarget getDeployTarget() {
        return new DeployTarget(){

            public boolean hasCustomRunProfileState(@NotNull Executor executor) {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/google/gct/testing/android/CloudDebuggingTargetProvider$1", "hasCustomRunProfileState"));
                }
                return false;
            }

            public RunProfileState getRunProfileState(@NotNull Executor executor, @NotNull ExecutionEnvironment env, @NotNull DeployTargetState state) throws ExecutionException {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/google/gct/testing/android/CloudDebuggingTargetProvider$1", "getRunProfileState"));
                }
                if (env == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/google/gct/testing/android/CloudDebuggingTargetProvider$1", "getRunProfileState"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/google/gct/testing/android/CloudDebuggingTargetProvider$1", "getRunProfileState"));
                }
                return null;
            }

            @Nullable
            public DeviceFutures getDevices(@NotNull DeployTargetState state, @NotNull AndroidFacet facet, @NotNull DeviceCount deviceCount, boolean debug, int runConfigId) {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/google/gct/testing/android/CloudDebuggingTargetProvider$1", "getDevices"));
                }
                if (facet == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/google/gct/testing/android/CloudDebuggingTargetProvider$1", "getDevices"));
                }
                if (deviceCount == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceCount", "com/google/gct/testing/android/CloudDebuggingTargetProvider$1", "getDevices"));
                }
                return DeviceFutures.forDevices((Iterable)DeviceSelectionUtils.getAllCompatibleDevices((Predicate)new TargetDeviceFilter(){

                    public boolean matchesDevice(@NotNull IDevice device) {
                        if (device == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/google/gct/testing/android/CloudDebuggingTargetProvider$1$1", "matchesDevice"));
                        }
                        if (device.isEmulator()) {
                            return false;
                        }
                        return device.getSerialNumber().equals(CloudDebuggingTargetProvider.this.myCloudDeviceSerialNumber);
                    }
                }));
            }
        };
    }

    public boolean isApplicable(boolean isTestConfig) {
        return false;
    }

    public void setCloudDeviceSerialNumber(String cloudDeviceSerialNumber) {
        this.myCloudDeviceSerialNumber = cloudDeviceSerialNumber;
    }

    public static final class State
    extends DeployTargetState {
        @NotNull
        public List<ValidationError> validate(@NotNull AndroidFacet facet) {
            if (facet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/google/gct/testing/android/CloudDebuggingTargetProvider$State", "validate"));
            }
            ArrayList arrayList = Lists.newArrayList();
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/testing/android/CloudDebuggingTargetProvider$State", "validate"));
            }
            return arrayList;
        }
    }
}

