/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.testing.AndroidTestRunConfiguration;
import com.android.tools.idea.stats.UsageTracker;
import com.google.gct.testing.CloudConfigurationHelper;
import com.google.gct.testing.CloudTestingUtils;
import com.google.gct.testing.ConfigurationInstance;
import com.google.gct.testing.GhostCloudDevice;
import com.google.gct.testing.android.CloudDebuggingTargetProvider;
import com.google.gct.testing.results.GoogleCloudTestProxy;
import com.google.gct.testing.results.GoogleCloudTestTreeView;
import com.google.gct.testing.results.GoogleCloudTestingResultsForm;
import com.google.gct.testing.util.CloudTestingTracking;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import javax.swing.SwingUtilities;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebugConfigurationAction
extends AnAction {
    private static final String TEXT = "Debug Configuration in Cloud";
    private static final String DESCRIPTION = "Debug Configuration on a Cloud Device";
    private AndroidDebugBridge myAndroidDebugBridge;

    public DebugConfigurationAction() {
        super(TEXT, DESCRIPTION, CloudTestingUtils.CLOUD_DEBUG_ICON);
        this.getTemplatePresentation().setEnabled(false);
    }

    public void update(AnActionEvent actionEvent) {
        GoogleCloudTestTreeView sender = (GoogleCloudTestTreeView)((Object)actionEvent.getData(GoogleCloudTestTreeView.CLOUD_TEST_RUNNER_VIEW));
        if (sender == null) {
            return;
        }
        AbstractTestProxy selectedNode = ((GoogleCloudTestingResultsForm)sender.getResultsViewer()).getTreeView().getSelectedTest();
        if (selectedNode == null || this.isRootNode(selectedNode)) {
            actionEvent.getPresentation().setEnabled(false);
        } else {
            actionEvent.getPresentation().setEnabled(true);
        }
    }

    public void actionPerformed(AnActionEvent actionEvent) {
        String configurationName;
        ExecutionEnvironment environment = (ExecutionEnvironment)actionEvent.getData(LangDataKeys.EXECUTION_ENVIRONMENT);
        GoogleCloudTestTreeView sender = (GoogleCloudTestTreeView)((Object)actionEvent.getData(GoogleCloudTestTreeView.CLOUD_TEST_RUNNER_VIEW));
        if (environment == null || sender == null) {
            return;
        }
        Project project = (Project)actionEvent.getData(PlatformDataKeys.PROJECT);
        AbstractTestProxy selectedNode = ((GoogleCloudTestingResultsForm)sender.getResultsViewer()).getTreeView().getSelectedTest();
        assert (!this.isRootNode(selectedNode));
        UsageTracker.getInstance().trackEvent("com.google.cloud.testing", "debug.from.results", CloudTestingTracking.SESSION_LABEL, null);
        String className = null;
        String methodName = null;
        if (this.isRootNode(selectedNode.getParent())) {
            configurationName = selectedNode.getName();
        } else if (this.isRootNode(selectedNode.getParent().getParent())) {
            className = selectedNode.getName();
            configurationName = selectedNode.getParent().getName();
        } else {
            methodName = selectedNode.getName();
            className = selectedNode.getParent().getName();
            configurationName = selectedNode.getParent().getParent().getName();
        }
        ConfigurationInstance configurationInstance = ConfigurationInstance.parseFromResultsViewerDisplayString(configurationName);
        if (!configurationInstance.isVirtual()) {
            CloudTestingUtils.showBalloonMessage(project, "Debugging on physical devices is not supported yet", MessageType.WARNING, 10);
            return;
        }
        this.myAndroidDebugBridge = AndroidSdkUtils.getDebugBridge((Project)project);
        if (this.myAndroidDebugBridge == null) {
            CloudTestingUtils.showBalloonMessage(project, "Could not obtain a debug bridge", MessageType.WARNING, 10);
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)new DebuggingStater(environment, project, configurationInstance, className, methodName));
    }

    private boolean isRootNode(AbstractTestProxy node) {
        return node instanceof GoogleCloudTestProxy.GoogleCloudRootTestProxy;
    }

    private class DebuggingStater
    extends Thread {
        private final ExecutionEnvironment environment;
        private final Project project;
        private final ConfigurationInstance configurationInstance;
        private final String className;
        private final String methodName;
        private final RunProfile runProfile;
        private final ProgramRunner runner;

        private DebuggingStater(ExecutionEnvironment environment, @NotNull Project project, @Nullable ConfigurationInstance configurationInstance, @Nullable String className, String methodName) {
            if (configurationInstance == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationInstance", "com/google/gct/testing/DebugConfigurationAction$DebuggingStater", "<init>"));
            }
            this.environment = environment;
            this.project = project;
            this.configurationInstance = configurationInstance;
            this.className = className;
            this.methodName = methodName;
            this.runProfile = environment.getRunProfile();
            this.runner = RunnerRegistry.getInstance().getRunner(DefaultDebugExecutor.getDebugExecutorInstance().getId(), this.runProfile);
        }

        @Override
        public void run() {
            if (!(this.runProfile instanceof AndroidTestRunConfiguration)) {
                return;
            }
            IDevice device = this.getMatchingDevice();
            if (device instanceof GhostCloudDevice) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.run();
            } else {
                String deviceSerialNumber;
                AndroidTestRunConfiguration runConfiguration;
                if (device == null) {
                    CloudConfigurationHelper.launchCloudDevice(this.configurationInstance.getEncodedString());
                    device = this.getMatchingDevice();
                    if (device == null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                CloudTestingUtils.showBalloonMessage(DebuggingStater.this.project, "Could not find a launched cloud device!", MessageType.WARNING, 10);
                            }
                        });
                        return;
                    }
                }
                if ((runConfiguration = this.prepareTestRunConfiguration(deviceSerialNumber = device.getSerialNumber())) == null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CloudTestingUtils.showBalloonMessage(DebuggingStater.this.project, "Could not prepare a run configuration for cloud debugging", MessageType.WARNING, 10);
                        }
                    });
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            DebuggingStater.this.runner.execute(new ExecutionEnvironmentBuilder(DebuggingStater.this.environment).executor(DefaultDebugExecutor.getDebugExecutorInstance()).runProfile((RunProfile)runConfiguration).build());
                        }
                        catch (ExecutionException e) {
                            CloudTestingUtils.showBalloonMessage(DebuggingStater.this.project, "Failed to start debugging on a cloud device: " + deviceSerialNumber, MessageType.WARNING, 10);
                        }
                    }
                });
            }
        }

        @Nullable
        private AndroidTestRunConfiguration prepareTestRunConfiguration(String deviceSerialNumber) {
            AndroidTestRunConfiguration runConfiguration = (AndroidTestRunConfiguration)((AndroidTestRunConfiguration)this.runProfile).clone();
            for (DeployTargetProvider deployTargetProvider : DeployTargetProvider.getProviders()) {
                if (!deployTargetProvider.getId().equals("CLOUD_DEVICE_DEBUGGING")) continue;
                ((CloudDebuggingTargetProvider)deployTargetProvider).setCloudDeviceSerialNumber(deviceSerialNumber);
                runConfiguration.setTargetSelectionMode(deployTargetProvider);
                if (this.className != null) {
                    runConfiguration.CLASS_NAME = this.className;
                    if (this.methodName != null) {
                        runConfiguration.METHOD_NAME = this.methodName;
                        runConfiguration.TESTING_TYPE = 3;
                    } else {
                        runConfiguration.TESTING_TYPE = 2;
                    }
                }
                return runConfiguration;
            }
            return null;
        }

        private IDevice getMatchingDevice() {
            if (DebugConfigurationAction.this.myAndroidDebugBridge != null) {
                for (IDevice device : DebugConfigurationAction.this.myAndroidDebugBridge.getDevices()) {
                    String deviceConfigurationInstance = CloudConfigurationHelper.getConfigurationInstanceForSerialNumber(device.getSerialNumber());
                    if (!this.configurationInstance.getEncodedString().equals(deviceConfigurationInstance)) continue;
                    return device;
                }
            }
            for (IDevice device : CloudConfigurationHelper.getLaunchingCloudDevices()) {
                if (!device.getSerialNumber().equals(this.configurationInstance.getEncodedString().toLowerCase())) continue;
                return device;
            }
            return null;
        }
    }
}

