/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.reflect.KProperty;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.UnmergedPathsException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.ignore.IgnoreNode;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.OperationResult;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.Transport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jgit.dirCache.AddLoadedFile;
import org.jetbrains.jgit.dirCache.DeleteDirectory;
import org.jetbrains.jgit.dirCache.DirCacheEditorKt;
import org.jetbrains.keychain.CredentialsStore;
import org.jetbrains.settingsRepository.AuthenticationException;
import org.jetbrains.settingsRepository.BaseRepositoryManager;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.RepositoryManager;
import org.jetbrains.settingsRepository.SyncType;
import org.jetbrains.settingsRepository.UpdateResult;
import org.jetbrains.settingsRepository.git.CommitKt;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.GitRepositoryManager$credentialsProvider$1;
import org.jetbrains.settingsRepository.git.GitRepositoryManagerKt;
import org.jetbrains.settingsRepository.git.IdeaCommitMessageFormatter;
import org.jetbrains.settingsRepository.git.JGitCredentialsProvider;
import org.jetbrains.settingsRepository.git.JGitProgressMonitorKt;
import org.jetbrains.settingsRepository.git.Pull;
import org.jetbrains.settingsRepository.git.PullKt;
import org.jetbrains.settingsRepository.git.Reset;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u0015\u0004)\u0011\u0001D\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\u0015Q!\u0001\u0007\u0002\u000b\u0005!)!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0011\u0005)\u0011\u0001B\u0001\u0006\u0003!9Q\u0001A\u0003\u0002\u0011%)\u0001!B\u0001\t\t\u0015\u0001Q!\u0001E\u0006\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t!\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001\"\u0002\u0006\u00031\tQ!\u0001C\u0004\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\t\u0001BE\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011A\u0002A\r\u00021\u0003\t[\"\u0003\u0004\t\u00035!\u0011BA\u0005\u00021\tA\u001a!C\u0002\t\u00065\t\u0001dA)\u0004\u0003!\u001dQ\u0005\u0006\u0003\u000b\u00111i\u0011\u0001'\u0007\u001a\u0007!iQ\"\u0001\r\u00043\rAY\"D\u0001\u0019\u001de\u0019\u0001RD\u0007\u00021=I2\u0001c\b\u000e\u0003a\u0001R\u0005\u0002\u0003\f\u0011Ci\u0011\u0001G\t&%\u0011Y\u00012E\u0007\u00021EIB\u0001\u0003\n\u000e\u00051\u0005\u0001TE\r\u0005\u0011Mi!\u0001$\u0001\u0019(e\u0019\u0001\u0002F\u0007\u00021E)3\u0002B\u0006\t$5\t\u0001\u0014D\r\u0007\u0011SiA!\u0003\u0002\n\u0003aq\u0001$F\u0013\u000e\t\u0005AY#D\u0001\u0019#e!\u0001BE\u0007\u0003\u0019\u0003A*#G\u0002\t-5\t\u0001TF\u0013\u0005\t-Aq#D\u0001\u0019#\u0015bAA\u0003E\u0018\u001b\u0005AJ\"G\u0002\t\u001c5\t\u0001DD\r\u0004\u0011ai\u0011\u0001G\t&\t\u0011Y\u0001\u0012G\u0007\u000213)\u0013\u0002B\u0006\t35\t\u00014G\r\u0005\u0011Ii!\u0001$\u0001\u0019&\u0015\"Aa\u0003\u0005\u001b\u001b\u0005A\u0002#J\u0003\u0005\u0003!URB\u0001G\u00011+)S\u0001B\u0006\t75\u0011A\u0012\u0001\r\u000fK\u0011!1\u0002c\u000e\u000e\u0003a\tR\u0005\u0003\u0003\u000b\u0011qi\u0011\u0001G\t\u001a\u0007!mQ\"\u0001\r\u000fK\u0011!1\u0002#\u000f\u000e\u0003a\tRE\u0003\u0003\f\u0011ui!\u0001$\u0001\u0019<e!\u0001BE\u0007\u0003\u0019\u0003A*#J\u0005\u0005\u0017!qR\"\u0001M\r3\u0011A!#\u0004\u0002\r\u0002a\u0015RE\u0004E\u001f\u001b\u0005A\u0012#\u0007\u0006\t?5A\u0011BA\u0005\u000219I1!\u0003\u0002\r\u0002aq\u0001tH\u0013\u0011\t-A\u0001%D\u0001\u0019<e\u0019\u0001BE\u0007\u00021KIr\u0001#\u0011\u000e\u000b%\u0011\u0011\"\u0001M\r\u0019\u0003A\u0012%\n\u0005\u0005\u0017!\rS\"\u0001M\u001e3\rA!#D\u0001\u0019&\u0015rAa\u0003\u0005#\u001b\u0005AJ\"\u0007\u0003\tF5\u0011A\u0012\u0001\r\u000f3\u0011A1%\u0004\u0002\r\u0002aq\u0011F\u0004\u0003D9!!QB\u0001G\u00011\u0013\t6aB\u0003\u0001\u001b\t!Q\u0001c\u0003\u0012\u0005\u00111\u0001RB\u0015\u000e\t\rC\u0001bB\u0007\u00021\u001fa2%U\u0002\u0007\u000b\t!\u0011\u0002c\u0005\u000e\u0005\u0011A\u0001\u0012C\u0015\u000b\t\u0005C\u0001\"A\u0007\u0005\u0013\tI\u0011\u0001\u0007\u0002\u0019\u0004E\u001b\u0011!\u0002\u0001*\u0011\u0011\tE\u0004\u0003\u0006\u000e\u00051\u0005\u0001TC)\u0004\u0003\u0015\u0001\u0011F\u0003\u0003D\u0011!YQ\"\u0001M\u00059\r\n6aA\u0007\u0003\t/AY\u0001"}, strings={"Lorg/jetbrains/settingsRepository/git/GitRepositoryManager;", "Lorg/jetbrains/settingsRepository/BaseRepositoryManager;", "credentialsStore", "Lcom/intellij/openapi/util/NotNullLazyValue;", "Lorg/jetbrains/keychain/CredentialsStore;", "dir", "Ljava/io/File;", "(Lcom/intellij/openapi/util/NotNullLazyValue;Ljava/io/File;)V", "_repository", "Lorg/eclipse/jgit/lib/Repository;", "get_repository", "()Lorg/eclipse/jgit/lib/Repository;", "set_repository", "(Lorg/eclipse/jgit/lib/Repository;)V", "credentialsProvider", "Lorg/eclipse/jgit/transport/CredentialsProvider;", "getCredentialsProvider", "()Lorg/eclipse/jgit/transport/CredentialsProvider;", "credentialsProvider$delegate", "Lkotlin/Lazy;", "ignoreRules", "Lorg/eclipse/jgit/ignore/IgnoreNode;", "repository", "getRepository", "addToIndex", "", "file", "path", "", "content", "", "size", "", "canCommit", "", "commit", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "syncType", "Lorg/jetbrains/settingsRepository/SyncType;", "fixStateIfCannotCommit", "paths", "", "commitIfCan", "state", "Lorg/eclipse/jgit/lib/RepositoryState;", "createRepositoryIfNeed", "deleteFromIndex", "isFile", "deleteRepository", "fetch", "Lorg/jetbrains/settingsRepository/RepositoryManager$Updater;", "getAheadCommitsCount", "getIgnoreRules", "getUpstream", "hasUpstream", "isPathIgnored", "isRepositoryExists", "pull", "Lorg/jetbrains/settingsRepository/UpdateResult;", "push", "renameDirectory", "pairs", "", "resetToMy", "localRepositoryInitializer", "Lkotlin/Function0;", "resetToTheirs", "setUpstream", "url", "branch"}, moduleName="settings-repository")
public final class GitRepositoryManager
extends BaseRepositoryManager {
    @Nullable
    private Repository _repository;
    @NotNull
    private final Lazy<JGitCredentialsProvider> credentialsProvider$delegate;
    private IgnoreNode ignoreRules;
    private final NotNullLazyValue<CredentialsStore> credentialsStore;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    @NotNull
    public final Repository getRepository() {
        Repository r = this._repository;
        if (r == null) {
            this._repository = r = ((FileRepositoryBuilder)new FileRepositoryBuilder().setWorkTree(this.getDir())).build();
            Application application = ApplicationManager.getApplication();
            if (Intrinsics.areEqual((Object)(application != null ? Boolean.valueOf(application.isUnitTestMode()) : null), (Object)true) ^ true) {
                ShutDownTracker.getInstance().registerShutdownTask(new Runnable(this){
                    final /* synthetic */ GitRepositoryManager this$0;

                    public final void run() {
                        Unit unit;
                        Repository repository2 = this.this$0.get_repository();
                        if (repository2 != null) {
                            repository2.close();
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                    }
                    {
                        this.this$0 = gitRepositoryManager;
                    }
                });
            }
        }
        Repository repository2 = r;
        if (repository2 == null) {
            Intrinsics.throwNpe();
        }
        return repository2;
    }

    @Nullable
    public final Repository get_repository() {
        return this._repository;
    }

    public final void set_repository(@Nullable Repository repository2) {
        this._repository = repository2;
    }

    @NotNull
    public final CredentialsProvider getCredentialsProvider() {
        return (CredentialsProvider)LazyKt.getValue(this.credentialsProvider$delegate, (Object)this, (KProperty)$$delegatedProperties[0]);
    }

    @Override
    public boolean createRepositoryIfNeed() {
        this.ignoreRules = null;
        if (this.isRepositoryExists()) {
            return false;
        }
        this.getRepository().create();
        GitExKt.disableAutoCrLf(this.getRepository());
        return true;
    }

    @Override
    public void deleteRepository() {
        this.ignoreRules = null;
        super.deleteRepository();
        Repository r = this._repository;
        if (r != null) {
            this._repository = null;
            r.close();
        }
    }

    @Override
    @Nullable
    public String getUpstream() {
        return StringUtil.nullize((String)this.getRepository().getConfig().getString("remote", "origin", "url"));
    }

    @Override
    public void setUpstream(@Nullable String url, @Nullable String branch) {
        Repository repository2 = this.getRepository();
        String string = branch;
        if (string == null) {
            string = "master";
        }
        GitExKt.setUpstream(repository2, url, string);
    }

    @Override
    public boolean isRepositoryExists() {
        Repository repo = this._repository;
        if (repo == null) {
            return this.getDir().exists() && ((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setWorkTree(this.getDir())).setup()).getObjectDirectory().exists();
        }
        return repo.getObjectDatabase().exists();
    }

    @Override
    public boolean hasUpstream() {
        return this.getUpstream() != null;
    }

    @Override
    protected void addToIndex(@NotNull File file, @NotNull String path, @NotNull byte[] content, int size) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        DirCacheEditorKt.edit(this.getRepository(), new AddLoadedFile(path, content, size, file.lastModified()));
    }

    @Override
    protected void deleteFromIndex(@NotNull String path, boolean isFile) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        DirCacheEditorKt.deletePath(this.getRepository(), path, isFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    @Override
    public boolean commit(@Nullable ProgressIndicator indicator, @Nullable SyncType syncType, boolean fixStateIfCannotCommit) {
        int it$iv;
        void $receiver$iv;
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock rl$iv = $receiver$iv.readLock();
        int readCount$iv = $receiver$iv.getWriteHoldCount() == 0 ? $receiver$iv.getReadHoldCount() : 0;
        int n = 0;
        int n2 = readCount$iv - 1;
        if (n <= n2) {
            void index$iv$iv;
            do {
                it$iv = ++index$iv$iv;
                rl$iv.unlock();
            } while (index$iv$iv != n2);
        }
        ReentrantReadWriteLock.WriteLock wl$iv = $receiver$iv.writeLock();
        wl$iv.lock();
        try {
            try {
                RepositoryState repositoryState = !fixStateIfCannotCommit || Intrinsics.areEqual((Object)((Object)syncType), (Object)((Object)SyncType.OVERWRITE_LOCAL)) ? this.getRepository().getRepositoryState() : PullKt.fixAndGetState(this.getRepository());
                Intrinsics.checkExpressionValueIsNotNull((Object)repositoryState, (String)"if (!fixStateIfCannotCom\u2026pository.fixAndGetState()");
                boolean bl = this.commitIfCan(indicator, repositoryState);
                return bl;
            }
            catch (UnmergedPathsException e) {
                Unit unit;
                Unit unit2;
                block23: {
                    if (!Intrinsics.areEqual((Object)((Object)syncType), (Object)((Object)SyncType.OVERWRITE_LOCAL))) break block23;
                    IcsManagerKt.getLOG().warn("Unmerged detected, ignored because sync type is OVERWRITE_LOCAL", (Throwable)e);
                    boolean bl = false;
                    it$iv = 0;
                    int n3 = readCount$iv - 1;
                    if (it$iv <= n3) {
                        do {
                            int $i$f$repeat = ++it$iv;
                            rl$iv.lock();
                        } while (it$iv != n3);
                    }
                    wl$iv.unlock();
                    return bl;
                }
                ProgressIndicator progressIndicator = indicator;
                if (progressIndicator != null) {
                    progressIndicator.checkCanceled();
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                IcsManagerKt.getLOG().warn("Unmerged detected, will be attempted to resolve", (Throwable)e);
                PullKt.resolveUnmergedConflicts(this.getRepository());
                ProgressIndicator progressIndicator2 = indicator;
                if (progressIndicator2 != null) {
                    progressIndicator2.checkCanceled();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                boolean bl = this.commitIfCan(indicator, PullKt.fixAndGetState(this.getRepository()));
                it$iv = 0;
                int n4 = readCount$iv - 1;
                if (it$iv <= n4) {
                    do {
                        int $i$f$repeat = ++it$iv;
                        rl$iv.lock();
                    } while (it$iv != n4);
                }
                wl$iv.unlock();
                return bl;
            }
            catch (NoHeadException e) {
                IcsManagerKt.getLOG().warn("Cannot commit - no HEAD", (Throwable)e);
                boolean bl = false;
                it$iv = 0;
                int n5 = readCount$iv - 1;
                if (it$iv <= n5) {
                    do {
                        int $i$f$repeat = ++it$iv;
                        rl$iv.lock();
                    } while (it$iv != n5);
                }
                wl$iv.unlock();
                return bl;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            it$iv = 0;
            int n6 = readCount$iv - 1;
            if (it$iv <= n6) {
                do {
                    int $i$f$repeat = ++it$iv;
                    rl$iv.lock();
                } while (it$iv != n6);
            }
            wl$iv.unlock();
        }
    }

    private final boolean commitIfCan(ProgressIndicator indicator, RepositoryState state) {
        if (state.canCommit()) {
            return CommitKt.commit$default(this.getRepository(), indicator, null, 4);
        }
        IcsManagerKt.getLOG().warn("Cannot commit, repository in state " + state.getDescription());
        return false;
    }

    @Override
    public int getAheadCommitsCount() {
        return GitExKt.getAheadCommitsCount(this.getRepository());
    }

    @Override
    public void commit(@NotNull List<String> paths) {
        Intrinsics.checkParameterIsNotNull(paths, (String)"paths");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void push(@Nullable ProgressIndicator indicator) {
        Ref head;
        IcsManagerKt.getLOG().debug("Push");
        SmartList refSpecs = new SmartList((Collection)new RemoteConfig((Config)this.getRepository().getConfig(), "origin").getPushRefSpecs());
        if (refSpecs.isEmpty() && (head = this.getRepository().getRef("HEAD")) != null && head.isSymbolic()) {
            refSpecs.add((Object)new RefSpec(head.getLeaf().getName()));
        }
        ProgressMonitor monitor = JGitProgressMonitorKt.asProgressMonitor(indicator);
        block5: for (Transport transport : Transport.openAll((Repository)this.getRepository(), (String)"origin", (Transport.Operation)Transport.Operation.PUSH)) {
            boolean bl = false;
            boolean bl2 = true;
            if (bl > bl2) continue;
            while (true) {
                void attempt;
                transport.setCredentialsProvider(this.getCredentialsProvider());
                try {
                    PushResult result = transport.push(monitor, transport.findRemoteRefUpdatesFor((Collection)refSpecs));
                    if (!IcsManagerKt.getLOG().isDebugEnabled()) continue block5;
                    OperationResult operationResult = (OperationResult)result;
                    Intrinsics.checkExpressionValueIsNotNull((Object)operationResult, (String)"result");
                    GitRepositoryManagerKt.printMessages(operationResult);
                    for (RemoteRefUpdate refUpdate : result.getRemoteUpdates()) {
                        IcsManagerKt.getLOG().debug(refUpdate.toString());
                    }
                    continue block5;
                }
                catch (TransportException e) {
                    if (Intrinsics.areEqual((Object)e.getStatus(), (Object)TransportException.Status.NOT_PERMITTED)) {
                        if (attempt != false) throw (Throwable)new AuthenticationException(e);
                        this.getCredentialsProvider().reset(transport.getURI());
                    } else {
                        GitExKt.wrapIfNeedAndReThrow(e);
                    }
                }
                finally {
                    transport.close();
                    continue block5;
                }
                if (attempt == bl2) continue block5;
                ++attempt;
            }
        }
    }

    @Override
    @NotNull
    public RepositoryManager.Updater fetch(@Nullable ProgressIndicator indicator) {
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator == null) {
            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
        }
        Pull pullTask = new Pull(this, progressIndicator, null, 4, null);
        Ref refToMerge = Pull.fetch$default(pullTask, null, 1);
        return new RepositoryManager.Updater(this, pullTask, refToMerge){
            private boolean definitelySkipPush;
            final /* synthetic */ GitRepositoryManager this$0;
            final /* synthetic */ Pull $pullTask;
            final /* synthetic */ Ref $refToMerge;

            public boolean getDefinitelySkipPush() {
                return this.definitelySkipPush;
            }

            public void setDefinitelySkipPush(boolean bl) {
                this.definitelySkipPush = bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Nullable
            public UpdateResult merge() {
                int it$iv;
                ReentrantReadWriteLock $receiver$iv = GitRepositoryManager.access$getLock$p(this.this$0);
                ReentrantReadWriteLock.ReadLock rl$iv = $receiver$iv.readLock();
                int readCount$iv = $receiver$iv.getWriteHoldCount() == 0 ? $receiver$iv.getReadHoldCount() : 0;
                int n = 0;
                int n2 = readCount$iv - 1;
                if (n <= n2) {
                    void index$iv$iv;
                    do {
                        it$iv = ++index$iv$iv;
                        rl$iv.unlock();
                    } while (index$iv$iv != n2);
                }
                ReentrantReadWriteLock.WriteLock wl$iv = $receiver$iv.writeLock();
                wl$iv.lock();
                try {
                    boolean committed = RepositoryManager.DefaultImpls.commit$default(this.this$0, this.$pullTask.getIndicator(), null, false, 6);
                    if (this.$refToMerge == null && !committed && this.this$0.getAheadCommitsCount() == 0) {
                        this.setDefinitelySkipPush(true);
                        UpdateResult updateResult = null;
                        return updateResult;
                    }
                    UpdateResult updateResult = Pull.pull$default(this.$pullTask, null, null, this.$refToMerge, 3);
                    return updateResult;
                }
                finally {
                    it$iv = 0;
                    int n3 = readCount$iv - 1;
                    if (it$iv <= n3) {
                        do {
                            int $i$f$repeat = ++it$iv;
                            rl$iv.lock();
                        } while (it$iv != n3);
                    }
                    wl$iv.unlock();
                }
            }
            {
                this.this$0 = $outer;
                this.$pullTask = $captured_local_variable$1;
                this.$refToMerge = $captured_local_variable$2;
            }
        };
    }

    @Override
    @Nullable
    public UpdateResult pull(@Nullable ProgressIndicator indicator) {
        return Pull.pull$default(new Pull(this, indicator, null, 4, null), null, null, null, 7);
    }

    @Override
    @NotNull
    public UpdateResult resetToTheirs(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        return Reset.reset$default(new Reset(this, indicator), true, null, 2);
    }

    @Override
    @NotNull
    public UpdateResult resetToMy(@NotNull ProgressIndicator indicator, @Nullable Function0<Unit> localRepositoryInitializer) {
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        return new Reset(this, indicator).reset(false, localRepositoryInitializer);
    }

    @Override
    public boolean canCommit() {
        return this.getRepository().getRepositoryState().canCommit();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean renameDirectory(@NotNull Map<String, String> pairs) {
        void receiver$iv;
        Object object;
        Intrinsics.checkParameterIsNotNull(pairs, (String)"pairs");
        AddCommand addCommand = null;
        SmartList toDelete = new SmartList();
        Iterator iterator = MapsKt.iterator(pairs);
        while (iterator.hasNext()) {
            void $receiver$iv;
            void $receiver$iv2;
            object = (Map.Entry)iterator.next();
            Map.Entry entry = object;
            String oldPath = (String)$receiver$iv2.getKey();
            Map.Entry $i$f$component1 = object;
            String newPath = (String)$receiver$iv.getValue();
            File old = new File(this.getDir(), oldPath);
            if (!old.exists()) continue;
            IcsManagerKt.getLOG().info("Rename " + oldPath + " to " + newPath);
            File[] files2 = old.listFiles();
            if (files2 != null) {
                File file = newPath == null ? this.getDir() : new File(this.getDir(), newPath);
                for (int i = 0; i < files2.length; ++i) {
                    File file2 = files2[i];
                    try {
                        if (file2.isHidden()) {
                            FileUtil.delete((File)file2);
                            continue;
                        }
                        file2.renameTo(new File(file, file2.getName()));
                        if (addCommand == null) {
                            addCommand = new AddCommand(this.getRepository());
                        }
                        addCommand.addFilepattern(newPath == null ? file2.getName() : newPath + "/" + file2.getName());
                        continue;
                    }
                    catch (Throwable e) {
                        IcsManagerKt.getLOG().error(e);
                    }
                }
                toDelete.add((Object)new DeleteDirectory(oldPath));
            }
            try {
                FileUtil.delete((File)old);
            }
            catch (Throwable e) {
                IcsManagerKt.getLOG().error(e);
            }
        }
        if (toDelete.isEmpty() && addCommand == null) {
            return false;
        }
        DirCacheEditorKt.edit(this.getRepository(), (List)toDelete);
        if (addCommand != null) {
            addCommand.call();
        }
        object = new IdeaCommitMessageFormatter();
        Repository repository2 = this.getRepository();
        IdeaCommitMessageFormatter $receiver = (IdeaCommitMessageFormatter)receiver$iv;
        StringBuilder stringBuilder = $receiver.appendCommitOwnerInfo(new StringBuilder(), true);
        GitExKt.commit$default(repository2, stringBuilder.append("Get rid of $ROOT_CONFIG$ and $APP_CONFIG").toString(), null, null, null, 14);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final IgnoreNode getIgnoreRules() {
        File file;
        void node;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = this.ignoreRules;
        if ((IgnoreNode)node.element == null && (file = new File(this.getDir(), ".gitignore")).exists()) {
            node.element = new IgnoreNode();
            Closeable $receiver$iv = FilesKt.inputStream((File)file);
            boolean closed$iv = false;
            try {
                InputStream it = (InputStream)$receiver$iv;
                IgnoreNode ignoreNode = (IgnoreNode)node.element;
                if (ignoreNode == null) {
                    Intrinsics.throwNpe();
                }
                ignoreNode.parse(it);
                it = Unit.INSTANCE;
            }
            catch (Exception e$iv) {
                closed$iv = true;
                try {
                    $receiver$iv.close();
                }
                catch (Exception closeException$iv) {
                    // empty catch block
                }
                throw (Throwable)e$iv;
            }
            finally {
                if (!closed$iv) {
                    $receiver$iv.close();
                }
            }
            this.ignoreRules = (IgnoreNode)node.element;
        }
        return (IgnoreNode)node.element;
    }

    @Override
    protected boolean isPathIgnored(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        IgnoreNode ignoreNode = this.getIgnoreRules();
        return Intrinsics.areEqual(ignoreNode != null ? ignoreNode.isIgnored("/" + path, false) : null, (Object)IgnoreNode.MatchResult.IGNORED);
    }

    public GitRepositoryManager(@NotNull NotNullLazyValue<CredentialsStore> credentialsStore2, @NotNull File dir) {
        Intrinsics.checkParameterIsNotNull(credentialsStore2, (String)"credentialsStore");
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        super(dir);
        this.credentialsStore = credentialsStore2;
        this.credentialsProvider$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JGitCredentialsProvider>(this){
            final /* synthetic */ GitRepositoryManager this$0;

            @NotNull
            public final JGitCredentialsProvider invoke() {
                return new JGitCredentialsProvider((NotNullLazyValue<CredentialsStore>)GitRepositoryManager.access$getCredentialsStore$p(this.this$0), this.this$0.getRepository());
            }
            {
                this.this$0 = gitRepositoryManager;
                super(0);
            }
        }));
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)GitRepositoryManager$credentialsProvider$1.INSTANCE};
    }

    @NotNull
    public static final /* synthetic */ ReentrantReadWriteLock access$getLock$p(GitRepositoryManager $this) {
        return $this.getLock();
    }

    @NotNull
    public static final /* synthetic */ NotNullLazyValue access$getCredentialsStore$p(GitRepositoryManager $this) {
        return $this.credentialsStore;
    }
}

