/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.BaseRepositoryManagerKt;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.RepositoryManager;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"Q\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tAAA\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u0003!\tQ!\u0001\u0003\u0002\u000b\u0005Aq!\u0002\u0001\u0006\u0003!IQ\u0001A\u0003\u0002\u0011\u0011)\u0011\u0001b\u0001\u0006\u0003!-Q!\u0001C\u0003\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005!\u0011\u0001B\n\r\u0001e\t\u0001\u0014AQ\u0007\u0013\rA\u0011!D\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\u0002&)\u0011\u0011\u00022B\u0007\u00021\u0019I2\u0001#\u0004\u000e\u0003a\r\u0011d\u0001\u0005\b\u001b\u0005Az!G\u0002\t\u00115\t\u0001\u0014C\r\u0004\u0011%i\u0011\u0001g\u0005&\u0019\u0011\t\u0001BC\u0007\u00021\u0019I2\u0001#\u0004\u000e\u0003a\r\u0011d\u0001\u0005\b\u001b\u0005Az!\n\u0005\u0005\u0017!QQ\"\u0001\r\u00073\rAq!D\u0001\u0019\u0010\u0015bAA\u0005E\u000b\u001b\u0005Ab!G\u0002\t\u000f5\t\u0001tB\r\u0004\u0011-i\u0011\u0001g\u0006&\t\u0011Y\u0001\u0002D\u0007\u00021\u0019)\u0003\u0002B\u0006\t\u001a5\t\u0001tC\r\u0004\u0011\u001di\u0011\u0001g\u0004&\u0011\u0011Q\u0001\"D\u0007\u00021/I2\u0001C\u0004\u000e\u0003a=Qe\b\u0003\f\u00117i\u0011\u0001\u0007\u0004\u001a\u0007!9Q\"\u0001M\b3%Aa\"D\u0004\n\u0005%\t\u0001tB\u0005\u0003\u0013\u0005A:\u0002'\b\u001a\u0019!yQBC\u0005\u0003\u0013\u0005Az!\u0003\u0002\n\u0003a\u0001\u0012BA\u0005\u00021/Az\"J\u0005\u0005\u0017!\u0005RB\u0001G\u00011AI2\u0001C\u0004\u000e\u0003a=Q\u0005\u0005\u0003\f\u0011Ei\u0011\u0001g\u0006\u001a\u0007!9Q\"\u0001M\b3\rA\u0001\"D\u0001\u0019\u0012e\u0019\u0001\"C\u0007\u00021'I#\u0002\u0002\"\t\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0011)\u0001!\u0004\u0002\u0005\u0006!\u0019\u0011F\u0003\u0003C\u0011!\u001dQ\"\u0001\r\u0005#\u000e!Q\u0001A\u0007\u0003\t\u0013AQ\u0001"}, strings={"Lorg/jetbrains/settingsRepository/BaseRepositoryManager;", "Lorg/jetbrains/settingsRepository/RepositoryManager;", "dir", "Ljava/io/File;", "(Ljava/io/File;)V", "getDir", "()Ljava/io/File;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "addToIndex", "", "file", "path", "", "content", "", "size", "", "delete", "deleteFromIndex", "isFile", "", "deleteRepository", "has", "isPathIgnored", "processChildren", "filter", "Lkotlin/Function1;", "processor", "Lkotlin/Function2;", "Ljava/io/InputStream;", "read", "write"}, moduleName="settings-repository")
public abstract class BaseRepositoryManager
implements RepositoryManager {
    @NotNull
    private final ReentrantReadWriteLock lock;
    @NotNull
    private final File dir;

    @NotNull
    protected final ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void processChildren(@NotNull String path, @NotNull Function1<? super String, Boolean> filter, @NotNull Function2<? super String, ? super InputStream, Boolean> processor) {
        Object files2;
        block14: {
            block13: {
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
                Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = null;
                ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
                ReentrantReadWriteLock.ReadLock rl$iv = $receiver$iv.readLock();
                rl$iv.lock();
                try {
                    files2.element = new File(this.dir, path).listFiles(new FilenameFilter(this, files2, path, filter){
                        final /* synthetic */ BaseRepositoryManager this$0;
                        final /* synthetic */ Ref.ObjectRef $files$inlined;
                        final /* synthetic */ String $path$inlined;
                        final /* synthetic */ Function1 $filter$inlined;

                        public final boolean accept(File file, String name) {
                            String string = name;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                            return (Boolean)this.$filter$inlined.invoke((Object)string);
                        }
                        {
                            this.this$0 = baseRepositoryManager;
                            this.$files$inlined = objectRef;
                            this.$path$inlined = string;
                            this.$filter$inlined = function1;
                        }
                    });
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    rl$iv.unlock();
                }
                if ((File[])files2.element == null) break block13;
                File[] fileArray = (File[])files2.element;
                if (fileArray == null) {
                    Intrinsics.throwNpe();
                }
                if (!ArraysKt.isEmpty((Object[])fileArray)) break block14;
            }
            return;
        }
        File[] fileArray = (File[])files2.element;
        if (fileArray == null) {
            Intrinsics.throwNpe();
        }
        File[] fileArray2 = fileArray;
        for (int i = 0; i < fileArray2.length; ++i) {
            File file = fileArray2[i];
            if (file.isDirectory() || file.isHidden()) continue;
            if (file.length() == 0L) {
                if (!file.exists()) continue;
                try {
                    IcsManagerKt.getLOG().warn("File " + path + " is empty (length 0), will be removed");
                    this.delete(file, path);
                }
                catch (Exception e) {
                    IcsManagerKt.getLOG().error((Throwable)e);
                }
                continue;
            }
            String string = file.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
            if (!((Boolean)processor.invoke((Object)string, (Object)FilesKt.inputStream((File)file))).booleanValue()) break;
        }
        files2 = null;
    }

    @Override
    public void deleteRepository() {
        FileUtil.delete((File)this.dir);
    }

    protected boolean isPathIgnored(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public InputStream read(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (this.isPathIgnored(path)) {
            Logger $receiver$iv = IcsManagerKt.getLOG();
            if ($receiver$iv.isDebugEnabled()) {
                Logger logger = $receiver$iv;
                String string = path + " is ignored";
                logger.debug(string);
            }
            return null;
        }
        Ref.ObjectRef $receiver$iv = new Ref.ObjectRef();
        $receiver$iv.element = null;
        ReentrantReadWriteLock $receiver$iv2 = this.lock;
        ReentrantReadWriteLock.ReadLock rl$iv = $receiver$iv2.readLock();
        rl$iv.lock();
        try {
            File file = new File(this.dir, path);
            if (file.length() != 0L) {
                InputStream inputStream = new FileInputStream(file);
                return inputStream;
            }
            fileToDelete.element = file;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            rl$iv.unlock();
        }
        try {
            int index$iv$iv;
            int it$iv;
            $receiver$iv2 = this.lock;
            rl$iv = $receiver$iv2.readLock();
            int readCount$iv = $receiver$iv2.getWriteHoldCount() == 0 ? $receiver$iv2.getReadHoldCount() : 0;
            int $i$a$2 = 0;
            int n = readCount$iv - 1;
            if ($i$a$2 <= n) {
                void index$iv$iv2;
                do {
                    it$iv = ++index$iv$iv2;
                    rl$iv.unlock();
                } while (index$iv$iv2 != n);
            }
            ReentrantReadWriteLock.WriteLock wl$iv = $receiver$iv2.writeLock();
            wl$iv.lock();
            try {
                void fileToDelete;
                File file = (File)fileToDelete.element;
                if (file == null) {
                    Intrinsics.throwNpe();
                }
                if (file.exists()) {
                    File file2 = (File)fileToDelete.element;
                    if (file2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (file2.length() == 0L) {
                        IcsManagerKt.getLOG().warn("File " + path + " is empty (length 0), will be removed");
                        File file3 = (File)fileToDelete.element;
                        if (file3 == null) {
                            Intrinsics.throwNpe();
                        }
                        this.delete(file3, path);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                index$iv$iv = 0;
                int n2 = readCount$iv - 1;
                if (index$iv$iv <= n2) {
                    do {
                        int it$iv2 = ++index$iv$iv;
                        rl$iv.lock();
                    } while (index$iv$iv != n2);
                }
                wl$iv.unlock();
                throw throwable;
            }
            it$iv = 0;
            int n3 = readCount$iv - 1;
            if (it$iv <= n3) {
                do {
                    int it$iv3 = ++index$iv$iv;
                    rl$iv.lock();
                } while (index$iv$iv != n3);
            }
            wl$iv.unlock();
        }
        catch (Exception e) {
            IcsManagerKt.getLOG().error((Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean write(@NotNull String path, @NotNull byte[] content, int size) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        if (this.isPathIgnored(path)) {
            void $receiver$iv;
            Logger logger = IcsManagerKt.getLOG();
            if ($receiver$iv.isDebugEnabled()) {
                void var17_7 = $receiver$iv;
                String string = path + " is ignored";
                var17_7.debug(string);
            }
            return false;
        }
        Object $receiver$iv = IcsManagerKt.getLOG();
        if ($receiver$iv.isDebugEnabled()) {
            Logger logger = $receiver$iv;
            String string = "Write " + path;
            logger.debug(string);
        }
        try {
            int index$iv$iv;
            int it$iv;
            $receiver$iv = this.lock;
            ReentrantReadWriteLock.ReadLock rl$iv = ((ReentrantReadWriteLock)$receiver$iv).readLock();
            int readCount$iv = ((ReentrantReadWriteLock)$receiver$iv).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)$receiver$iv).getReadHoldCount() : 0;
            int n = 0;
            int n2 = readCount$iv - 1;
            if (n <= n2) {
                void index$iv$iv2;
                do {
                    it$iv = ++index$iv$iv2;
                    rl$iv.unlock();
                } while (index$iv$iv2 != n2);
            }
            ReentrantReadWriteLock.WriteLock wl$iv = ((ReentrantReadWriteLock)$receiver$iv).writeLock();
            wl$iv.lock();
            try {
                File file = new File(this.dir, path);
                FileUtil.writeToFile((File)file, (byte[])content, (int)0, (int)size);
                this.addToIndex(file, path, content, size);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                index$iv$iv = 0;
                int n3 = readCount$iv - 1;
                if (index$iv$iv <= n3) {
                    do {
                        int it$iv2 = ++index$iv$iv;
                        rl$iv.lock();
                    } while (index$iv$iv != n3);
                }
                wl$iv.unlock();
                throw throwable;
            }
            it$iv = 0;
            int n4 = readCount$iv - 1;
            if (it$iv <= n4) {
                do {
                    int it$iv3 = ++index$iv$iv;
                    rl$iv.lock();
                } while (index$iv$iv != n4);
            }
            wl$iv.unlock();
        }
        catch (Exception e) {
            IcsManagerKt.getLOG().error((Throwable)e);
            return false;
        }
        return true;
    }

    protected abstract void addToIndex(@NotNull File var1, @NotNull String var2, @NotNull byte[] var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void delete(@NotNull String path) {
        int index$iv$iv;
        int it$iv;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Object $receiver$iv = IcsManagerKt.getLOG();
        if ($receiver$iv.isDebugEnabled()) {
            Logger logger = $receiver$iv;
            String string = "Remove " + path;
            logger.debug(string);
        }
        $receiver$iv = this.lock;
        ReentrantReadWriteLock.ReadLock rl$iv = ((ReentrantReadWriteLock)$receiver$iv).readLock();
        int readCount$iv = ((ReentrantReadWriteLock)$receiver$iv).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)$receiver$iv).getReadHoldCount() : 0;
        int n = 0;
        int n2 = readCount$iv - 1;
        if (n <= n2) {
            void index$iv$iv2;
            do {
                it$iv = ++index$iv$iv2;
                rl$iv.unlock();
            } while (index$iv$iv2 != n2);
        }
        ReentrantReadWriteLock.WriteLock wl$iv = ((ReentrantReadWriteLock)$receiver$iv).writeLock();
        wl$iv.lock();
        try {
            File file = new File(this.dir, path);
            if (file.exists()) {
                this.delete(file, path);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            index$iv$iv = 0;
            int n3 = readCount$iv - 1;
            if (index$iv$iv <= n3) {
                do {
                    int it$iv2 = ++index$iv$iv;
                    rl$iv.lock();
                } while (index$iv$iv != n3);
            }
            wl$iv.unlock();
            throw throwable;
        }
        it$iv = 0;
        int n4 = readCount$iv - 1;
        if (it$iv <= n4) {
            do {
                int it$iv3 = ++index$iv$iv;
                rl$iv.lock();
            } while (index$iv$iv != n4);
        }
        wl$iv.unlock();
    }

    private final void delete(File file, String path) {
        boolean isFile = file.isFile();
        BaseRepositoryManagerKt.removeWithParentsIfEmpty(file, this.dir, isFile);
        this.deleteFromIndex(path, isFile);
    }

    protected abstract void deleteFromIndex(@NotNull String var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean has(@NotNull String path) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        ReentrantReadWriteLock $receiver$iv = this.lock;
        ReentrantReadWriteLock.ReadLock rl$iv = $receiver$iv.readLock();
        rl$iv.lock();
        try {
            bl = new File(this.dir, path).exists();
        }
        finally {
            rl$iv.unlock();
        }
        return bl;
    }

    @NotNull
    protected final File getDir() {
        return this.dir;
    }

    public BaseRepositoryManager(@NotNull File dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        this.dir = dir;
        this.lock = new ReentrantReadWriteLock();
    }
}

