/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jgit.dirCache;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jgit.dirCache.AddLoadedFile;
import org.jetbrains.jgit.dirCache.DeleteDirectory;
import org.jetbrains.jgit.dirCache.DeleteFile;
import org.jetbrains.jgit.dirCache.DirCacheEditor;
import org.jetbrains.jgit.dirCache.DirCacheEditorKt;
import org.jetbrains.jgit.dirCache.DirCacheTerminator;
import org.jetbrains.jgit.dirCache.PathEdit;
import org.jetbrains.jgit.dirCache.PathEditBase;
import org.jetbrains.settingsRepository.BaseRepositoryManagerKt;
import org.jetbrains.settingsRepository.UtilKt;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"E\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005Aq!\u0002\u0001\u0006\u0003!IQ\u0001A\u0003\u0002\u0011\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u00012E\u0003\u0001\u000b\u0005AY!B\u0001\u0005\u0005\u0015\t\u0001\u0002E\u0003\u0002\t\u0007)\u0011\u0001\u0003\u0003\u000e\u0012!\u0011Q\"\u0001M\u00033\rA1!D\u0001\u0019\bQ\u001b\u0019!d\u0005\u0005\u0003!!Q\"\u0001M\u00053\rA1!D\u0001\u0019\bQ\u001b\u0019!d\f\t\u000b5\t\u00014B\u000b\u00021\u0019I\u001a\u0002B\u0001\t\u000e5)\u0011BA\u0005\u00021\u000fa\t\u0001G\u0004Q\u0007\u0003IZ\u0001B\u0001\t\u00105\t\u0001\u0004\u0003)\u0004\u0003Q\u001b\u0019!D\r\t\u00125\t\u00014B\u000b\u00021\u0019IJ\u0001C\u0002\u000e\u0003a\u001d\u0001k!\u0001\u001a\f\u0011\t\u0001\"C\u0007\u00021!\u00016!AM\u0006\t\u0005Ay!D\u0001\u0019\u0011A\u001b\u0019\u0001VB\u0002\u001b=A\u0019\"D\u0001\u0019\fU\t\u0001DBM\b\u0011)iA!\u0003\u0002\n\u0003a\t\u0001T\u0003)\u0004\u0002Q\u001b\u0019!\u0004\u0007\t\u00145\t\u00014B\u000b\u00021\u0019IJ\u0001c\u0005\u000e\u0003a\t\u0001k!\u0001U\u0007\u0007i\u0001\u0004C\u0006\u000e\u0003a-Q#\u0001\r\u00073\u0013A1!D\u0001\u0019\bA\u001b\t!'\u0003\t\u00185\t\u0001\u0014\u0002)\u0004\u0003e-A!\u0001\u0005\r\u001b\u0005AJ\u0002UB\u0002)\u000e\r\u0011s\u0003\u0003B\u0011!\u0001Q\u0002B\u0005\u0003\u0013\u0005A\u0012\u0001'\u0001R\u0007\u0005)\u0001\u0001VB\u0002"}, strings={"EDIT_CMP", "Ljava/util/Comparator;", "Lorg/jetbrains/jgit/dirCache/PathEdit;", "DirCacheEditorKt", "DeleteFile", "Lorg/jetbrains/jgit/dirCache/DeleteFile;", "path", "", "encodePath", "", "deleteAllFiles", "", "Lorg/eclipse/jgit/lib/Repository;", "deletedSet", "", "fromWorkingTree", "", "deletePath", "isFile", "edit", "edits", "", "writePath", "bytes", "size", ""}, moduleName="settings-repository")
public final class DirCacheEditorKt {
    private static final Comparator<PathEdit> EDIT_CMP = EDIT_CMP.1.INSTANCE;

    /*
     * WARNING - void declaration
     */
    private static final byte[] encodePath(String path) {
        int n;
        int n2;
        ByteBuffer byteBuffer = Constants.CHARSET.encode(path);
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"Constants.CHARSET.encode(path)");
        byte[] bytes = UtilKt.byteBufferToBytes(byteBuffer);
        if (SystemInfo.isWindows && (n2 = 0) <= (n = bytes.length - 1)) {
            while (true) {
                void i;
                if ((char)bytes[i] == '\\') {
                    bytes[i] = (byte)47;
                }
                if (i == n) break;
                ++i;
            }
        }
        return bytes;
    }

    @NotNull
    public static final DeleteFile DeleteFile(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return new DeleteFile(DirCacheEditorKt.encodePath(path));
    }

    public static final void edit(Repository $receiver, @NotNull PathEdit edit2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)edit2, (String)"edit");
        DirCacheEditorKt.edit($receiver, CollectionsKt.listOf((Object)edit2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void edit(Repository $receiver, @NotNull List<? extends PathEdit> edits) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(edits, (String)"edits");
        if (edits.isEmpty()) {
            return;
        }
        DirCache dirCache = $receiver.lockDirCache();
        try {
            DirCache dirCache2 = dirCache;
            Intrinsics.checkExpressionValueIsNotNull((Object)dirCache2, (String)"dirCache");
            new DirCacheEditor(edits, $receiver, dirCache2, dirCache.getEntryCount() + 4).commit();
        }
        finally {
            dirCache.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void deleteAllFiles(Repository $receiver, @Nullable Set<String> deletedSet, boolean fromWorkingTree) {
        File[] files2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DirCache dirCache = $receiver.lockDirCache();
        try {
            int n;
            int n2;
            if (deletedSet != null && (n2 = 0) <= (n = dirCache.getEntryCount() - 1)) {
                while (true) {
                    void i;
                    DirCacheEntry entry;
                    if (Intrinsics.areEqual((Object)(entry = dirCache.getEntry((int)i)).getFileMode(), (Object)FileMode.REGULAR_FILE)) {
                        String string = entry.getPathString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.pathString");
                        deletedSet.add(string);
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            DirCache dirCache2 = dirCache;
            Intrinsics.checkExpressionValueIsNotNull((Object)dirCache2, (String)"dirCache");
            new DirCacheTerminator(dirCache2).commit();
        }
        finally {
            dirCache.unlock();
        }
        if (fromWorkingTree && (files2 = $receiver.getWorkTree().listFiles(deleteAllFiles.files.1.INSTANCE)) != null) {
            for (int i = 0; i < files2.length; ++i) {
                File file = files2[i];
                FileUtil.delete((File)file);
            }
        }
    }

    public static /* bridge */ /* synthetic */ void deleteAllFiles$default(Repository repository2, Set set, boolean bl, int n) {
        if ((n & 1) != 0) {
            set = null;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        DirCacheEditorKt.deleteAllFiles(repository2, set, bl);
    }

    public static final void writePath(Repository $receiver, @NotNull String path, @NotNull byte[] bytes, int size) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        DirCacheEditorKt.edit($receiver, new AddLoadedFile(path, bytes, size, 0L, 8, null));
        FileUtil.writeToFile((File)new File($receiver.getWorkTree(), path), (byte[])bytes, (int)0, (int)size);
    }

    public static /* bridge */ /* synthetic */ void writePath$default(Repository repository2, String string, byte[] byArray, int n, int n2) {
        if ((n2 & 4) != 0) {
            n = byArray.length;
        }
        DirCacheEditorKt.writePath(repository2, string, byArray, n);
    }

    public static final void deletePath(Repository $receiver, @NotNull String path, boolean isFile, boolean fromWorkingTree) {
        File workTree;
        File ioFile;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        DirCacheEditorKt.edit($receiver, isFile ? (PathEditBase)DirCacheEditorKt.DeleteFile(path) : (PathEditBase)new DeleteDirectory(path));
        if (fromWorkingTree && (ioFile = new File(workTree = $receiver.getWorkTree(), path)).exists()) {
            File file = workTree;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"workTree");
            BaseRepositoryManagerKt.removeWithParentsIfEmpty(ioFile, file, isFile);
        }
    }

    public static /* bridge */ /* synthetic */ void deletePath$default(Repository repository2, String string, boolean bl, boolean bl2, int n) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        DirCacheEditorKt.deletePath(repository2, string, bl, bl2);
    }

    @NotNull
    public static final /* synthetic */ Comparator access$getEDIT_CMP$p() {
        return EDIT_CMP;
    }

    @NotNull
    public static final /* synthetic */ byte[] access$encodePath(@NotNull String path) {
        return DirCacheEditorKt.encodePath(path);
    }
}

