/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.java.archives.internal;

import com.google.common.collect.Sets;
import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.java.archives.Attributes;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.java.archives.ManifestMergeDetails;
import org.gradle.api.java.archives.ManifestMergeSpec;
import org.gradle.api.java.archives.internal.DefaultAttributes;
import org.gradle.api.java.archives.internal.DefaultManifest;
import org.gradle.api.java.archives.internal.DefaultManifestMergeDetails;
import org.gradle.util.GUtil;
import org.gradle.util.WrapUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultManifestMergeSpec
implements ManifestMergeSpec {
    List<Object> mergePaths = new ArrayList<Object>();
    private final List<Action<? super ManifestMergeDetails>> actions = new ArrayList<Action<? super ManifestMergeDetails>>();

    @Override
    public ManifestMergeSpec from(Object ... mergePaths) {
        GUtil.flatten((Object[])mergePaths, this.mergePaths);
        return this;
    }

    @Override
    public ManifestMergeSpec eachEntry(Action<? super ManifestMergeDetails> mergeAction) {
        this.actions.add(mergeAction);
        return this;
    }

    @Override
    public ManifestMergeSpec eachEntry(Closure<?> mergeAction) {
        return this.eachEntry((Action<? super ManifestMergeDetails>)new ClosureBackedAction(mergeAction));
    }

    public DefaultManifest merge(Manifest baseManifest, FileResolver fileResolver) {
        DefaultManifest mergedManifest = new DefaultManifest(fileResolver);
        mergedManifest.getAttributes().putAll(baseManifest.getAttributes());
        mergedManifest.getSections().putAll(baseManifest.getSections());
        for (Object mergePath : this.mergePaths) {
            DefaultManifest manifestToMerge = this.createManifest(mergePath, fileResolver);
            mergedManifest = this.mergeManifest(mergedManifest, manifestToMerge, fileResolver);
        }
        return mergedManifest;
    }

    private DefaultManifest mergeManifest(DefaultManifest baseManifest, DefaultManifest toMergeManifest, FileResolver fileResolver) {
        DefaultManifest mergedManifest = new DefaultManifest(fileResolver);
        this.mergeSection(null, mergedManifest, baseManifest.getAttributes(), toMergeManifest.getAttributes());
        Sets.SetView allSections = Sets.union(baseManifest.getSections().keySet(), toMergeManifest.getSections().keySet());
        for (String section : allSections) {
            this.mergeSection(section, mergedManifest, (Attributes)GUtil.elvis((Object)baseManifest.getSections().get(section), (Object)new DefaultAttributes()), (Attributes)GUtil.elvis((Object)toMergeManifest.getSections().get(section), (Object)new DefaultAttributes()));
        }
        return mergedManifest;
    }

    private void mergeSection(String section, DefaultManifest mergedManifest, Attributes baseAttributes, Attributes mergeAttributes) {
        LinkedHashMap<String, Object> mergeOnlyAttributes = new LinkedHashMap<String, Object>(mergeAttributes);
        LinkedHashSet<DefaultManifestMergeDetails> mergeDetailsSet = new LinkedHashSet<DefaultManifestMergeDetails>();
        for (Map.Entry baseEntry : baseAttributes.entrySet()) {
            Object mergeValue = mergeAttributes.get(baseEntry.getKey());
            mergeDetailsSet.add(this.getMergeDetails(section, (String)baseEntry.getKey(), baseEntry.getValue(), mergeValue));
            mergeOnlyAttributes.remove(baseEntry.getKey());
        }
        for (Map.Entry mergeEntry : mergeOnlyAttributes.entrySet()) {
            mergeDetailsSet.add(this.getMergeDetails(section, (String)mergeEntry.getKey(), null, mergeEntry.getValue()));
        }
        for (DefaultManifestMergeDetails mergeDetails : mergeDetailsSet) {
            for (Action<? super ManifestMergeDetails> action : this.actions) {
                action.execute((Object)mergeDetails);
            }
            this.addMergeDetailToManifest(section, mergedManifest, mergeDetails);
        }
    }

    private DefaultManifestMergeDetails getMergeDetails(String section, String key, Object baseValue, Object mergeValue) {
        String value = null;
        String baseValueString = baseValue != null ? baseValue.toString() : null;
        String mergeValueString = mergeValue != null ? mergeValue.toString() : null;
        value = mergeValueString == null ? baseValueString : mergeValueString;
        return new DefaultManifestMergeDetails(section, key, baseValueString, mergeValueString, value);
    }

    private void addMergeDetailToManifest(String section, DefaultManifest mergedManifest, DefaultManifestMergeDetails mergeDetails) {
        if (!mergeDetails.isExcluded()) {
            if (section == null) {
                mergedManifest.attributes(WrapUtil.toMap((Object)mergeDetails.getKey(), (Object)mergeDetails.getValue()));
            } else {
                mergedManifest.attributes(WrapUtil.toMap((Object)mergeDetails.getKey(), (Object)mergeDetails.getValue()), section);
            }
        }
    }

    private DefaultManifest createManifest(Object mergePath, FileResolver fileResolver) {
        if (mergePath instanceof DefaultManifest) {
            return ((DefaultManifest)mergePath).getEffectiveManifest();
        }
        return new DefaultManifest(mergePath, fileResolver);
    }

    public List<Object> getMergePaths() {
        return this.mergePaths;
    }
}

