/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.ThrowableRunnable;

public class VcsSynchronousProgressWrapper {
    private VcsSynchronousProgressWrapper() {
    }

    public static boolean wrap(final ThrowableRunnable<VcsException> runnable, Project project, String title) {
        boolean notCanceled;
        final VcsException[] exc = new VcsException[1];
        Runnable process = new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (VcsException e) {
                    exc[0] = e;
                }
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            notCanceled = ProgressManager.getInstance().runProcessWithProgressSynchronously(process, title, true, project);
        } else {
            process.run();
            notCanceled = true;
        }
        if (exc[0] != null) {
            AbstractVcsHelper.getInstance(project).showError(exc[0], title);
            return false;
        }
        return notCanceled;
    }
}

