/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ui.ComboBox;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CalendarView
extends JPanel {
    private static final int[] DAYS_IN_THE_MONTH = new int[]{31, -1, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private final JComboBox myDays = new ComboBox();
    private final JComboBox myMonths = new ComboBox();
    private final JSpinner myYears = new JSpinner(new SpinnerNumberModel(2013, 0, Integer.MAX_VALUE, 1));
    private final JSpinner myHours = new JSpinner(new SpinnerNumberModel(23, 0, 23, 1));
    private final JSpinner myMinutes = new JSpinner(new SpinnerNumberModel(59, 0, 59, 1));
    private final JSpinner mySeconds = new JSpinner(new SpinnerNumberModel(59, 0, 59, 1));
    private final Calendar myCalendar = Calendar.getInstance();

    public CalendarView() {
        super(new GridLayout(2, 0));
        this.fillMonths();
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.myYears, "####");
        editor.getTextField().setColumns(4);
        this.myYears.setEditor(editor);
        this.myYears.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CalendarView.this.refresh();
            }
        });
        this.setDate(new Date());
        this.addDateFields();
        this.addTimeFields();
        int height = Math.max(this.myYears.getPreferredSize().height, this.myDays.getPreferredSize().height);
        height = Math.max(this.myMonths.getPreferredSize().height, height);
        this.myDays.setPreferredSize(new Dimension(this.myDays.getPreferredSize().width, height));
        this.myYears.setPreferredSize(new Dimension(this.myYears.getPreferredSize().width, height));
        this.myMonths.setPreferredSize(new Dimension(this.myMonths.getPreferredSize().width, height));
        Dimension preferredSize = this.getPreferredSize();
        this.setMaximumSize(preferredSize);
        this.setMaximumSize(preferredSize);
    }

    private void fillMonths() {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(Locale.getDefault());
        for (int i = 0; i <= 11; ++i) {
            this.myMonths.addItem(dateFormatSymbols.getMonths()[i]);
        }
        this.myMonths.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarView.this.refresh();
            }
        });
    }

    public void setDate(Date date) {
        this.myCalendar.setTime(date);
        this.myYears.setValue(new Integer(this.myCalendar.get(1)));
        this.myMonths.setSelectedIndex(this.myCalendar.get(2));
        this.myDays.setSelectedIndex(this.myCalendar.get(5) - 1);
        this.myHours.setValue(new Integer(this.myCalendar.get(11)));
        this.myMinutes.setValue(new Integer(this.myCalendar.get(12)));
        this.mySeconds.setValue(new Integer(this.myCalendar.get(13)));
    }

    private void addTimeFields() {
        JPanel timePanel = new JPanel(new FlowLayout(2));
        timePanel.add(this.myHours);
        timePanel.add(new JLabel(" : "));
        timePanel.add(this.myMinutes);
        timePanel.add(new JLabel(" : "));
        timePanel.add(this.mySeconds);
        this.add(timePanel);
    }

    private void addDateFields() {
        JPanel datePanel = new JPanel(new FlowLayout(2));
        datePanel.add(this.myDays);
        datePanel.add(this.myMonths);
        datePanel.add(this.myYears);
        this.add(datePanel);
    }

    private void refresh() {
        int days = DAYS_IN_THE_MONTH[this.myMonths.getSelectedIndex()];
        if (days > 0) {
            this.fillDays(days);
        } else {
            this.fillDays(this.daysInTheFebruary());
        }
    }

    private void fillDays(int days) {
        int selectedDayIndex = this.myDays.getSelectedIndex();
        this.myDays.removeAllItems();
        for (int i = 0; i < days; ++i) {
            this.myDays.addItem(String.valueOf(i + 1));
        }
        if (selectedDayIndex < this.myDays.getItemCount()) {
            this.myDays.setSelectedIndex(selectedDayIndex);
        } else {
            this.myDays.setSelectedIndex(this.myDays.getItemCount() - 1);
        }
    }

    private int daysInTheFebruary() {
        int year = Integer.parseInt(this.myYears.getValue().toString());
        if (year % 4 > 0) {
            return 29;
        }
        if (year % 100 > 0) {
            return 29;
        }
        return 28;
    }

    public Date getDate() {
        this.commitSpinners();
        this.myCalendar.set(CalendarView.getIntValue(this.myYears), this.myMonths.getSelectedIndex(), this.myDays.getSelectedIndex() + 1, CalendarView.getIntValue(this.myHours), CalendarView.getIntValue(this.myMinutes), CalendarView.getIntValue(this.mySeconds));
        return this.myCalendar.getTime();
    }

    private static int getIntValue(JSpinner spinner) {
        return ((Number)spinner.getModel().getValue()).intValue();
    }

    public void registerEnterHandler(final Runnable runnable) {
        new AnAction(){

            @Override
            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(!CalendarView.this.myMonths.isPopupVisible() && !CalendarView.this.myDays.isPopupVisible());
            }

            @Override
            public void actionPerformed(AnActionEvent e) {
                runnable.run();
            }
        }.registerCustomShortcutSet(10, 0, this);
    }

    private void commitSpinners() {
        try {
            this.myYears.commitEdit();
            this.myHours.commitEdit();
            this.myMinutes.commitEdit();
            this.mySeconds.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }
}

