/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.switcher;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import javax.swing.KeyStroke;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class QuickAccessSettings {
    private final Set<Integer> myModifierVks = new THashSet();
    @NonNls
    public static final String SWITCH_UP = "SwitchUp";
    @NonNls
    public static final String SWITCH_DOWN = "SwitchDown";
    @NonNls
    public static final String SWITCH_LEFT = "SwitchLeft";
    @NonNls
    public static final String SWITCH_RIGHT = "SwitchRight";
    @NonNls
    public static final String SWITCH_APPLY = "SwitchApply";
    private RegistryValue myModifiersValue = Registry.get((String)"actionSystem.quickAccessModifiers");

    public QuickAccessSettings() {
        this.myModifiersValue.addListener((RegistryValueListener)new RegistryValueListener.Adapter(){

            public void afterValueChanged(RegistryValue value) {
                QuickAccessSettings.this.applyModifiersFromRegistry();
            }
        }, (Disposable)ApplicationManager.getApplication());
        this.applyModifiersFromRegistry();
    }

    Keymap getKeymap() {
        return KeymapManager.getInstance().getActiveKeymap();
    }

    void saveModifiersToRegistry(Set<String> codeTexts) {
        StringBuilder value = new StringBuilder();
        for (String each : codeTexts) {
            if (value.length() > 0) {
                value.append(" ");
            }
            value.append(each);
        }
        this.myModifiersValue.setValue(value.toString());
    }

    private void applyModifiersFromRegistry() {
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isUnitTestMode()) {
            return;
        }
        THashSet vksSet = new THashSet();
        ContainerUtil.addAll((Collection)vksSet, (Object[])this.getModifierRegistryValue().split(" "));
        this.myModifierVks.clear();
        int mask = this.getModifierMask((Set<String>)vksSet);
        this.myModifierVks.addAll(QuickAccessSettings.getModifiersVKs(mask));
        this.reassignActionShortcut(SWITCH_UP, mask, 38);
        this.reassignActionShortcut(SWITCH_DOWN, mask, 40);
        this.reassignActionShortcut(SWITCH_LEFT, mask, 37);
        this.reassignActionShortcut(SWITCH_RIGHT, mask, 39);
        this.reassignActionShortcut(SWITCH_APPLY, mask, 10);
    }

    @NotNull
    private String getModifierRegistryValue() {
        String value = this.myModifiersValue.asString().trim();
        if (value.length() > 0) {
            String string = value;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/switcher/QuickAccessSettings", "getModifierRegistryValue"));
            }
            return string;
        }
        String string = SystemInfo.isMac ? "control alt" : "shift alt";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/switcher/QuickAccessSettings", "getModifierRegistryValue"));
        }
        return string;
    }

    private void reassignActionShortcut(String actionId, @JdkConstants.InputEventMask int modifiers, int actionCode) {
        this.removeShortcuts(actionId);
        if (modifiers > 0) {
            this.getKeymap().addShortcut(actionId, new KeyboardShortcut(KeyStroke.getKeyStroke(actionCode, modifiers), null));
        }
    }

    private void removeShortcuts(String actionId) {
        Shortcut[] shortcuts;
        for (Shortcut each : shortcuts = this.getKeymap().getShortcuts(actionId)) {
            if (!(each instanceof KeyboardShortcut)) continue;
            this.getKeymap().removeShortcut(actionId, each);
        }
    }

    @JdkConstants.InputEventMask
    int getModifierMask(Set<String> codeTexts) {
        int mask = 0;
        for (String each : codeTexts) {
            if ("control".equals(each)) {
                mask |= 2;
                continue;
            }
            if ("shift".equals(each)) {
                mask |= 1;
                continue;
            }
            if ("alt".equals(each)) {
                mask |= 8;
                continue;
            }
            if (!"meta".equals(each)) continue;
            mask |= 4;
        }
        return mask;
    }

    @NotNull
    public static Set<Integer> getModifiersVKs(int mask) {
        THashSet codes = new THashSet();
        if ((mask & 1) > 0) {
            codes.add(16);
        }
        if ((mask & 2) > 0) {
            codes.add(17);
        }
        if ((mask & 4) > 0) {
            codes.add(157);
        }
        if ((mask & 8) > 0) {
            codes.add(18);
        }
        THashSet tHashSet = codes;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/switcher/QuickAccessSettings", "getModifiersVKs"));
        }
        return tHashSet;
    }

    public static QuickAccessSettings getInstance() {
        return ApplicationManager.getApplication().getComponent(QuickAccessSettings.class);
    }

    public boolean isEnabled() {
        return Registry.is((String)"actionSystem.quickAccessEnabled");
    }

    public Set<Integer> getModiferCodes() {
        return this.myModifierVks;
    }
}

