/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.CollectionListModel;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.ComboBoxModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionComboBoxModel<T>
extends CollectionListModel<T>
implements ComboBoxModel {
    protected T mySelection;

    public CollectionComboBoxModel() {
        super(new Object[0]);
        this.mySelection = null;
    }

    public CollectionComboBoxModel(@NotNull List<T> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/ui/CollectionComboBoxModel", "<init>"));
        }
        this(items, ContainerUtil.getFirstItem(items));
    }

    public CollectionComboBoxModel(@NotNull List<T> items, @Nullable T selection) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/ui/CollectionComboBoxModel", "<init>"));
        }
        super(items, true);
        this.mySelection = selection;
    }

    @Override
    public void setSelectedItem(@Nullable Object item) {
        if (this.mySelection != item) {
            this.mySelection = item;
            this.update();
        }
    }

    @Override
    @Nullable
    public Object getSelectedItem() {
        return this.mySelection;
    }

    @Nullable
    public T getSelected() {
        return this.mySelection;
    }

    public void update() {
        super.fireContentsChanged(this, -1, -1);
    }

    public boolean contains(T item) {
        return this.getElementIndex(item) != -1;
    }
}

