/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.runtime.deployment;

import com.intellij.icons.AllIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DeploymentStatus {
    public static final DeploymentStatus DEPLOYED = new DeploymentStatus(AllIcons.RunConfigurations.TestPassed, "Deployed", false);
    public static final DeploymentStatus NOT_DEPLOYED = new DeploymentStatus(AllIcons.RunConfigurations.TestIgnored, "Not deployed", false);
    public static final DeploymentStatus DEPLOYING = new DeploymentStatus(AllIcons.RunConfigurations.TestInProgress4, "Deploying", true);
    public static final DeploymentStatus UNDEPLOYING = new DeploymentStatus(AllIcons.RunConfigurations.TestInProgress4, "Undeploying", true);
    private final Icon myIcon;
    private final String myPresentableText;
    private final boolean myTransition;

    public DeploymentStatus(Icon icon, @NotNull String presentableText, boolean transition) {
        if (presentableText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableText", "com/intellij/remoteServer/runtime/deployment/DeploymentStatus", "<init>"));
        }
        this.myIcon = icon;
        this.myPresentableText = presentableText;
        this.myTransition = transition;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    @NotNull
    public String getPresentableText() {
        String string = this.myPresentableText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/runtime/deployment/DeploymentStatus", "getPresentableText"));
        }
        return string;
    }

    public boolean isTransition() {
        return this.myTransition;
    }
}

