/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.ui.TestDialog;
import com.intellij.openapi.ui.TestInputDialog;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.MessageException;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.mac.MacMessages;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.PairFunction;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Messages {
    public static final int OK = 0;
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;
    public static final String OK_BUTTON = CommonBundle.getOkButtonText();
    public static final String YES_BUTTON = CommonBundle.getYesButtonText();
    public static final String NO_BUTTON = CommonBundle.getNoButtonText();
    public static final String CANCEL_BUTTON = CommonBundle.getCancelButtonText();
    private static TestDialog ourTestImplementation = TestDialog.DEFAULT;
    private static TestInputDialog ourTestInputImplementation = TestInputDialog.DEFAULT;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.ui.Messages");

    public static TestDialog setTestDialog(TestDialog newValue) {
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            LOG.assertTrue(application.isUnitTestMode(), (Object)"This method is available for tests only");
        }
        TestDialog oldValue = ourTestImplementation;
        ourTestImplementation = newValue;
        return oldValue;
    }

    public static TestInputDialog setTestInputDialog(TestInputDialog newValue) {
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            LOG.assertTrue(application.isUnitTestMode(), (Object)"This method is available for tests only");
        }
        TestInputDialog oldValue = ourTestInputImplementation;
        ourTestInputImplementation = newValue;
        return oldValue;
    }

    @NotNull
    public static Icon getErrorIcon() {
        Icon icon = UIUtil.getErrorIcon();
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/Messages", "getErrorIcon"));
        }
        return icon;
    }

    @NotNull
    public static Icon getInformationIcon() {
        Icon icon = UIUtil.getInformationIcon();
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/Messages", "getInformationIcon"));
        }
        return icon;
    }

    @NotNull
    public static Icon getWarningIcon() {
        Icon icon = UIUtil.getWarningIcon();
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/Messages", "getWarningIcon"));
        }
        return icon;
    }

    @NotNull
    public static Icon getQuestionIcon() {
        Icon icon = UIUtil.getQuestionIcon();
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/Messages", "getQuestionIcon"));
        }
        return icon;
    }

    public static int showDialog(@Nullable Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, @Nullable Icon icon) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/ui/Messages", "showDialog"));
        }
        return Messages.showDialog(project, message, title, options, defaultOptionIndex, icon, null);
    }

    public static int showDialog(@Nullable Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showDialog"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/ui/Messages", "showDialog"));
        }
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestImplementation.show(message);
        }
        try {
            WindowManager windowManager;
            if (Messages.canShowMacSheetPanel() && (windowManager = WindowManager.getInstance()) != null) {
                Window parentWindow = windowManager.suggestParentWindow(project);
                return MacMessages.getInstance().showMessageDialog(title, message, options, false, parentWindow, defaultOptionIndex, defaultOptionIndex, doNotAskOption);
            }
        }
        catch (MessageException windowManager) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        return Messages.showIdeaMessageDialog(project, message, title, options, defaultOptionIndex, icon, doNotAskOption);
    }

    public static int showIdeaMessageDialog(@Nullable Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/ui/Messages", "showIdeaMessageDialog"));
        }
        MessageDialog dialog = new MessageDialog(project, message, title, options, defaultOptionIndex, -1, icon, doNotAskOption, false);
        dialog.show();
        return dialog.getExitCode();
    }

    public static boolean canShowMacSheetPanel() {
        return SystemInfo.isMac && !Messages.isApplicationInUnitTestOrHeadless() && Registry.is((String)"ide.mac.message.dialogs.as.sheets");
    }

    public static boolean isMacSheetEmulation() {
        return SystemInfo.isMac && Registry.is((String)"ide.mac.message.dialogs.as.sheets") && Registry.is((String)"ide.mac.message.sheets.java.emulation");
    }

    public static int showDialog(Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable String moreInfo, @NotNull String[] options, int defaultOptionIndex, int focusedOptionIndex, Icon icon) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showDialog"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/ui/Messages", "showDialog"));
        }
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestImplementation.show(message);
        }
        try {
            if (Messages.canShowMacSheetPanel() && moreInfo == null) {
                return MacMessages.getInstance().showMessageDialog(title, message, options, false, WindowManager.getInstance().suggestParentWindow(project), defaultOptionIndex, focusedOptionIndex, null);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        MoreInfoMessageDialog dialog = new MoreInfoMessageDialog(project, message, title, moreInfo, options, defaultOptionIndex, focusedOptionIndex, icon);
        dialog.show();
        return dialog.getExitCode();
    }

    static boolean isApplicationInUnitTestOrHeadless() {
        Application application = ApplicationManager.getApplication();
        return application != null && (application.isUnitTestMode() || application.isHeadlessEnvironment());
    }

    public static int showDialog(@NotNull Component parent, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, @Nullable Icon icon) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/ui/Messages", "showDialog"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showDialog"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/ui/Messages", "showDialog"));
        }
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestImplementation.show(message);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showMessageDialog(title, message, options, false, SwingUtilities.getWindowAncestor(parent), defaultOptionIndex, defaultOptionIndex, null);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        MessageDialog dialog = new MessageDialog(parent, message, title, options, defaultOptionIndex, defaultOptionIndex, icon, false);
        dialog.show();
        return dialog.getExitCode();
    }

    public static int showDialog(String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showDialog"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/ui/Messages", "showDialog"));
        }
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestImplementation.show(message);
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showMessageDialog(title, message, options, false, null, defaultOptionIndex, focusedOptionIndex, doNotAskOption);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        MessageDialog dialog = new MessageDialog(message, title, options, defaultOptionIndex, focusedOptionIndex, icon, doNotAskOption);
        dialog.show();
        return dialog.getExitCode();
    }

    public static int showDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/ui/Messages", "showDialog"));
        }
        return Messages.showDialog(message, title, options, defaultOptionIndex, defaultOptionIndex, icon, doNotAskOption);
    }

    public static int showDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, @Nullable Icon icon) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/ui/Messages", "showDialog"));
        }
        return Messages.showDialog(message, title, options, defaultOptionIndex, icon, null);
    }

    public static void showMessageDialog(@Nullable Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showMessageDialog"));
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showOkMessageDialog(title, message, OK_BUTTON, WindowManager.getInstance().suggestParentWindow(project));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(project, message, title, new String[]{OK_BUTTON}, 0, icon);
    }

    public static void showMessageDialog(@NotNull Component parent, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/ui/Messages", "showMessageDialog"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showMessageDialog"));
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showOkMessageDialog(title, message, OK_BUTTON, SwingUtilities.getWindowAncestor(parent));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(parent, message, title, new String[]{OK_BUTTON}, 0, icon);
    }

    public static void showMessageDialog(String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showMessageDialog"));
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showOkMessageDialog(title, message, OK_BUTTON);
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(message, title, new String[]{OK_BUTTON}, 0, icon);
    }

    @YesNoResult
    public static int showYesNoDialog(@Nullable Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String yesText, @NotNull String noText, @Nullable Icon icon) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showYesNoDialog"));
        }
        if (yesText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "yesText", "com/intellij/openapi/ui/Messages", "showYesNoDialog"));
        }
        if (noText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "noText", "com/intellij/openapi/ui/Messages", "showYesNoDialog"));
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoDialog(title, message, yesText, noText, WindowManager.getInstance().suggestParentWindow(project));
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        int result = Messages.showDialog(project, message, title, new String[]{yesText, noText}, 0, icon) == 0 ? 0 : 1;
        LOG.assertTrue(result == 0 || result == 1, (Object)result);
        return result;
    }

    @YesNoResult
    public static int showYesNoDialog(@Nullable Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String yesText, @NotNull String noText, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showYesNoDialog"));
        }
        if (yesText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "yesText", "com/intellij/openapi/ui/Messages", "showYesNoDialog"));
        }
        if (noText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "noText", "com/intellij/openapi/ui/Messages", "showYesNoDialog"));
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoDialog(title, message, yesText, noText, WindowManager.getInstance().suggestParentWindow(project), doNotAskOption);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        int result = Messages.showDialog(project, message, title, new String[]{yesText, noText}, 0, icon, doNotAskOption) == 0 ? 0 : 1;
        LOG.assertTrue(result == 0 || result == 1, (Object)result);
        return result;
    }

    @YesNoResult
    public static int showYesNoDialog(@Nullable Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showYesNoDialog"));
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoDialog(title, message, YES_BUTTON, NO_BUTTON, WindowManager.getInstance().suggestParentWindow(project));
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        int result = Messages.showYesNoDialog(project, message, title, YES_BUTTON, NO_BUTTON, icon);
        LOG.assertTrue(result == 0 || result == 1, (Object)result);
        return result;
    }

    @YesNoResult
    public static int showYesNoDialog(@Nullable Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showYesNoDialog"));
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoDialog(title, message, YES_BUTTON, NO_BUTTON, WindowManager.getInstance().suggestParentWindow(project), doNotAskOption);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        int result = Messages.showYesNoDialog(project, message, title, YES_BUTTON, NO_BUTTON, icon, doNotAskOption);
        LOG.assertTrue(result == 0 || result == 1, (Object)result);
        return result;
    }

    @YesNoResult
    public static int showYesNoDialog(@NotNull Component parent, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/ui/Messages", "showYesNoDialog"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showYesNoDialog"));
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoDialog(title, message, YES_BUTTON, NO_BUTTON, SwingUtilities.getWindowAncestor(parent));
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        int result = Messages.showDialog(parent, message, title, new String[]{YES_BUTTON, NO_BUTTON}, 0, icon) == 0 ? 0 : 1;
        LOG.assertTrue(result == 0 || result == 1, (Object)result);
        return result;
    }

    @YesNoResult
    public static int showYesNoDialog(String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String yesText, @NotNull String noText, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showYesNoDialog"));
        }
        if (yesText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "yesText", "com/intellij/openapi/ui/Messages", "showYesNoDialog"));
        }
        if (noText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "noText", "com/intellij/openapi/ui/Messages", "showYesNoDialog"));
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoDialog(title, message, yesText, noText, null, doNotAskOption);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception exception) {
            LOG.error((Throwable)exception);
        }
        int result = Messages.showDialog(message, title, new String[]{yesText, noText}, 0, icon, doNotAskOption) == 0 ? 0 : 1;
        LOG.assertTrue(result == 0 || result == 1, (Object)result);
        return result;
    }

    @YesNoResult
    public static int showYesNoDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, String yesText, String noText, @Nullable Icon icon) {
        return Messages.showYesNoDialog(message, title, yesText, noText, icon, null);
    }

    @YesNoResult
    public static int showYesNoDialog(String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showYesNoDialog"));
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoDialog(title, message, YES_BUTTON, NO_BUTTON, null);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        int result = Messages.showYesNoDialog(message, title, YES_BUTTON, NO_BUTTON, icon);
        LOG.assertTrue(result == 0 || result == 1, (Object)result);
        return result;
    }

    @OkCancelResult
    public static int showOkCancelDialog(Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String okText, @NotNull String cancelText, Icon icon, DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showOkCancelDialog"));
        }
        if (okText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "okText", "com/intellij/openapi/ui/Messages", "showOkCancelDialog"));
        }
        if (cancelText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cancelText", "com/intellij/openapi/ui/Messages", "showOkCancelDialog"));
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                int result = MacMessages.getInstance().showYesNoDialog(title, message, okText, cancelText, WindowManager.getInstance().suggestParentWindow(project), doNotAskOption);
                return result == 0 ? 0 : 2;
            }
        }
        catch (MessageException result) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        return Messages.showDialog(project, message, title, new String[]{okText, cancelText}, 0, icon, doNotAskOption) == 0 ? 0 : 2;
    }

    @OkCancelResult
    public static int showOkCancelDialog(Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String okText, @NotNull String cancelText, Icon icon) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showOkCancelDialog"));
        }
        if (okText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "okText", "com/intellij/openapi/ui/Messages", "showOkCancelDialog"));
        }
        if (cancelText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cancelText", "com/intellij/openapi/ui/Messages", "showOkCancelDialog"));
        }
        return Messages.showOkCancelDialog(project, message, title, okText, cancelText, icon, null);
    }

    @OkCancelResult
    public static int showOkCancelDialog(Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, Icon icon) {
        return Messages.showOkCancelDialog(project, message, title, OK_BUTTON, CANCEL_BUTTON, icon);
    }

    @OkCancelResult
    public static int showOkCancelDialog(@NotNull Component parent, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String okText, @NotNull String cancelText, Icon icon) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/ui/Messages", "showOkCancelDialog"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showOkCancelDialog"));
        }
        if (okText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "okText", "com/intellij/openapi/ui/Messages", "showOkCancelDialog"));
        }
        if (cancelText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cancelText", "com/intellij/openapi/ui/Messages", "showOkCancelDialog"));
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                int result = MacMessages.getInstance().showYesNoDialog(title, message, okText, cancelText, SwingUtilities.getWindowAncestor(parent));
                return result == 0 ? 0 : 2;
            }
        }
        catch (MessageException result) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        return Messages.showDialog(parent, message, title, new String[]{okText, cancelText}, 0, icon) == 0 ? 0 : 2;
    }

    @OkCancelResult
    public static int showOkCancelDialog(@NotNull Component parent, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, Icon icon) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/ui/Messages", "showOkCancelDialog"));
        }
        return Messages.showOkCancelDialog(parent, message, title, OK_BUTTON, CANCEL_BUTTON, icon);
    }

    @OkCancelResult
    public static int showOkCancelDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, Icon icon) {
        return Messages.showOkCancelDialog(message, title, OK_BUTTON, CANCEL_BUTTON, icon, null);
    }

    @OkCancelResult
    public static int showOkCancelDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, String okText, String cancelText, Icon icon) {
        return Messages.showOkCancelDialog(message, title, okText, cancelText, icon, null);
    }

    @OkCancelResult
    public static int showOkCancelDialog(String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String okText, @NotNull String cancelText, Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showOkCancelDialog"));
        }
        if (okText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "okText", "com/intellij/openapi/ui/Messages", "showOkCancelDialog"));
        }
        if (cancelText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cancelText", "com/intellij/openapi/ui/Messages", "showOkCancelDialog"));
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                int result = MacMessages.getInstance().showYesNoDialog(title, message, okText, cancelText, null, doNotAskOption);
                return result == 0 ? 0 : 2;
            }
        }
        catch (MessageException result) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        return Messages.showDialog(message, title, new String[]{okText, cancelText}, 0, icon, doNotAskOption) == 0 ? 0 : 2;
    }

    public static int showCheckboxOkCancelDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, String checkboxText, boolean checked, int defaultOptionIndex, int focusedOptionIndex, Icon icon) {
        return Messages.showCheckboxMessageDialog(message, title, new String[]{OK_BUTTON, CANCEL_BUTTON}, checkboxText, checked, defaultOptionIndex, focusedOptionIndex, icon, new PairFunction<Integer, JCheckBox, Integer>(){

            public Integer fun(Integer exitCode, JCheckBox cb) {
                return exitCode == -1 ? 2 : exitCode + (cb.isSelected() ? 1 : 0);
            }
        });
    }

    public static int showCheckboxMessageDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, String checkboxText, boolean checked, int defaultOptionIndex, int focusedOptionIndex, Icon icon, @Nullable PairFunction<Integer, JCheckBox, Integer> exitFunc) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/ui/Messages", "showCheckboxMessageDialog"));
        }
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestImplementation.show(message);
        }
        TwoStepConfirmationDialog dialog = new TwoStepConfirmationDialog(message, title, options, checkboxText, checked, defaultOptionIndex, focusedOptionIndex, icon, exitFunc);
        dialog.show();
        return dialog.getExitCode();
    }

    public static int showTwoStepConfirmationDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, String checkboxText, Icon icon) {
        return Messages.showCheckboxMessageDialog(message, title, new String[]{OK_BUTTON}, checkboxText, true, -1, -1, icon, null);
    }

    public static void showErrorDialog(@Nullable Project project, @Nls String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showErrorDialog"));
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showErrorDialog(title, message, OK_BUTTON, WindowManager.getInstance().suggestParentWindow(project));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(project, message, title, new String[]{OK_BUTTON}, 0, Messages.getErrorIcon());
    }

    public static void showErrorDialog(@NotNull Component component, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/ui/Messages", "showErrorDialog"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showErrorDialog"));
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showErrorDialog(title, message, OK_BUTTON, SwingUtilities.getWindowAncestor(component));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(component, message, title, new String[]{OK_BUTTON}, 0, Messages.getErrorIcon());
    }

    public static void showErrorDialog(@NotNull Component component, String message) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/ui/Messages", "showErrorDialog"));
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showErrorDialog(CommonBundle.getErrorTitle(), message, OK_BUTTON, SwingUtilities.getWindowAncestor(component));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(component, message, CommonBundle.getErrorTitle(), new String[]{OK_BUTTON}, 0, Messages.getErrorIcon());
    }

    public static void showErrorDialog(String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showErrorDialog"));
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showErrorDialog(title, message, OK_BUTTON, null);
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(message, title, new String[]{OK_BUTTON}, 0, Messages.getErrorIcon());
    }

    public static void showWarningDialog(@Nullable Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showWarningDialog"));
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showErrorDialog(title, message, OK_BUTTON, WindowManager.getInstance().suggestParentWindow(project));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(project, message, title, new String[]{OK_BUTTON}, 0, Messages.getWarningIcon());
    }

    public static void showWarningDialog(@NotNull Component component, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/ui/Messages", "showWarningDialog"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showWarningDialog"));
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showErrorDialog(title, message, OK_BUTTON, SwingUtilities.getWindowAncestor(component));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(component, message, title, new String[]{OK_BUTTON}, 0, Messages.getWarningIcon());
    }

    public static void showWarningDialog(String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showWarningDialog"));
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showErrorDialog(title, message, OK_BUTTON, null);
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showDialog(message, title, new String[]{OK_BUTTON}, 0, Messages.getWarningIcon());
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(Project project, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String yes, @NotNull String no, @NotNull String cancel, @Nullable Icon icon) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showYesNoCancelDialog"));
        }
        if (yes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "yes", "com/intellij/openapi/ui/Messages", "showYesNoCancelDialog"));
        }
        if (no == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "no", "com/intellij/openapi/ui/Messages", "showYesNoCancelDialog"));
        }
        if (cancel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cancel", "com/intellij/openapi/ui/Messages", "showYesNoCancelDialog"));
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoCancelDialog(title, message, yes, no, cancel, WindowManager.getInstance().suggestParentWindow(project), null);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        int buttonNumber = Messages.showDialog(project, message, title, new String[]{yes, no, cancel}, 0, icon);
        return buttonNumber == 0 ? 0 : (buttonNumber == 1 ? 1 : 2);
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, Icon icon) {
        return Messages.showYesNoCancelDialog(project, message, title, YES_BUTTON, NO_BUTTON, CANCEL_BUTTON, icon);
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(@NotNull Component parent, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String yes, @NotNull String no, @NotNull String cancel, Icon icon) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/ui/Messages", "showYesNoCancelDialog"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showYesNoCancelDialog"));
        }
        if (yes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "yes", "com/intellij/openapi/ui/Messages", "showYesNoCancelDialog"));
        }
        if (no == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "no", "com/intellij/openapi/ui/Messages", "showYesNoCancelDialog"));
        }
        if (cancel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cancel", "com/intellij/openapi/ui/Messages", "showYesNoCancelDialog"));
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoCancelDialog(title, message, yes, no, cancel, SwingUtilities.getWindowAncestor(parent), null);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        int buttonNumber = Messages.showDialog(parent, message, title, new String[]{yes, no, cancel}, 0, icon);
        return buttonNumber == 0 ? 0 : (buttonNumber == 1 ? 1 : 2);
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(@NotNull Component parent, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, Icon icon) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/ui/Messages", "showYesNoCancelDialog"));
        }
        return Messages.showYesNoCancelDialog(parent, message, title, YES_BUTTON, NO_BUTTON, CANCEL_BUTTON, icon);
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String yes, @NotNull String no, @NotNull String cancel, Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showYesNoCancelDialog"));
        }
        if (yes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "yes", "com/intellij/openapi/ui/Messages", "showYesNoCancelDialog"));
        }
        if (no == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "no", "com/intellij/openapi/ui/Messages", "showYesNoCancelDialog"));
        }
        if (cancel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cancel", "com/intellij/openapi/ui/Messages", "showYesNoCancelDialog"));
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                return MacMessages.getInstance().showYesNoCancelDialog(title, message, yes, no, cancel, null, doNotAskOption);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        int buttonNumber = Messages.showDialog(message, title, new String[]{yes, no, cancel}, 0, icon, doNotAskOption);
        return buttonNumber == 0 ? 0 : (buttonNumber == 1 ? 1 : 2);
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, String yes, String no, String cancel, Icon icon) {
        return Messages.showYesNoCancelDialog(message, title, yes, no, cancel, icon, null);
    }

    @YesNoCancelResult
    public static int showYesNoCancelDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, Icon icon) {
        return Messages.showYesNoCancelDialog(message, title, YES_BUTTON, NO_BUTTON, CANCEL_BUTTON, icon);
    }

    @Nullable
    public static String showPasswordDialog(@Nls String message, @Nls(capitalization=Nls.Capitalization.Title) String title) {
        return Messages.showPasswordDialog(null, message, title, null, null);
    }

    @Nullable
    public static String showPasswordDialog(Project project, @Nls String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        return Messages.showPasswordDialog(project, message, title, icon, null);
    }

    @Nullable
    public static String showPasswordDialog(@Nullable Project project, @Nls String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable InputValidator validator) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestInputImplementation.show(message);
        }
        PasswordInputDialog dialog = project != null ? new PasswordInputDialog(project, message, title, icon, validator) : new PasswordInputDialog(message, title, icon, validator);
        dialog.show();
        return dialog.getInputString();
    }

    @Nullable
    public static String showInputDialog(@Nullable Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        return Messages.showInputDialog(project, message, title, icon, null, null);
    }

    @Nullable
    public static String showInputDialog(@NotNull Component parent, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/ui/Messages", "showInputDialog"));
        }
        return Messages.showInputDialog(parent, message, title, icon, null, null);
    }

    @Nullable
    public static String showInputDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon) {
        return Messages.showInputDialog(message, title, icon, null, null);
    }

    @Nullable
    public static String showInputDialog(@Nullable Project project, @Nls String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestInputImplementation.show(message);
        }
        InputDialog dialog = new InputDialog(project, message, title, icon, initialValue, validator);
        dialog.show();
        return dialog.getInputString();
    }

    @Nullable
    public static String showInputDialog(Project project, @Nls String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator, @Nullable TextRange selection) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestInputImplementation.show(message);
        }
        InputDialog dialog = new InputDialog(project, message, title, icon, initialValue, validator);
        JTextComponent field = dialog.getTextField();
        if (selection != null) {
            field.select(selection.getStartOffset(), selection.getEndOffset());
        } else {
            int length = field.getDocument().getLength();
            field.select(length, length);
        }
        field.putClientProperty(DialogWrapperPeer.HAVE_INITIAL_SELECTION, true);
        dialog.show();
        return dialog.getInputString();
    }

    @Nullable
    public static String showInputDialog(@NotNull Component parent, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/ui/Messages", "showInputDialog"));
        }
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestInputImplementation.show(message);
        }
        InputDialog dialog = new InputDialog(parent, message, title, icon, initialValue, validator);
        dialog.show();
        return dialog.getInputString();
    }

    @Nullable
    public static String showInputDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestInputImplementation.show(message);
        }
        InputDialog dialog = new InputDialog(message, title, icon, initialValue, validator);
        dialog.show();
        return dialog.getInputString();
    }

    @Nullable
    public static String showMultilineInputDialog(Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable String initialValue, @Nullable Icon icon, @Nullable InputValidator validator) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestInputImplementation.show(message);
        }
        MultilineInputDialog dialog = new MultilineInputDialog(project, message, title, icon, initialValue, validator, new String[]{OK_BUTTON, CANCEL_BUTTON}, 0);
        dialog.show();
        return dialog.getInputString();
    }

    @NotNull
    public static Pair<String, Boolean> showInputDialogWithCheckBox(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, String checkboxText, boolean checked, boolean checkboxEnabled, @Nullable Icon icon, @NonNls String initialValue, @Nullable InputValidator validator) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            Pair pair = new Pair((Object)ourTestInputImplementation.show(message), (Object)checked);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/Messages", "showInputDialogWithCheckBox"));
            }
            return pair;
        }
        InputDialogWithCheckbox dialog = new InputDialogWithCheckbox(message, title, checkboxText, checked, checkboxEnabled, icon, initialValue, validator);
        dialog.show();
        Pair pair = Pair.create((Object)dialog.getInputString(), (Object)dialog.isChecked());
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/Messages", "showInputDialogWithCheckBox"));
        }
        return pair;
    }

    @Nullable
    public static String showEditableChooseDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, String[] values, String initialValue, @Nullable InputValidator validator) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestInputImplementation.show(message);
        }
        ChooseDialog dialog = new ChooseDialog(message, title, icon, values, initialValue);
        dialog.setValidator(validator);
        dialog.getComboBox().setEditable(true);
        dialog.getComboBox().getEditor().setItem(initialValue);
        dialog.getComboBox().setSelectedItem(initialValue);
        dialog.show();
        return dialog.getInputString();
    }

    @Deprecated
    public static int showChooseDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, String[] values, String initialValue, @Nullable Icon icon) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestImplementation.show(message);
        }
        ChooseDialog dialog = new ChooseDialog(message, title, icon, values, initialValue);
        dialog.show();
        return dialog.getSelectedIndex();
    }

    @Deprecated
    public static int showChooseDialog(@NotNull Component parent, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, String[] values, String initialValue, Icon icon) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/ui/Messages", "showChooseDialog"));
        }
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestImplementation.show(message);
        }
        ChooseDialog dialog = new ChooseDialog(parent, message, title, icon, values, initialValue);
        dialog.show();
        return dialog.getSelectedIndex();
    }

    @Deprecated
    public static int showChooseDialog(Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, Icon icon, String[] values, String initialValue) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return ourTestImplementation.show(message);
        }
        ChooseDialog dialog = new ChooseDialog(project, message, title, icon, values, initialValue);
        dialog.show();
        return dialog.getSelectedIndex();
    }

    public static void showInfoMessage(Component component, String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showInfoMessage"));
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showOkMessageDialog(title, message, OK_BUTTON, SwingUtilities.getWindowAncestor(component));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showMessageDialog(component, message, title, Messages.getInformationIcon());
    }

    public static void showInfoMessage(@Nullable Project project, @Nls String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showInfoMessage"));
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showOkMessageDialog(title, message, OK_BUTTON, WindowManager.getInstance().suggestParentWindow(project));
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showMessageDialog(project, message, title, Messages.getInformationIcon());
    }

    public static void showInfoMessage(String message, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/ui/Messages", "showInfoMessage"));
        }
        try {
            if (Messages.canShowMacSheetPanel()) {
                MacMessages.getInstance().showOkMessageDialog(title, message, OK_BUTTON, null);
                return;
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        Messages.showMessageDialog(message, title, Messages.getInformationIcon());
    }

    public static void showTextAreaDialog(final JTextField textField, @Nls(capitalization=Nls.Capitalization.Title) String title, @NonNls String dimensionServiceKey, Function<String, List<String>> parser, final Function<List<String>, String> lineJoiner) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            ourTestImplementation.show(title);
        } else {
            final JTextArea textArea = new JTextArea(10, 50);
            UIUtil.addUndoRedoActions((JTextComponent)textArea);
            textArea.setWrapStyleWord(true);
            textArea.setLineWrap(true);
            List lines = (List)parser.fun((Object)textField.getText());
            textArea.setText(StringUtil.join((Collection)lines, (String)"\n"));
            InsertPathAction.copyFromTo(textField, textArea);
            final DialogBuilder builder = new DialogBuilder(textField);
            builder.setDimensionServiceKey(dimensionServiceKey);
            builder.setCenterPanel(ScrollPaneFactory.createScrollPane(textArea));
            builder.setPreferredFocusComponent(textArea);
            String rawText = title;
            if (StringUtil.endsWithChar((CharSequence)rawText, (char)':')) {
                rawText = rawText.substring(0, rawText.length() - 1);
            }
            builder.setTitle(rawText);
            builder.addOkAction();
            builder.addCancelAction();
            builder.setOkOperation(new Runnable(){

                @Override
                public void run() {
                    textField.setText((String)lineJoiner.fun(Arrays.asList(StringUtil.splitByLines((String)textArea.getText()))));
                    builder.getDialogWrapper().close(0);
                }
            });
            builder.show();
        }
    }

    public static void showTextAreaDialog(JTextField textField, @Nls(capitalization=Nls.Capitalization.Title) String title, @NonNls String dimensionServiceKey) {
        Messages.showTextAreaDialog(textField, title, dimensionServiceKey, (Function<String, List<String>>)ParametersListUtil.DEFAULT_LINE_PARSER, (Function<List<String>, String>)ParametersListUtil.DEFAULT_LINE_JOINER);
    }

    public static void installHyperlinkSupport(JTextPane messageComponent) {
        Messages.configureMessagePaneUi(messageComponent, "<html></html>");
    }

    @NotNull
    public static JTextPane configureMessagePaneUi(JTextPane messageComponent, String message) {
        JTextPane pane = Messages.configureMessagePaneUi(messageComponent, message, null);
        if ("text/html".equals(pane.getContentType())) {
            pane.addHyperlinkListener(BrowserHyperlinkListener.INSTANCE);
        }
        JTextPane jTextPane = pane;
        if (jTextPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/Messages", "configureMessagePaneUi"));
        }
        return jTextPane;
    }

    @NotNull
    public static JTextPane configureMessagePaneUi(@NotNull JTextPane messageComponent, @Nullable String message, @Nullable UIUtil.FontSize fontSize) {
        if (messageComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageComponent", "com/intellij/openapi/ui/Messages", "configureMessagePaneUi"));
        }
        UIUtil.FontSize fixedFontSize = fontSize == null ? UIUtil.FontSize.NORMAL : fontSize;
        messageComponent.setFont(UIUtil.getLabelFont((UIUtil.FontSize)fixedFontSize));
        if (BasicHTML.isHTMLString(message)) {
            HTMLEditorKit editorKit = new HTMLEditorKit();
            Font font = UIUtil.getLabelFont((UIUtil.FontSize)fixedFontSize);
            editorKit.getStyleSheet().addRule(UIUtil.displayPropertiesToCSS((Font)font, (Color)UIUtil.getLabelForeground()));
            messageComponent.setEditorKit(editorKit);
            messageComponent.setContentType("text/html");
        }
        messageComponent.setText(message);
        messageComponent.setEditable(false);
        if (messageComponent.getCaret() != null) {
            messageComponent.setCaretPosition(0);
        }
        if (UIUtil.isUnderNimbusLookAndFeel()) {
            messageComponent.setOpaque(false);
            messageComponent.setBackground(UIUtil.TRANSPARENT_COLOR);
        } else {
            messageComponent.setBackground(UIUtil.getOptionPaneBackground());
        }
        messageComponent.setForeground(UIUtil.getLabelForeground());
        JTextPane jTextPane = messageComponent;
        if (jTextPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/Messages", "configureMessagePaneUi"));
        }
        return jTextPane;
    }

    @NotNull
    public static JComponent wrapToScrollPaneIfNeeded(@NotNull JComponent comp, int columns, int lines) {
        if (comp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comp", "com/intellij/openapi/ui/Messages", "wrapToScrollPaneIfNeeded"));
        }
        float fontSize = comp.getFont().getSize2D();
        Dimension maxDim = new Dimension((int)(fontSize * (float)columns), (int)(fontSize * (float)lines));
        Dimension prefDim = comp.getPreferredSize();
        if (prefDim.width <= maxDim.width && prefDim.height <= maxDim.height) {
            JComponent jComponent = comp;
            if (jComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/Messages", "wrapToScrollPaneIfNeeded"));
            }
            return jComponent;
        }
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(comp);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        int barWidth = UIUtil.getScrollBarWidth();
        Dimension preferredSize = new Dimension(Math.min(prefDim.width, maxDim.width) + barWidth, Math.min(prefDim.height, maxDim.height) + barWidth);
        scrollPane.setPreferredSize(preferredSize);
        JScrollPane jScrollPane = scrollPane;
        if (jScrollPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/Messages", "wrapToScrollPaneIfNeeded"));
        }
        return jScrollPane;
    }

    @Deprecated
    protected static class ChooseDialog
    extends MessageDialog {
        private ComboBox myComboBox;
        private InputValidator myValidator;

        public ChooseDialog(Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, String[] values, String initialValue, @NotNull String[] options, int defaultOption) {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/ui/Messages$ChooseDialog", "<init>"));
            }
            super(project, message, title, options, defaultOption, icon, true);
            this.myComboBox.setModel(new DefaultComboBoxModel<String>(values));
            this.myComboBox.setSelectedItem(initialValue);
        }

        public ChooseDialog(Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, String[] values, String initialValue) {
            this(project, message, title, icon, values, initialValue, new String[]{OK_BUTTON, CANCEL_BUTTON}, 0);
        }

        public ChooseDialog(@NotNull Component parent, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, String[] values, String initialValue) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/ui/Messages$ChooseDialog", "<init>"));
            }
            super(parent, message, title, new String[]{OK_BUTTON, CANCEL_BUTTON}, 0, icon);
            this.myComboBox.setModel(new DefaultComboBoxModel<String>(values));
            this.myComboBox.setSelectedItem(initialValue);
        }

        public ChooseDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, String[] values, String initialValue) {
            super(message, title, new String[]{OK_BUTTON, CANCEL_BUTTON}, 0, icon);
            this.myComboBox.setModel(new DefaultComboBoxModel<String>(values));
            this.myComboBox.setSelectedItem(initialValue);
        }

        @Override
        @NotNull
        protected Action[] createActions() {
            final Action[] actions = new Action[this.myOptions.length];
            for (int i = 0; i < this.myOptions.length; ++i) {
                String option = this.myOptions[i];
                final int exitCode = i;
                if (i == this.myDefaultOptionIndex) {
                    actions[i] = new AbstractAction(option){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (ChooseDialog.this.myValidator == null || ChooseDialog.this.myValidator.checkInput(ChooseDialog.this.myComboBox.getSelectedItem().toString().trim())) {
                                ChooseDialog.this.close(exitCode);
                            }
                        }
                    };
                    actions[i].putValue("DefaultAction", Boolean.TRUE);
                    this.myComboBox.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            actions[exitCode].setEnabled(ChooseDialog.this.myValidator == null || ChooseDialog.this.myValidator.checkInput(ChooseDialog.this.myComboBox.getSelectedItem().toString().trim()));
                        }
                    });
                    final JTextField textField = (JTextField)this.myComboBox.getEditor().getEditorComponent();
                    textField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                        public void textChanged(DocumentEvent event) {
                            actions[exitCode].setEnabled(ChooseDialog.this.myValidator == null || ChooseDialog.this.myValidator.checkInput(textField.getText().trim()));
                        }
                    });
                    continue;
                }
                actions[i] = new AbstractAction(option){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ChooseDialog.this.close(exitCode);
                    }
                };
            }
            if (actions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/Messages$ChooseDialog", "createActions"));
            }
            return actions;
        }

        @Override
        protected JComponent createCenterPanel() {
            return null;
        }

        @Override
        protected JComponent createNorthPanel() {
            JPanel panel = new JPanel(new BorderLayout(15, 0));
            if (this.myIcon != null) {
                JLabel iconLabel = new JLabel(this.myIcon);
                Container container = new Container();
                container.setLayout(new BorderLayout());
                container.add((Component)iconLabel, "North");
                panel.add((Component)container, "West");
            }
            JPanel messagePanel = new JPanel(new BorderLayout());
            if (this.myMessage != null) {
                JLabel textLabel = new JLabel(this.myMessage);
                textLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
                textLabel.setUI(new MultiLineLabelUI());
                messagePanel.add((Component)textLabel, "North");
            }
            this.myComboBox = new ComboBox(220);
            messagePanel.add((Component)this.myComboBox, "South");
            panel.add((Component)messagePanel, "Center");
            return panel;
        }

        @Override
        protected void doOKAction() {
            String inputString = this.myComboBox.getSelectedItem().toString().trim();
            if (this.myValidator == null || this.myValidator.checkInput(inputString) && this.myValidator.canClose(inputString)) {
                super.doOKAction();
            }
        }

        @Override
        public JComponent getPreferredFocusedComponent() {
            return this.myComboBox;
        }

        @Nullable
        public String getInputString() {
            if (this.getExitCode() == 0) {
                return this.myComboBox.getSelectedItem().toString();
            }
            return null;
        }

        public int getSelectedIndex() {
            if (this.getExitCode() == 0) {
                return this.myComboBox.getSelectedIndex();
            }
            return -1;
        }

        public JComboBox getComboBox() {
            return this.myComboBox;
        }

        public void setValidator(@Nullable InputValidator validator) {
            this.myValidator = validator;
        }
    }

    protected static class InputDialogWithCheckbox
    extends InputDialog {
        private JCheckBox myCheckBox;

        public InputDialogWithCheckbox(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, String checkboxText, boolean checked, boolean checkboxEnabled, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator) {
            super(message, title, icon, initialValue, validator);
            this.myCheckBox.setText(checkboxText);
            this.myCheckBox.setSelected(checked);
            this.myCheckBox.setEnabled(checkboxEnabled);
        }

        @Override
        protected JPanel createMessagePanel() {
            JPanel messagePanel = new JPanel(new BorderLayout());
            if (this.myMessage != null) {
                JComponent textComponent = this.createTextComponent();
                messagePanel.add((Component)textComponent, "North");
            }
            this.myField = this.createTextFieldComponent();
            messagePanel.add((Component)this.myField, "Center");
            this.myCheckBox = new JCheckBox();
            messagePanel.add((Component)this.myCheckBox, "South");
            return messagePanel;
        }

        public Boolean isChecked() {
            return this.myCheckBox.isSelected();
        }
    }

    protected static class PasswordInputDialog
    extends InputDialog {
        public PasswordInputDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable InputValidator validator) {
            super(message, title, icon, null, validator);
        }

        public PasswordInputDialog(Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable InputValidator validator) {
            super(project, message, title, icon, null, validator);
        }

        @Override
        protected JTextComponent createTextFieldComponent() {
            return new JPasswordField(30);
        }
    }

    protected static class MultilineInputDialog
    extends InputDialog {
        public MultilineInputDialog(Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator, @NotNull String[] options, int defaultOption) {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/ui/Messages$MultilineInputDialog", "<init>"));
            }
            super(project, message, title, icon, initialValue, validator, options, defaultOption);
        }

        @Override
        protected JTextComponent createTextFieldComponent() {
            return new JTextArea(7, 50);
        }
    }

    protected static class InputDialog
    extends MessageDialog {
        protected JTextComponent myField;
        private final InputValidator myValidator;

        public InputDialog(@Nullable Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator, @NotNull String[] options, int defaultOption) {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/ui/Messages$InputDialog", "<init>"));
            }
            super(project, message, title, options, defaultOption, icon, true);
            this.myValidator = validator;
            this.myField.setText(initialValue);
            this.enableOkAction();
        }

        public InputDialog(@Nullable Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator) {
            this(project, message, title, icon, initialValue, validator, new String[]{OK_BUTTON, CANCEL_BUTTON}, 0);
        }

        public InputDialog(@NotNull Component parent, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/ui/Messages$InputDialog", "<init>"));
            }
            super(parent, message, title, new String[]{OK_BUTTON, CANCEL_BUTTON}, 0, icon, true);
            this.myValidator = validator;
            this.myField.setText(initialValue);
            this.enableOkAction();
        }

        public InputDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable Icon icon, @Nullable String initialValue, @Nullable InputValidator validator) {
            super(message, title, new String[]{OK_BUTTON, CANCEL_BUTTON}, 0, icon, true);
            this.myValidator = validator;
            this.myField.setText(initialValue);
            this.enableOkAction();
        }

        private void enableOkAction() {
            this.getOKAction().setEnabled(this.myValidator == null || this.myValidator.checkInput(this.myField.getText().trim()));
        }

        @Override
        @NotNull
        protected Action[] createActions() {
            final Action[] actions = new Action[this.myOptions.length];
            for (int i = 0; i < this.myOptions.length; ++i) {
                String option = this.myOptions[i];
                final int exitCode = i;
                if (i == 0) {
                    actions[i] = this.getOKAction();
                    actions[i].putValue("DefaultAction", Boolean.TRUE);
                    this.myField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                        public void textChanged(DocumentEvent event) {
                            String text = InputDialog.this.myField.getText().trim();
                            actions[exitCode].setEnabled(InputDialog.this.myValidator == null || InputDialog.this.myValidator.checkInput(text));
                            if (InputDialog.this.myValidator instanceof InputValidatorEx) {
                                InputDialog.this.setErrorText(((InputValidatorEx)InputDialog.this.myValidator).getErrorText(text));
                            }
                        }
                    });
                    continue;
                }
                actions[i] = new AbstractAction(option){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        InputDialog.this.close(exitCode);
                    }
                };
            }
            if (actions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/Messages$InputDialog", "createActions"));
            }
            return actions;
        }

        @Override
        protected void doOKAction() {
            String inputString = this.myField.getText().trim();
            if (this.myValidator == null || this.myValidator.checkInput(inputString) && this.myValidator.canClose(inputString)) {
                this.close(0);
            }
        }

        @Override
        protected JComponent createCenterPanel() {
            return null;
        }

        @Override
        protected JComponent createNorthPanel() {
            JPanel panel = new JPanel(new BorderLayout(15, 0));
            if (this.myIcon != null) {
                JLabel iconLabel = new JLabel(this.myIcon);
                Container container = new Container();
                container.setLayout(new BorderLayout());
                container.add((Component)iconLabel, "North");
                panel.add((Component)container, "West");
            }
            JPanel messagePanel = this.createMessagePanel();
            panel.add((Component)messagePanel, "Center");
            return panel;
        }

        protected JPanel createMessagePanel() {
            JPanel messagePanel = new JPanel(new BorderLayout());
            if (this.myMessage != null) {
                JComponent textComponent = this.createTextComponent();
                messagePanel.add((Component)textComponent, "North");
            }
            this.myField = this.createTextFieldComponent();
            messagePanel.add((Component)this.myField, "South");
            return messagePanel;
        }

        protected JComponent createTextComponent() {
            JComponent textComponent;
            if (BasicHTML.isHTMLString(this.myMessage)) {
                textComponent = InputDialog.createMessageComponent(this.myMessage);
            } else {
                JLabel textLabel = new JLabel(this.myMessage);
                textLabel.setUI(new MultiLineLabelUI());
                textComponent = textLabel;
            }
            textComponent.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            return textComponent;
        }

        public JTextComponent getTextField() {
            return this.myField;
        }

        protected JTextComponent createTextFieldComponent() {
            return new JTextField(30);
        }

        @Override
        public JComponent getPreferredFocusedComponent() {
            return this.myField;
        }

        @Nullable
        public String getInputString() {
            if (this.getExitCode() == 0) {
                return this.myField.getText().trim();
            }
            return null;
        }
    }

    protected static class TwoStepConfirmationDialog
    extends MessageDialog {
        private JCheckBox myCheckBox;
        private final String myCheckboxText;
        private final boolean myChecked;
        private final PairFunction<Integer, JCheckBox, Integer> myExitFunc;

        public TwoStepConfirmationDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, String checkboxText, boolean checked, int defaultOptionIndexed, int focusedOptionIndex, Icon icon, @Nullable PairFunction<Integer, JCheckBox, Integer> exitFunc) {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/ui/Messages$TwoStepConfirmationDialog", "<init>"));
            }
            this.myCheckboxText = checkboxText;
            this.myChecked = checked;
            this.myExitFunc = exitFunc;
            this._init(title, message, options, defaultOptionIndexed, focusedOptionIndex, icon, null);
        }

        @Override
        protected JComponent createNorthPanel() {
            JPanel panel = new JPanel(new BorderLayout(15, 0));
            if (this.myIcon != null) {
                JLabel iconLabel = new JLabel(this.myIcon);
                Container container = new Container();
                container.setLayout(new BorderLayout());
                container.add((Component)iconLabel, "North");
                panel.add((Component)container, "West");
            }
            JPanel messagePanel = new JPanel(new BorderLayout());
            if (this.myMessage != null) {
                JLabel textLabel = new JLabel(this.myMessage);
                textLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
                textLabel.setUI(new MultiLineLabelUI());
                messagePanel.add((Component)textLabel, "North");
            }
            JPanel checkboxPanel = new JPanel();
            checkboxPanel.setLayout(new BoxLayout(checkboxPanel, 0));
            this.myCheckBox = new JCheckBox(this.myCheckboxText);
            this.myCheckBox.setSelected(this.myChecked);
            messagePanel.add((Component)this.myCheckBox, "South");
            panel.add((Component)messagePanel, "Center");
            return panel;
        }

        @Override
        public int getExitCode() {
            int exitCode = super.getExitCode();
            if (this.myExitFunc != null) {
                return (Integer)this.myExitFunc.fun((Object)exitCode, (Object)this.myCheckBox);
            }
            boolean checkBoxSelected = this.myCheckBox != null && this.myCheckBox.isSelected();
            boolean okExitCode = exitCode == 0;
            return checkBoxSelected && okExitCode ? 0 : 1;
        }

        @Override
        public JComponent getPreferredFocusedComponent() {
            return this.myDefaultOptionIndex == -1 ? this.myCheckBox : super.getPreferredFocusedComponent();
        }

        @Override
        protected JComponent createCenterPanel() {
            return null;
        }
    }

    private static class MyBorderLayout
    extends BorderLayout {
        private double myPhase = 0.0;

        private MyBorderLayout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container target) {
            Dimension realSize = target.getSize();
            target.setSize(target.getPreferredSize());
            super.layoutContainer(target);
            target.setSize(realSize);
            Object object = target.getTreeLock();
            synchronized (object) {
                Component[] components;
                int yShift = (int)((1.0 - this.myPhase) * (double)target.getPreferredSize().height);
                for (Component component : components = target.getComponents()) {
                    Point point = component.getLocation();
                    point.y -= yShift;
                    component.setLocation(point);
                }
            }
        }
    }

    private static class MessageDialog
    extends DialogWrapper {
        protected String myMessage;
        protected String[] myOptions;
        protected int myDefaultOptionIndex;
        protected int myFocusedOptionIndex;
        protected Icon myIcon;
        private MyBorderLayout myLayout;

        public MessageDialog(@Nullable Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, @Nullable Icon icon, boolean canBeParent) {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/ui/Messages$MessageDialog", "<init>"));
            }
            this(project, message, title, options, defaultOptionIndex, -1, icon, canBeParent);
        }

        public MessageDialog(@Nullable Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption, boolean canBeParent) {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/ui/Messages$MessageDialog", "<init>"));
            }
            super(project, canBeParent);
            this._init(title, message, options, defaultOptionIndex, focusedOptionIndex, icon, doNotAskOption);
        }

        public MessageDialog(@Nullable Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon, boolean canBeParent) {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/ui/Messages$MessageDialog", "<init>"));
            }
            super(project, canBeParent);
            this._init(title, message, options, defaultOptionIndex, focusedOptionIndex, icon, null);
        }

        public MessageDialog(@NotNull Component parent, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, @Nullable Icon icon) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/ui/Messages$MessageDialog", "<init>"));
            }
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/ui/Messages$MessageDialog", "<init>"));
            }
            this(parent, message, title, options, defaultOptionIndex, icon, false);
        }

        public MessageDialog(@NotNull Component parent, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, @Nullable Icon icon, boolean canBeParent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/ui/Messages$MessageDialog", "<init>"));
            }
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/ui/Messages$MessageDialog", "<init>"));
            }
            this(parent, message, title, options, defaultOptionIndex, -1, icon, canBeParent);
        }

        public MessageDialog(@NotNull Component parent, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon, boolean canBeParent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/ui/Messages$MessageDialog", "<init>"));
            }
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/ui/Messages$MessageDialog", "<init>"));
            }
            super(parent, canBeParent);
            this._init(title, message, options, defaultOptionIndex, focusedOptionIndex, icon, null);
        }

        public MessageDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, @Nullable Icon icon) {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/ui/Messages$MessageDialog", "<init>"));
            }
            this(message, title, options, defaultOptionIndex, icon, false);
        }

        public MessageDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, @Nullable Icon icon, boolean canBeParent) {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/ui/Messages$MessageDialog", "<init>"));
            }
            super(canBeParent);
            this._init(title, message, options, defaultOptionIndex, -1, icon, null);
        }

        public MessageDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/ui/Messages$MessageDialog", "<init>"));
            }
            super(false);
            this._init(title, message, options, defaultOptionIndex, focusedOptionIndex, icon, doNotAskOption);
        }

        public MessageDialog(String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull String[] options, int defaultOptionIndex, Icon icon, DialogWrapper.DoNotAskOption doNotAskOption) {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/ui/Messages$MessageDialog", "<init>"));
            }
            this(message, title, options, defaultOptionIndex, -1, icon, doNotAskOption);
        }

        protected MessageDialog() {
            super(false);
        }

        protected MessageDialog(Project project) {
            super(project, false);
        }

        protected void _init(@Nls(capitalization=Nls.Capitalization.Title) String title, String message, @NotNull String[] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/ui/Messages$MessageDialog", "_init"));
            }
            this.setTitle(title);
            if (Messages.isMacSheetEmulation()) {
                this.setUndecorated(true);
            }
            this.myMessage = message;
            this.myOptions = options;
            this.myDefaultOptionIndex = defaultOptionIndex;
            this.myFocusedOptionIndex = focusedOptionIndex;
            this.myIcon = icon;
            if (!SystemInfo.isMac) {
                this.setButtonsAlignment(0);
            }
            this.setDoNotAskOption(doNotAskOption);
            this.init();
            if (Messages.isMacSheetEmulation()) {
                MacUtil.adjustFocusTraversal((Disposable)this.myDisposable);
            }
        }

        @Override
        @NotNull
        protected Action[] createActions() {
            Action[] actions = new Action[this.myOptions.length];
            for (int i = 0; i < this.myOptions.length; ++i) {
                String option = this.myOptions[i];
                final int exitCode = i;
                actions[i] = new AbstractAction(UIUtil.replaceMnemonicAmpersand((String)option)){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MessageDialog.this.close(exitCode, true);
                    }
                };
                if (i == this.myDefaultOptionIndex) {
                    actions[i].putValue("DefaultAction", Boolean.TRUE);
                }
                if (i == this.myFocusedOptionIndex) {
                    actions[i].putValue("FocusedAction", Boolean.TRUE);
                }
                UIUtil.assignMnemonic((String)option, (Action)actions[i]);
            }
            if (actions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/Messages$MessageDialog", "createActions"));
            }
            return actions;
        }

        @Override
        public void doCancelAction() {
            this.close(-1);
        }

        @Override
        protected JComponent createCenterPanel() {
            return this.doCreateCenterPanel();
        }

        @Override
        @NotNull
        LayoutManager createRootLayout() {
            LayoutManager layoutManager;
            if (Messages.isMacSheetEmulation()) {
                this.myLayout = new MyBorderLayout();
                layoutManager = this.myLayout;
            } else {
                layoutManager = super.createRootLayout();
            }
            if (layoutManager == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/Messages$MessageDialog", "createRootLayout"));
            }
            return layoutManager;
        }

        @Override
        protected void dispose() {
            if (Messages.isMacSheetEmulation()) {
                this.animate();
            } else {
                super.dispose();
            }
        }

        @Override
        public void show() {
            if (Messages.isMacSheetEmulation()) {
                this.setInitialLocationCallback(new Computable<Point>(){

                    public Point compute() {
                        JRootPane rootPane = SwingUtilities.getRootPane(MessageDialog.this.getWindow().getParent());
                        if (rootPane == null) {
                            rootPane = SwingUtilities.getRootPane(MessageDialog.this.getWindow().getOwner());
                        }
                        Point p = rootPane.getLocationOnScreen();
                        p.x += (rootPane.getWidth() - MessageDialog.this.getWindow().getWidth()) / 2;
                        return p;
                    }
                });
                this.animate();
                if (SystemInfo.isJavaVersionAtLeast((String)"1.7")) {
                    try {
                        Method method = Class.forName("java.awt.Window").getDeclaredMethod("setOpacity", Float.TYPE);
                        if (method != null) {
                            method.invoke((Object)this.getPeer().getWindow(), Float.valueOf(0.8f));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.setAutoAdjustable(false);
                this.setSize(this.getPreferredSize().width, 0);
            }
            super.show();
        }

        private void animate() {
            final int height = this.getPreferredSize().height;
            int frameCount = 10;
            final boolean toClose = this.isShowing();
            final AtomicInteger i = new AtomicInteger(-1);
            final Alarm animator = new Alarm(this.myDisposable);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    int state = i.addAndGet(1);
                    double linearProgress = (double)state / 10.0;
                    if (toClose) {
                        linearProgress = 1.0 - linearProgress;
                    }
                    MessageDialog.this.myLayout.myPhase = (1.0 - Math.cos(Math.PI * linearProgress)) / 2.0;
                    Window window = MessageDialog.this.getPeer().getWindow();
                    Rectangle bounds = window.getBounds();
                    bounds.height = (int)((double)height * MessageDialog.this.myLayout.myPhase);
                    window.setBounds(bounds);
                    if (state == 0 && !toClose && window.getOwner() instanceof IdeFrame) {
                        WindowManager.getInstance().requestUserAttention((IdeFrame)((Object)window.getOwner()), true);
                    }
                    if (state < 10) {
                        animator.addRequest((Runnable)this, 10);
                    } else if (toClose) {
                        MessageDialog.super.dispose();
                    }
                }
            };
            animator.addRequest(runnable, 10, ModalityState.stateForComponent(this.getRootPane()));
        }

        protected JComponent doCreateCenterPanel() {
            JPanel panel = new JPanel(new BorderLayout(15, 0));
            if (this.myIcon != null) {
                JLabel iconLabel = new JLabel(this.myIcon);
                Container container = new Container();
                container.setLayout(new BorderLayout());
                container.add((Component)iconLabel, "North");
                panel.add((Component)container, "West");
            }
            if (this.myMessage != null) {
                JTextPane messageComponent = MessageDialog.createMessageComponent(this.myMessage);
                panel.add((Component)Messages.wrapToScrollPaneIfNeeded(messageComponent, 50, 10), "Center");
            }
            return panel;
        }

        protected static JTextPane createMessageComponent(String message) {
            JTextPane messageComponent = new JTextPane();
            return Messages.configureMessagePaneUi(messageComponent, message);
        }

        @Override
        protected void doHelpAction() {
        }
    }

    private static class MoreInfoMessageDialog
    extends MessageDialog {
        @Nullable
        private final String myInfoText;

        public MoreInfoMessageDialog(Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable String moreInfo, @NotNull String[] options, int defaultOptionIndex, int focusedOptionIndex, Icon icon) {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/openapi/ui/Messages$MoreInfoMessageDialog", "<init>"));
            }
            super(project);
            this.myInfoText = moreInfo;
            this._init(title, message, options, defaultOptionIndex, focusedOptionIndex, icon, null);
        }

        @Override
        protected JComponent createNorthPanel() {
            return this.doCreateCenterPanel();
        }

        @Override
        protected JComponent createCenterPanel() {
            if (this.myInfoText == null) {
                return null;
            }
            JPanel panel = new JPanel(new BorderLayout());
            JTextArea area = new JTextArea(this.myInfoText);
            area.setEditable(false);
            JBScrollPane scrollPane = new JBScrollPane(area){

                @Override
                public Dimension getPreferredSize() {
                    Dimension preferredSize = super.getPreferredSize();
                    Container parent = this.getParent();
                    if (parent != null) {
                        return new Dimension(preferredSize.width, Math.min(150, preferredSize.height));
                    }
                    return preferredSize;
                }
            };
            panel.add(scrollPane);
            return panel;
        }
    }

    public static @interface YesNoCancelResult {
    }

    public static @interface OkCancelResult {
    }

    public static @interface YesNoResult {
    }
}

