/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractNamedData;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.Identifiable;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleData
extends AbstractNamedData
implements Named,
ExternalConfigPathAware,
Identifiable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final Map<ExternalSystemSourceType, String> myCompileOutputPaths;
    @NotNull
    private final String myId;
    @NotNull
    private final String myModuleTypeId;
    @NotNull
    private final String myExternalConfigPath;
    @NotNull
    private String myModuleFilePath;
    @Nullable
    private String group;
    @Nullable
    private String version;
    @Nullable
    private String description;
    @NotNull
    private List<File> myArtifacts;
    private boolean myInheritProjectCompileOutputPath;

    @Deprecated
    public ModuleData(@NotNull ProjectSystemId owner, @NotNull String typeId, @NotNull String name, @NotNull String moduleFileDirectoryPath, @NotNull String externalConfigPath) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/openapi/externalSystem/model/project/ModuleData", "<init>"));
        }
        if (typeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeId", "com/intellij/openapi/externalSystem/model/project/ModuleData", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/externalSystem/model/project/ModuleData", "<init>"));
        }
        if (moduleFileDirectoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleFileDirectoryPath", "com/intellij/openapi/externalSystem/model/project/ModuleData", "<init>"));
        }
        if (externalConfigPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalConfigPath", "com/intellij/openapi/externalSystem/model/project/ModuleData", "<init>"));
        }
        this("", owner, typeId, name, moduleFileDirectoryPath, externalConfigPath);
    }

    public ModuleData(@NotNull String id, @NotNull ProjectSystemId owner, @NotNull String typeId, @NotNull String name, @NotNull String moduleFileDirectoryPath, @NotNull String externalConfigPath) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/model/project/ModuleData", "<init>"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/openapi/externalSystem/model/project/ModuleData", "<init>"));
        }
        if (typeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeId", "com/intellij/openapi/externalSystem/model/project/ModuleData", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/externalSystem/model/project/ModuleData", "<init>"));
        }
        if (moduleFileDirectoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleFileDirectoryPath", "com/intellij/openapi/externalSystem/model/project/ModuleData", "<init>"));
        }
        if (externalConfigPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalConfigPath", "com/intellij/openapi/externalSystem/model/project/ModuleData", "<init>"));
        }
        super(owner, name, name.replaceAll("(/|\\\\)", "_"));
        this.myCompileOutputPaths = ContainerUtil.newHashMap();
        this.myInheritProjectCompileOutputPath = true;
        this.myId = id;
        this.myModuleTypeId = typeId;
        this.myExternalConfigPath = externalConfigPath;
        this.myArtifacts = Collections.emptyList();
        this.setModuleFileDirectoryPath(moduleFileDirectoryPath);
    }

    @Override
    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/project/ModuleData", "getId"));
        }
        return string;
    }

    @NotNull
    public String getModuleTypeId() {
        String string = this.myModuleTypeId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/project/ModuleData", "getModuleTypeId"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getLinkedExternalProjectPath() {
        String string = this.myExternalConfigPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/project/ModuleData", "getLinkedExternalProjectPath"));
        }
        return string;
    }

    @NotNull
    public String getModuleFilePath() {
        String string = this.myModuleFilePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/project/ModuleData", "getModuleFilePath"));
        }
        return string;
    }

    public void setModuleFileDirectoryPath(@NotNull String path2) {
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/externalSystem/model/project/ModuleData", "setModuleFileDirectoryPath"));
        }
        this.myModuleFilePath = ExternalSystemApiUtil.toCanonicalPath(path2 + "/" + this.getInternalName() + ".iml");
    }

    public boolean isInheritProjectCompileOutputPath() {
        return this.myInheritProjectCompileOutputPath;
    }

    public void setInheritProjectCompileOutputPath(boolean inheritProjectCompileOutputPath) {
        this.myInheritProjectCompileOutputPath = inheritProjectCompileOutputPath;
    }

    @Nullable
    public String getCompileOutputPath(@NotNull ExternalSystemSourceType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/externalSystem/model/project/ModuleData", "getCompileOutputPath"));
        }
        return this.myCompileOutputPaths.get(type);
    }

    public void setCompileOutputPath(@NotNull ExternalSystemSourceType type, @Nullable String path2) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/externalSystem/model/project/ModuleData", "setCompileOutputPath"));
        }
        if (path2 == null) {
            this.myCompileOutputPaths.remove(type);
            return;
        }
        this.myCompileOutputPaths.put(type, ExternalSystemApiUtil.toCanonicalPath(path2));
    }

    @Nullable
    public String getGroup() {
        return this.group;
    }

    public void setGroup(@Nullable String group) {
        this.group = group;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    public void setVersion(@Nullable String version) {
        this.version = version;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @NotNull
    public List<File> getArtifacts() {
        List<File> list = this.myArtifacts;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/project/ModuleData", "getArtifacts"));
        }
        return list;
    }

    public void setArtifacts(@NotNull List<File> artifacts) {
        if (artifacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "com/intellij/openapi/externalSystem/model/project/ModuleData", "setArtifacts"));
        }
        this.myArtifacts = artifacts;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ModuleData)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModuleData that = (ModuleData)o;
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        if (!this.myModuleTypeId.equals(that.myModuleTypeId)) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        return !(this.description != null ? !this.description.equals(that.description) : that.description != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myModuleTypeId.hashCode();
        result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("module '%s:%s:%s'", this.group == null ? "" : this.group, this.getExternalName(), this.version == null ? "" : this.version);
    }
}

