/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.ui.UIUtil;
import java.awt.RenderingHints;
import sun.swing.SwingUtilities2;

public enum AntialiasingType {
    SUBPIXEL,
    GREYSCALE,
    OFF;

    private static final SwingUtilities2.AATextInfo aaDisabled;

    private static SwingUtilities2.AATextInfo getLCDEnabledTextInfo() {
        return new SwingUtilities2.AATextInfo(RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB, Integer.valueOf(UIUtil.getLcdContrastValue()));
    }

    private static SwingUtilities2.AATextInfo getAAEnabledTextInfo() {
        return new SwingUtilities2.AATextInfo(RenderingHints.VALUE_TEXT_ANTIALIAS_ON, Integer.valueOf(UIUtil.getLcdContrastValue()));
    }

    public static Object getAAHintForSwingComponent() {
        if (ApplicationManager.getApplication() == null) {
            return AntialiasingType.getAAEnabledTextInfo();
        }
        UISettings uiSettings = UISettings.getInstance();
        switch (uiSettings.IDE_AA_TYPE) {
            case SUBPIXEL: {
                return AntialiasingType.getLCDEnabledTextInfo();
            }
            case GREYSCALE: {
                return AntialiasingType.getAAEnabledTextInfo();
            }
            case OFF: {
                return aaDisabled;
            }
        }
        return AntialiasingType.getAAEnabledTextInfo();
    }

    public Object getRenderingHintValue() {
        Object value = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB;
        switch (this) {
            case SUBPIXEL: {
                break;
            }
            case GREYSCALE: {
                value = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
                break;
            }
            case OFF: {
                value = RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
            }
        }
        return value;
    }

    public static Object getKeyForCurrentScope(boolean inEditor) {
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings == null) {
            return RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
        }
        return inEditor ? uiSettings.EDITOR_AA_TYPE.getRenderingHintValue() : uiSettings.IDE_AA_TYPE.getRenderingHintValue();
    }

    public String toString() {
        String description;
        switch (this) {
            case SUBPIXEL: {
                description = "Subpixel";
                break;
            }
            case GREYSCALE: {
                description = "Greyscale";
                break;
            }
            case OFF: {
                description = "No antialiasing";
                break;
            }
            default: {
                description = "Subpixel";
            }
        }
        return description;
    }

    static {
        aaDisabled = null;
    }
}

