/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.presentation;

import com.intellij.ide.TypePresentationService;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class VirtualFilePresentation {
    public static Icon getIcon(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/ide/presentation/VirtualFilePresentation", "getIcon"));
        }
        return IconUtil.getIcon(vFile, 0, null);
    }

    public static Icon getIconImpl(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/ide/presentation/VirtualFilePresentation", "getIconImpl"));
        }
        Icon icon = TypePresentationService.getService().getIcon(vFile);
        if (icon != null) {
            return icon;
        }
        if (vFile.isDirectory() && vFile.isInLocalFileSystem()) {
            return PlatformIcons.FOLDER_ICON;
        }
        return vFile.getFileType().getIcon();
    }
}

