/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.testframework.PoolOfTestIcons;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class TestIconMapper
implements PoolOfTestIcons {
    private static final Map<Integer, TestStateInfo.Magnitude> magnitudes = new HashMap<Integer, TestStateInfo.Magnitude>();

    public static TestStateInfo.Magnitude getMagnitude(int value) {
        return magnitudes.get(value);
    }

    @Nullable
    public static Icon getIcon(TestStateInfo.Magnitude magnitude) {
        switch (magnitude) {
            case SKIPPED_INDEX: {
                return SKIPPED_ICON;
            }
            case COMPLETE_INDEX: {
                return PASSED_ICON;
            }
            case NOT_RUN_INDEX: {
                return NOT_RAN;
            }
            case RUNNING_INDEX: {
                return null;
            }
            case TERMINATED_INDEX: {
                return TERMINATED_ICON;
            }
            case IGNORED_INDEX: {
                return IGNORED_ICON;
            }
            case FAILED_INDEX: {
                return FAILED_ICON;
            }
            case ERROR_INDEX: {
                return ERROR_ICON;
            }
            case PASSED_INDEX: {
                return PASSED_ICON;
            }
        }
        return null;
    }

    static {
        for (TestStateInfo.Magnitude value : TestStateInfo.Magnitude.values()) {
            magnitudes.put(value.getValue(), value);
        }
    }
}

