/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.StatusBar;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ProcessTerminatedListener
extends ProcessAdapter {
    @NonNls
    protected static final String EXIT_CODE_ENTRY = "$EXIT_CODE$";
    @NonNls
    protected static final String EXIT_CODE_REGEX = "\\$EXIT_CODE\\$";
    private static final Key<ProcessTerminatedListener> KEY = new Key("processTerminatedListener");
    private final String myProcessFinishedMessage;
    private final Project myProject;

    private ProcessTerminatedListener(Project project, String processFinishedMessage) {
        this.myProject = project;
        this.myProcessFinishedMessage = processFinishedMessage;
    }

    public static void attach(ProcessHandler processHandler, Project project, String message) {
        ProcessTerminatedListener previousListener = (ProcessTerminatedListener)((Object)processHandler.getUserData(KEY));
        if (previousListener != null) {
            processHandler.removeProcessListener((ProcessListener)previousListener);
            if (project == null) {
                project = previousListener.myProject;
            }
        }
        ProcessTerminatedListener listener = new ProcessTerminatedListener(project, message);
        processHandler.addProcessListener((ProcessListener)listener);
        processHandler.putUserData(KEY, (Object)listener);
    }

    public static void attach(ProcessHandler processHandler, Project project) {
        String message = IdeBundle.message("finished.with.exit.code.text.message", EXIT_CODE_ENTRY);
        ProcessTerminatedListener.attach(processHandler, project, "\n" + message + "\n");
    }

    public static void attach(ProcessHandler processHandler) {
        ProcessTerminatedListener.attach(processHandler, null);
    }

    public void processTerminated(ProcessEvent event) {
        ProcessHandler processHandler = event.getProcessHandler();
        processHandler.removeProcessListener((ProcessListener)this);
        final String message = this.myProcessFinishedMessage.replaceAll(EXIT_CODE_REGEX, ProcessTerminatedListener.stringifyExitCode(event.getExitCode()));
        processHandler.notifyTextAvailable(message, ProcessOutputTypes.SYSTEM);
        if (this.myProject != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ProcessTerminatedListener.this.myProject.isDisposed()) {
                        return;
                    }
                    StatusBar.Info.set(message, ProcessTerminatedListener.this.myProject);
                }
            });
        }
    }

    @NotNull
    private static String stringifyExitCode(int exitCode) {
        if (SystemInfo.isWindows && exitCode >= -1073741824 && exitCode < -805306368) {
            StringBuilder result = new StringBuilder();
            result.append(exitCode);
            result.append(" (0x").append(Integer.toHexString(exitCode).toUpperCase(Locale.ENGLISH));
            if (exitCode == -1073741510) {
                result.append(": interrupted by Ctrl+C");
            }
            result.append(")");
            String string = result.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ProcessTerminatedListener", "stringifyExitCode"));
            }
            return string;
        }
        String string = String.valueOf(exitCode);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ProcessTerminatedListener", "stringifyExitCode"));
        }
        return string;
    }
}

