/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.FilterMixin;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeFilter
implements Filter,
FilterMixin {
    private static final Logger LOG = Logger.getInstance(CompositeFilter.class);
    private final List<Filter> myFilters;
    private boolean myIsAnyHeavy;
    private boolean forceUseAllFilters;
    private final DumbService myDumbService;

    public CompositeFilter(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/filters/CompositeFilter", "<init>"));
        }
        this.myFilters = new ArrayList<Filter>();
        this.forceUseAllFilters = false;
        this.myDumbService = DumbService.getInstance(project);
    }

    protected CompositeFilter(DumbService dumbService) {
        this.myFilters = new ArrayList<Filter>();
        this.forceUseAllFilters = false;
        this.myDumbService = dumbService;
    }

    @Override
    @Nullable
    public Filter.Result applyFilter(String line, int entireLength) {
        boolean dumb = this.myDumbService.isDumb();
        List<Filter> filters = this.myFilters;
        int count = filters.size();
        List<Filter.ResultItem> resultItems = null;
        for (int i = 0; i < count; ++i) {
            Filter.Result result;
            Filter filter = filters.get(i);
            if (dumb && !DumbService.isDumbAware(filter)) continue;
            long t0 = System.currentTimeMillis();
            try {
                result = filter.applyFilter(line, entireLength);
            }
            catch (Throwable t) {
                throw new RuntimeException("Error while applying " + filter + " to '" + line + "'", t);
            }
            resultItems = this.merge(resultItems, result);
            t0 = System.currentTimeMillis() - t0;
            if (t0 > 1000L) {
                LOG.warn(filter.getClass().getSimpleName() + ".applyFilter() took " + t0 + " ms on '''" + line + "'''");
            }
            if (this.shouldStopFiltering(result)) break;
        }
        return CompositeFilter.createFinalResult(resultItems);
    }

    @Nullable
    private static Filter.Result createFinalResult(@Nullable List<Filter.ResultItem> resultItems) {
        if (resultItems == null) {
            return null;
        }
        if (resultItems.size() == 1) {
            Filter.ResultItem resultItem = resultItems.get(0);
            return new Filter.Result(resultItem.getHighlightStartOffset(), resultItem.getHighlightEndOffset(), resultItem.getHyperlinkInfo(), resultItem.getHighlightAttributes(), resultItem.getFollowedHyperlinkAttributes());
        }
        return new Filter.Result(resultItems);
    }

    private boolean shouldStopFiltering(@Nullable Filter.Result result) {
        return result != null && result.getNextAction() == Filter.NextAction.EXIT && !this.forceUseAllFilters;
    }

    @Nullable
    protected List<Filter.ResultItem> merge(@Nullable List<Filter.ResultItem> resultItems, @Nullable Filter.Result newResult) {
        if (newResult != null) {
            if (resultItems == null) {
                resultItems = new ArrayList<Filter.ResultItem>();
            }
            List<Filter.ResultItem> newItems = newResult.getResultItems();
            for (int i = 0; i < newItems.size(); ++i) {
                Filter.ResultItem item = newItems.get(i);
                if (item.getHyperlinkInfo() != null && this.intersects(resultItems, item)) continue;
                resultItems.add(item);
            }
        }
        return resultItems;
    }

    protected boolean intersects(List<Filter.ResultItem> items, Filter.ResultItem newItem) {
        TextRange newItemTextRange = null;
        for (int i = 0; i < items.size(); ++i) {
            Filter.ResultItem item = items.get(i);
            if (item.getHyperlinkInfo() == null) continue;
            if (newItemTextRange == null) {
                newItemTextRange = new TextRange(newItem.highlightStartOffset, newItem.highlightEndOffset);
            }
            if (!newItemTextRange.intersectsStrict(item.highlightStartOffset, item.highlightEndOffset)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldRunHeavy() {
        for (Filter filter : this.myFilters) {
            if (!(filter instanceof FilterMixin) || !((FilterMixin)((Object)filter)).shouldRunHeavy()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void applyHeavyFilter(Document copiedFragment, int startOffset, int startLineNumber, Consumer<FilterMixin.AdditionalHighlight> consumer) {
        boolean dumb = this.myDumbService.isDumb();
        List<Filter> filters = this.myFilters;
        int count = filters.size();
        for (int i = 0; i < count; ++i) {
            Filter filter = filters.get(i);
            if (!(filter instanceof FilterMixin) || !((FilterMixin)((Object)filter)).shouldRunHeavy() || dumb && !DumbService.isDumbAware(filter)) continue;
            ((FilterMixin)((Object)filter)).applyHeavyFilter(copiedFragment, startOffset, startLineNumber, consumer);
        }
    }

    @Override
    public String getUpdateMessage() {
        boolean dumb = this.myDumbService.isDumb();
        List<Filter> filters = this.myFilters;
        ArrayList<String> updateMessage = new ArrayList<String>();
        int count = filters.size();
        for (int i = 0; i < count; ++i) {
            Filter filter = filters.get(i);
            if (!(filter instanceof FilterMixin) || !((FilterMixin)((Object)filter)).shouldRunHeavy() || dumb && !DumbService.isDumbAware(filter)) continue;
            updateMessage.add(((FilterMixin)((Object)filter)).getUpdateMessage());
        }
        return updateMessage.size() == 1 ? (String)updateMessage.get(0) : "Updating...";
    }

    public boolean isEmpty() {
        return this.myFilters.isEmpty();
    }

    public boolean isAnyHeavy() {
        return this.myIsAnyHeavy;
    }

    public void addFilter(Filter filter) {
        this.myFilters.add(filter);
        this.myIsAnyHeavy |= filter instanceof FilterMixin;
    }

    public void setForceUseAllFilters(boolean forceUseAllFilters) {
        this.forceUseAllFilters = forceUseAllFilters;
    }

    public String toString() {
        return "CompositeFilter: " + this.myFilters;
    }
}

