/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.ModuleRunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.xmlb.annotations.Property;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class ModuleBasedConfiguration<ConfigurationModule extends RunConfigurationModule>
extends LocatableConfigurationBase
implements Cloneable,
ModuleRunConfiguration {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.configurations.ModuleBasedConfiguration");
    @Property(surroundWithTag=false)
    private final ConfigurationModule myModule;
    @NonNls
    protected static final String TO_CLONE_ELEMENT_NAME = "toClone";

    public ModuleBasedConfiguration(String name, @NotNull ConfigurationModule configurationModule, @NotNull ConfigurationFactory factory) {
        if (configurationModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationModule", "com/intellij/execution/configurations/ModuleBasedConfiguration", "<init>"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/execution/configurations/ModuleBasedConfiguration", "<init>"));
        }
        super(((RunConfigurationModule)configurationModule).getProject(), factory, name);
        this.myModule = configurationModule;
    }

    public ModuleBasedConfiguration(ConfigurationModule configurationModule, ConfigurationFactory factory) {
        super(((RunConfigurationModule)configurationModule).getProject(), factory, "");
        this.myModule = configurationModule;
    }

    public abstract Collection<Module> getValidModules();

    public ConfigurationModule getConfigurationModule() {
        return this.myModule;
    }

    public void setModule(Module module) {
        ((RunConfigurationModule)this.myModule).setModule(module);
    }

    protected void readModule(Element element) throws InvalidDataException {
        ((RunConfigurationModule)this.myModule).readExternal(element);
    }

    protected void writeModule(Element element) throws WriteExternalException {
        ((RunConfigurationModule)this.myModule).writeExternal(element);
    }

    public Collection<Module> getAllModules() {
        return Arrays.asList(ModuleManager.getInstance(this.getProject()).getModules());
    }

    protected ModuleBasedConfiguration createInstance() {
        ModuleBasedConfiguration configuration = (ModuleBasedConfiguration)this.getFactory().createTemplateConfiguration(this.getProject());
        configuration.setName(this.getName());
        return configuration;
    }

    @Override
    public ModuleBasedConfiguration clone() {
        Element element = new Element(TO_CLONE_ELEMENT_NAME);
        try {
            this.writeExternal(element);
            ModuleBasedConfiguration configuration = this.createInstance();
            configuration.readExternal(element);
            return configuration;
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
            return null;
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Override
    @NotNull
    public Module[] getModules() {
        Module[] moduleArray = ApplicationManager.getApplication().runReadAction(new Computable<Module[]>(){

            public Module[] compute() {
                Module[] moduleArray;
                Module module = ((RunConfigurationModule)ModuleBasedConfiguration.this.getConfigurationModule()).getModule();
                if (module == null) {
                    moduleArray = Module.EMPTY_ARRAY;
                } else {
                    Module[] moduleArray2 = new Module[1];
                    moduleArray = moduleArray2;
                    moduleArray2[0] = module;
                }
                return moduleArray;
            }
        });
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/ModuleBasedConfiguration", "getModules"));
        }
        return moduleArray;
    }

    public void restoreOriginalModule(Module originalModule) {
        if (originalModule == null) {
            return;
        }
        Module[] classModules = this.getModules();
        HashSet<Module> modules = new HashSet<Module>();
        for (Module classModule : classModules) {
            ModuleUtilCore.collectModulesDependsOn(classModule, modules);
        }
        if (modules.contains(originalModule)) {
            this.setModule(originalModule);
        }
    }

    public void onNewConfigurationCreated() {
        ConfigurationModule configurationModule = this.getConfigurationModule();
        if (((RunConfigurationModule)configurationModule).getModule() == null) {
            Module[] modules = ModuleManager.getInstance(this.getProject()).getModules();
            ((RunConfigurationModule)configurationModule).setModule(modules.length == 1 ? modules[0] : null);
        }
    }
}

