/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.JavaDebugAware;
import com.intellij.debugger.engine.SimpleGetterProvider;
import com.intellij.debugger.engine.SimplePropertyGetterProvider;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SyntheticTypeComponentProvider;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.StringBuilderSpinAllocator;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerUtils {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.DebuggerUtils");
    private static final Key<Method> TO_STRING_METHOD_KEY = new Key("CachedToStringMethod");
    public static final Set<String> ourPrimitiveTypeNames = new HashSet<String>(Arrays.asList("byte", "short", "int", "long", "float", "double", "boolean", "char"));
    public static final int MAX_DISPLAY_LABEL_LENGTH = 5120;

    public static void cleanupAfterProcessFinish(DebugProcess debugProcess) {
        debugProcess.putUserData(TO_STRING_METHOD_KEY, null);
    }

    @NonNls
    public static String getValueAsString(EvaluationContext evaluationContext, Value value) throws EvaluateException {
        try {
            if (value == null) {
                return "null";
            }
            if (value instanceof StringReference) {
                return ((StringReference)value).value();
            }
            if (DebuggerUtils.isInteger(value)) {
                long v = ((PrimitiveValue)value).longValue();
                return String.valueOf(v);
            }
            if (DebuggerUtils.isNumeric(value)) {
                double v = ((PrimitiveValue)value).doubleValue();
                return String.valueOf(v);
            }
            if (value instanceof BooleanValue) {
                boolean v = ((PrimitiveValue)value).booleanValue();
                return String.valueOf(v);
            }
            if (value instanceof CharValue) {
                char v = ((PrimitiveValue)value).charValue();
                return String.valueOf(v);
            }
            if (value instanceof ObjectReference) {
                if (value instanceof ArrayReference) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("[");
                    Iterator<Value> iterator = ((ArrayReference)value).getValues().iterator();
                    while (iterator.hasNext()) {
                        Value element = iterator.next();
                        builder.append(DebuggerUtils.getValueAsString(evaluationContext, element));
                        if (!iterator.hasNext()) continue;
                        builder.append(",");
                    }
                    builder.append("]");
                    return builder.toString();
                }
                ObjectReference objRef = (ObjectReference)value;
                DebugProcess debugProcess = evaluationContext.getDebugProcess();
                Method toStringMethod = debugProcess.getUserData(TO_STRING_METHOD_KEY);
                if (toStringMethod == null) {
                    try {
                        ReferenceType refType = objRef.virtualMachine().classesByName("java.lang.Object").get(0);
                        toStringMethod = DebuggerUtils.findMethod(refType, "toString", "()Ljava/lang/String;");
                        debugProcess.putUserData(TO_STRING_METHOD_KEY, toStringMethod);
                    }
                    catch (Exception ignored) {
                        throw EvaluateExceptionUtil.createEvaluateException(DebuggerBundle.message("evaluation.error.cannot.evaluate.tostring", objRef.referenceType().name()));
                    }
                }
                if (toStringMethod == null) {
                    throw EvaluateExceptionUtil.createEvaluateException(DebuggerBundle.message("evaluation.error.cannot.evaluate.tostring", objRef.referenceType().name()));
                }
                Value result = debugProcess.invokeInstanceMethod(evaluationContext, objRef, toStringMethod, Collections.emptyList(), 0);
                if (result == null) {
                    return "null";
                }
                return result instanceof StringReference ? ((StringReference)result).value() : result.toString();
            }
            throw EvaluateExceptionUtil.createEvaluateException(DebuggerBundle.message("evaluation.error.unsupported.expression.type", new Object[0]));
        }
        catch (ObjectCollectedException ignored) {
            throw EvaluateExceptionUtil.OBJECT_WAS_COLLECTED;
        }
    }

    public static String convertToPresentationString(String str) {
        if (str.length() > 5120) {
            str = DebuggerUtils.translateStringValue(str.substring(0, 5120));
            StringBuilder buf = new StringBuilder();
            buf.append(str);
            if (!str.endsWith("...")) {
                buf.append("...");
            }
            return buf.toString();
        }
        return DebuggerUtils.translateStringValue(str);
    }

    @Nullable
    public static Method findMethod(@NotNull ReferenceType refType, @NonNls String methodName, @NonNls String methodSignature) {
        Method method;
        if (refType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refType", "com/intellij/debugger/engine/DebuggerUtils", "findMethod"));
        }
        if (refType instanceof ArrayType && (method = DebuggerUtils.findMethod(refType.virtualMachine().classesByName("java.lang.Object").get(0), methodName, methodSignature)) != null) {
            return method;
        }
        method = null;
        if (methodSignature != null) {
            List<Method> methods;
            if (refType instanceof ClassType) {
                method = ((ClassType)refType).concreteMethodByName(methodName, methodSignature);
            }
            if (method == null && (methods = refType.methodsByName(methodName, methodSignature)).size() > 0) {
                method = methods.get(0);
            }
        } else {
            List<Method> methods = null;
            if (refType instanceof ClassType) {
                methods = refType.methodsByName(methodName);
            }
            if (methods != null && methods.size() > 0) {
                method = methods.get(0);
            }
        }
        return method;
    }

    public static boolean isNumeric(Value value) {
        return value != null && (DebuggerUtils.isInteger(value) || value instanceof FloatValue || value instanceof DoubleValue);
    }

    public static boolean isInteger(Value value) {
        return value != null && (value instanceof ByteValue || value instanceof ShortValue || value instanceof LongValue || value instanceof IntegerValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String translateStringValue(String str) {
        int length = str.length();
        StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        try {
            StringUtil.escapeStringCharacters((int)length, (String)str, (StringBuilder)buffer);
            if (str.length() > length) {
                buffer.append("...");
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buffer);
        }
    }

    @Nullable
    protected static ArrayClass getArrayClass(@NotNull String className) {
        int pos;
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/debugger/engine/DebuggerUtils", "getArrayClass"));
        }
        boolean searchBracket = false;
        int dims = 0;
        for (pos = className.lastIndexOf(93); pos >= 0; --pos) {
            char c = className.charAt(pos);
            if (searchBracket) {
                if (c == '[') {
                    ++dims;
                    searchBracket = false;
                    continue;
                }
                if (Character.isWhitespace(c)) continue;
                break;
            }
            if (c == ']') {
                searchBracket = true;
                continue;
            }
            if (!Character.isWhitespace(c)) break;
        }
        if (searchBracket) {
            return null;
        }
        if (dims == 0) {
            return null;
        }
        return new ArrayClass(className.substring(0, pos + 1), dims);
    }

    public static boolean instanceOf(@NotNull String subType, @NotNull String superType, @Nullable Project project) {
        if (subType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subType", "com/intellij/debugger/engine/DebuggerUtils", "instanceOf"));
        }
        if (superType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superType", "com/intellij/debugger/engine/DebuggerUtils", "instanceOf"));
        }
        if (project == null) {
            return subType.equals(superType);
        }
        ArrayClass nodeClass = DebuggerUtils.getArrayClass(subType);
        ArrayClass rendererClass = DebuggerUtils.getArrayClass(superType);
        if (nodeClass == null || rendererClass == null) {
            return false;
        }
        if (nodeClass.dims == rendererClass.dims) {
            GlobalSearchScope scope = GlobalSearchScope.allScope(project);
            PsiClass psiNodeClass = JavaPsiFacade.getInstance(project).findClass(nodeClass.className, scope);
            PsiClass psiRendererClass = JavaPsiFacade.getInstance(project).findClass(rendererClass.className, scope);
            return InheritanceUtil.isInheritorOrSelf(psiNodeClass, psiRendererClass, true);
        }
        if (nodeClass.dims > rendererClass.dims) {
            return rendererClass.className.equals("java.lang.Object");
        }
        return false;
    }

    @Nullable
    public static Type getSuperType(@Nullable Type subType, @NotNull String superType) {
        if (superType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superType", "com/intellij/debugger/engine/DebuggerUtils", "getSuperType"));
        }
        if (subType == null) {
            return null;
        }
        if ("java.lang.Object".equals(superType)) {
            List<ReferenceType> list = subType.virtualMachine().classesByName("java.lang.Object");
            if (list.size() > 0) {
                return list.get(0);
            }
            return null;
        }
        return DebuggerUtils.getSuperTypeInt(subType, superType);
    }

    private static boolean typeEquals(@NotNull Type type, @NotNull String typeName) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/debugger/engine/DebuggerUtils", "typeEquals"));
        }
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/debugger/engine/DebuggerUtils", "typeEquals"));
        }
        int genericPos = typeName.indexOf(60);
        if (genericPos > -1) {
            typeName = typeName.substring(0, genericPos);
        }
        return type.name().replace('$', '.').equals(typeName.replace('$', '.'));
    }

    private static Type getSuperTypeInt(@NotNull Type subType, @NotNull String superType) {
        List<ReferenceType> list;
        if (subType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subType", "com/intellij/debugger/engine/DebuggerUtils", "getSuperTypeInt"));
        }
        if (superType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superType", "com/intellij/debugger/engine/DebuggerUtils", "getSuperTypeInt"));
        }
        if (DebuggerUtils.typeEquals(subType, superType)) {
            return subType;
        }
        if (subType instanceof ClassType) {
            try {
                ClassType clsType = (ClassType)subType;
                Type result = DebuggerUtils.getSuperType(clsType.superclass(), superType);
                if (result != null) {
                    return result;
                }
                for (InterfaceType iface : clsType.allInterfaces()) {
                    if (!DebuggerUtils.typeEquals(iface, superType)) continue;
                    return iface;
                }
            }
            catch (ClassNotPreparedException e) {
                LOG.info((Throwable)e);
            }
            return null;
        }
        if (subType instanceof InterfaceType) {
            try {
                for (InterfaceType iface : ((InterfaceType)subType).superinterfaces()) {
                    Type result = DebuggerUtils.getSuperType(iface, superType);
                    if (result == null) continue;
                    return result;
                }
            }
            catch (ClassNotPreparedException e) {
                LOG.info((Throwable)e);
            }
        } else if (subType instanceof ArrayType) {
            if (superType.endsWith("[]")) {
                try {
                    String superTypeItem = superType.substring(0, superType.length() - 2);
                    Type subTypeItem = ((ArrayType)subType).componentType();
                    return DebuggerUtils.instanceOf(subTypeItem, superTypeItem) ? subType : null;
                }
                catch (ClassNotLoadedException e) {
                    LOG.info((Throwable)e);
                }
            }
        } else if (subType instanceof PrimitiveType && superType.equals("java.lang.Primitive")) {
            return subType;
        }
        if ("java.lang.Object".equals(superType) && (list = subType.virtualMachine().classesByName("java.lang.Object")).size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public static boolean instanceOf(@Nullable Type subType, @NotNull String superType) {
        if (superType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superType", "com/intellij/debugger/engine/DebuggerUtils", "instanceOf"));
        }
        return DebuggerUtils.getSuperType(subType, superType) != null;
    }

    @Nullable
    public static PsiClass findClass(@NotNull String className, @NotNull Project project, GlobalSearchScope scope) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/debugger/engine/DebuggerUtils", "findClass"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/engine/DebuggerUtils", "findClass"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        try {
            GlobalSearchScope globalScope;
            if (DebuggerUtils.getArrayClass(className) != null) {
                return JavaPsiFacade.getInstance(project).getElementFactory().getArrayClass(LanguageLevelProjectExtension.getInstance(project).getLanguageLevel());
            }
            if (project.isDefault()) {
                return null;
            }
            PsiManager psiManager = PsiManager.getInstance(project);
            PsiClass psiClass = ClassUtil.findPsiClass(psiManager, className, null, true, scope);
            if (psiClass == null && !(globalScope = GlobalSearchScope.allScope(project)).equals(scope)) {
                psiClass = ClassUtil.findPsiClass(psiManager, className, null, true, globalScope);
            }
            return psiClass;
        }
        catch (IndexNotReadyException ignored) {
            return null;
        }
    }

    @Nullable
    public static PsiType getType(@NotNull String className, @NotNull Project project) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/debugger/engine/DebuggerUtils", "getType"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/engine/DebuggerUtils", "getType"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiManager psiManager = PsiManager.getInstance(project);
        try {
            if (DebuggerUtils.getArrayClass(className) != null) {
                return JavaPsiFacade.getInstance(psiManager.getProject()).getElementFactory().createTypeFromText(className, null);
            }
            if (project.isDefault()) {
                return null;
            }
            PsiClass aClass = JavaPsiFacade.getInstance(psiManager.getProject()).findClass(className.replace('$', '.'), GlobalSearchScope.allScope(project));
            if (aClass != null) {
                return JavaPsiFacade.getInstance(psiManager.getProject()).getElementFactory().createType(aClass);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    public static void checkSyntax(PsiCodeFragment codeFragment) throws EvaluateException {
        PsiElement[] children = codeFragment.getChildren();
        if (children.length == 0) {
            throw EvaluateExceptionUtil.createEvaluateException(DebuggerBundle.message("evaluation.error.empty.code.fragment", new Object[0]));
        }
        for (PsiElement child : children) {
            if (!(child instanceof PsiErrorElement)) continue;
            throw EvaluateExceptionUtil.createEvaluateException(DebuggerBundle.message("evaluation.error.invalid.expression", child.getText()));
        }
    }

    public static boolean hasSideEffects(PsiElement element) {
        return DebuggerUtils.hasSideEffectsOrReferencesMissingVars(element, null);
    }

    public static boolean hasSideEffectsOrReferencesMissingVars(PsiElement element, final @Nullable Set<String> visibleLocalVariables) {
        final Ref rv = new Ref((Object)Boolean.FALSE);
        element.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitPostfixExpression(PsiPostfixExpression expression) {
                rv.set((Object)Boolean.TRUE);
            }

            @Override
            public void visitReferenceExpression(PsiReferenceExpression expression) {
                PsiElement psiElement = expression.resolve();
                if (psiElement instanceof PsiLocalVariable) {
                    if (visibleLocalVariables != null && !visibleLocalVariables.contains(((PsiLocalVariable)psiElement).getName())) {
                        rv.set((Object)Boolean.TRUE);
                    }
                } else if (psiElement instanceof PsiMethod) {
                    rv.set((Object)Boolean.TRUE);
                }
                if (!((Boolean)rv.get()).booleanValue()) {
                    super.visitReferenceExpression(expression);
                }
            }

            @Override
            public void visitPrefixExpression(PsiPrefixExpression expression) {
                IElementType op = expression.getOperationTokenType();
                if (JavaTokenType.PLUSPLUS.equals(op) || JavaTokenType.MINUSMINUS.equals(op)) {
                    rv.set((Object)Boolean.TRUE);
                } else {
                    super.visitPrefixExpression(expression);
                }
            }

            @Override
            public void visitAssignmentExpression(PsiAssignmentExpression expression) {
                rv.set((Object)Boolean.TRUE);
            }

            @Override
            public void visitCallExpression(PsiCallExpression callExpression) {
                rv.set((Object)Boolean.TRUE);
            }
        });
        return (Boolean)rv.get();
    }

    public abstract String findAvailableDebugAddress(boolean var1) throws ExecutionException;

    public static boolean isSynthetic(TypeComponent typeComponent) {
        if (typeComponent == null) {
            return false;
        }
        for (SyntheticTypeComponentProvider provider : (SyntheticTypeComponentProvider[])SyntheticTypeComponentProvider.EP_NAME.getExtensions()) {
            if (!provider.isSynthetic(typeComponent)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean isSimpleGetter(PsiMethod method) {
        for (SimpleGetterProvider provider : (SimpleGetterProvider[])SimpleGetterProvider.EP_NAME.getExtensions()) {
            if (!provider.isSimpleGetter(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInsideSimpleGetter(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/debugger/engine/DebuggerUtils", "isInsideSimpleGetter"));
        }
        for (SimpleGetterProvider simpleGetterProvider : (SimpleGetterProvider[])SimpleGetterProvider.EP_NAME.getExtensions()) {
            PsiMethod psiMethod = PsiTreeUtil.getParentOfType(contextElement, PsiMethod.class);
            if (psiMethod == null || !simpleGetterProvider.isSimpleGetter(psiMethod)) continue;
            return true;
        }
        for (SimplePropertyGetterProvider simplePropertyGetterProvider : (SimplePropertyGetterProvider[])SimplePropertyGetterProvider.EP_NAME.getExtensions()) {
            if (!simplePropertyGetterProvider.isInsideSimpleGetter(contextElement)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimitiveType(String typeName) {
        return ourPrimitiveTypeNames.contains(typeName);
    }

    public static DebuggerUtils getInstance() {
        return ServiceManager.getService(DebuggerUtils.class);
    }

    public abstract PsiExpression substituteThis(PsiExpression var1, PsiExpression var2, Value var3, StackFrameContext var4) throws EvaluateException;

    public abstract DebuggerContext getDebuggerContext(DataContext var1);

    public abstract Element writeTextWithImports(TextWithImports var1);

    public abstract TextWithImports readTextWithImports(Element var1);

    public abstract void writeTextWithImports(Element var1, @NonNls String var2, TextWithImports var3);

    public abstract TextWithImports readTextWithImports(Element var1, @NonNls String var2);

    public abstract TextWithImports createExpressionWithImports(@NonNls String var1);

    public abstract PsiElement getContextElement(StackFrameContext var1);

    public abstract PsiClass chooseClassDialog(String var1, Project var2);

    public static boolean isDebugActionAware(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/debugger/engine/DebuggerUtils", "isDebugActionAware"));
        }
        return DebuggerUtils.isDebugAware(file, false);
    }

    public static boolean isBreakpointAware(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/debugger/engine/DebuggerUtils", "isBreakpointAware"));
        }
        return DebuggerUtils.isDebugAware(file, true);
    }

    private static boolean isDebugAware(@NotNull PsiFile file, boolean breakpointAware) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/debugger/engine/DebuggerUtils", "isDebugAware"));
        }
        FileType fileType = file.getFileType();
        if (fileType instanceof LanguageFileType && ((LanguageFileType)fileType).isJVMDebuggingSupported()) {
            return true;
        }
        for (JavaDebugAware provider : (JavaDebugAware[])JavaDebugAware.EP_NAME.getExtensions()) {
            if (!(breakpointAware ? provider.isBreakpointAware(file) : provider.isActionAware(file))) continue;
            return true;
        }
        return false;
    }

    protected static class ArrayClass {
        public String className;
        public int dims;

        public ArrayClass(String className, int dims) {
            this.className = className;
            this.dims = dims;
        }
    }
}

