/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionConfidence;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;

public class SkipAutopopupInStrings
extends CompletionConfidence {
    @Override
    @NotNull
    public ThreeState shouldFocusLookup(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/SkipAutopopupInStrings", "shouldFocusLookup"));
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/SkipAutopopupInStrings", "shouldFocusLookup"));
        }
        return threeState;
    }

    @Override
    @NotNull
    public ThreeState shouldSkipAutopopup(@NotNull PsiElement contextElement, @NotNull PsiFile psiFile, int offset) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/codeInsight/completion/SkipAutopopupInStrings", "shouldSkipAutopopup"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/completion/SkipAutopopupInStrings", "shouldSkipAutopopup"));
        }
        if (SkipAutopopupInStrings.isInStringLiteral(contextElement)) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/SkipAutopopupInStrings", "shouldSkipAutopopup"));
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/SkipAutopopupInStrings", "shouldSkipAutopopup"));
        }
        return threeState;
    }

    public static boolean isInStringLiteral(PsiElement element) {
        ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(PsiUtilCore.findLanguageFromElement(element));
        if (definition == null) {
            return false;
        }
        return SkipAutopopupInStrings.isStringLiteral(element, definition) || SkipAutopopupInStrings.isStringLiteral(element.getParent(), definition) || SkipAutopopupInStrings.isStringLiteralWithError(element, definition) || SkipAutopopupInStrings.isStringLiteralWithError(element.getParent(), definition);
    }

    private static boolean isStringLiteral(PsiElement element, ParserDefinition definition) {
        return ((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(definition.getStringLiteralElements())).accepts(element);
    }

    private static boolean isStringLiteralWithError(PsiElement element, ParserDefinition definition) {
        return SkipAutopopupInStrings.isStringLiteral(element, definition) && PsiTreeUtil.nextLeaf(element) instanceof PsiErrorElement;
    }
}

