/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OffsetMap
implements Disposable {
    private final Document myDocument;
    private final Map<OffsetKey, RangeMarker> myMap = new THashMap();
    private final Set<OffsetKey> myModified = new THashSet();
    private volatile boolean myDisposed;

    public OffsetMap(Document document) {
        this.myDocument = document;
    }

    public int getOffset(OffsetKey key) {
        RangeMarker marker = this.myMap.get(key);
        if (marker == null) {
            return -1;
        }
        if (!marker.isValid()) {
            this.removeOffset(key);
            return -1;
        }
        int endOffset = marker.getEndOffset();
        if (marker.getStartOffset() != endOffset) {
            this.saveOffset(key, endOffset, false);
        }
        return endOffset;
    }

    public void addOffset(OffsetKey key, int offset) {
        if (offset < 0) {
            this.removeOffset(key);
            return;
        }
        this.saveOffset(key, offset, true);
    }

    private void saveOffset(OffsetKey key, int offset, boolean externally) {
        RangeMarker old;
        assert (!this.myDisposed);
        if (externally && this.myMap.containsKey(key)) {
            this.myModified.add(key);
        }
        if ((old = this.myMap.get(key)) != null) {
            old.dispose();
        }
        RangeMarker marker = this.myDocument.createRangeMarker(offset, offset);
        marker.setGreedyToRight(key.isMoveableToRight());
        this.myMap.put(key, marker);
    }

    public void removeOffset(OffsetKey key) {
        assert (!this.myDisposed);
        this.myModified.add(key);
        RangeMarker old = this.myMap.get(key);
        if (old != null) {
            old.dispose();
        }
        this.myMap.remove(key);
    }

    public List<OffsetKey> getAllOffsets() {
        assert (!this.myDisposed);
        return new ArrayList<OffsetKey>(this.myMap.keySet());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("OffsetMap:");
        for (OffsetKey key : this.myMap.keySet()) {
            builder.append(key).append("->").append(this.myMap.get(key)).append(";");
        }
        return builder.toString();
    }

    public boolean wasModified(OffsetKey key) {
        return this.myModified.contains(key);
    }

    public void dispose() {
        this.myDisposed = true;
        for (RangeMarker rangeMarker : this.myMap.values()) {
            rangeMarker.dispose();
        }
    }
}

