/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtil;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;

public class FS_Win32
extends FS {
    private volatile Boolean supportSymlinks;

    public FS_Win32() {
    }

    protected FS_Win32(FS src) {
        super(src);
    }

    @Override
    public FS newInstance() {
        return new FS_Win32(this);
    }

    @Override
    public boolean supportsExecute() {
        return false;
    }

    @Override
    public boolean canExecute(File f) {
        return false;
    }

    @Override
    public boolean setExecute(File f, boolean canExec) {
        return false;
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public boolean retryFailedLockFileCommit() {
        return true;
    }

    @Override
    protected File discoverGitExe() {
        String w;
        String path = SystemReader.getInstance().getenv("PATH");
        File gitExe = FS_Win32.searchPath(path, "git.exe", "git.cmd");
        if (gitExe == null && FS_Win32.searchPath(path, "bash.exe") != null && !StringUtils.isEmptyOrNull(w = FS_Win32.readPipe(this.userHome(), new String[]{"bash", "--login", "-c", "which git"}, Charset.defaultCharset().name()))) {
            gitExe = this.resolve(null, w);
        }
        return gitExe;
    }

    @Override
    protected File userHomeImpl() {
        String homePath;
        String home = SystemReader.getInstance().getenv("HOME");
        if (home != null) {
            return this.resolve(null, home);
        }
        String homeDrive = SystemReader.getInstance().getenv("HOMEDRIVE");
        if (homeDrive != null && (homePath = SystemReader.getInstance().getenv("HOMEPATH")) != null) {
            return new File(homeDrive, homePath);
        }
        String homeShare = SystemReader.getInstance().getenv("HOMESHARE");
        if (homeShare != null) {
            return new File(homeShare);
        }
        return super.userHomeImpl();
    }

    @Override
    public ProcessBuilder runInShell(String cmd, String[] args) {
        ArrayList<String> argv = new ArrayList<String>(3 + args.length);
        argv.add("cmd.exe");
        argv.add("/c");
        argv.add(cmd);
        argv.addAll(Arrays.asList(args));
        ProcessBuilder proc = new ProcessBuilder(new String[0]);
        proc.command(argv);
        return proc;
    }

    private void detectSymlinkSupport() {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("tempsymlinktarget", "");
            File linkName = new File(tempFile.getParentFile(), "tempsymlink");
            FileUtil.createSymLink(linkName, tempFile.getPath());
            this.supportSymlinks = Boolean.TRUE;
            linkName.delete();
        }
        catch (IOException e) {
            this.supportSymlinks = Boolean.FALSE;
        }
        catch (UnsupportedOperationException e) {
            this.supportSymlinks = Boolean.FALSE;
        }
        finally {
            if (tempFile != null) {
                try {
                    FileUtils.delete(tempFile);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public boolean isSymLink(File path) throws IOException {
        return FileUtil.isSymlink(path);
    }

    @Override
    public long lastModified(File path) throws IOException {
        return FileUtil.lastModified(path);
    }

    @Override
    public void setLastModified(File path, long time) throws IOException {
        FileUtil.setLastModified(path, time);
    }

    @Override
    public void delete(File path) throws IOException {
        FileUtil.delete(path);
    }

    @Override
    public long length(File f) throws IOException {
        return FileUtil.getLength(f);
    }

    @Override
    public boolean exists(File path) {
        return FileUtil.exists(path);
    }

    @Override
    public boolean isDirectory(File path) {
        return FileUtil.isDirectory(path);
    }

    @Override
    public boolean isFile(File path) {
        return FileUtil.isFile(path);
    }

    @Override
    public boolean isHidden(File path) throws IOException {
        return FileUtil.isHidden(path);
    }

    @Override
    public void setHidden(File path, boolean hidden) throws IOException {
        FileUtil.setHidden(path, hidden);
    }

    @Override
    public String readSymLink(File path) throws IOException {
        return FileUtil.readSymlink(path);
    }

    @Override
    public void createSymLink(File path, String target) throws IOException {
        FileUtil.createSymLink(path, target);
    }

    @Override
    public FS.Attributes getAttributes(File path) {
        return FileUtil.getFileAttributesBasic(this, path);
    }
}

