/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.PackInputStream;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectStream;

final class LargePackedWholeObject
extends ObjectLoader {
    private final int type;
    private final long size;
    private final long objectOffset;
    private final int headerLength;
    private final DfsPackFile pack;
    private final DfsObjDatabase db;

    LargePackedWholeObject(int type, long size, long objectOffset, int headerLength, DfsPackFile pack, DfsObjDatabase db) {
        this.type = type;
        this.size = size;
        this.objectOffset = objectOffset;
        this.headerLength = headerLength;
        this.pack = pack;
        this.db = db;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public boolean isLarge() {
        return true;
    }

    @Override
    public byte[] getCachedBytes() throws LargeObjectException {
        throw new LargeObjectException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectStream openStream() throws MissingObjectException, IOException {
        InputStream in;
        DfsReader ctx = new DfsReader(this.db);
        try {
            in = new PackInputStream(this.pack, this.objectOffset + (long)this.headerLength, ctx);
        }
        catch (IOException packGone) {
            ObjectId obj = this.pack.getReverseIdx(ctx).findObject(this.objectOffset);
            ObjectStream objectStream = ctx.open(obj, this.type).openStream();
            ctx.close();
            return objectStream;
        }
        finally {
            ctx.close();
        }
        int bufsz = 8192;
        in = new BufferedInputStream(new InflaterInputStream(in, ctx.inflater(), bufsz), bufsz);
        return new ObjectStream.Filter(this.type, this.size, in);
    }
}

