/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.ui;

import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.provider.update.HgUpdateConfigurationSettings;
import org.zmlx.hg4idea.provider.update.HgUpdateType;

public class HgUpdateDialog {
    private JComponent myContentPanel = this.createCenterPanel();
    private JCheckBox myPullCheckBox;
    private JCheckBox myCommitAfterMergeCheckBox;
    private JRadioButton myOnlyUpdateButton;
    private JRadioButton myMergeRadioButton;
    private JRadioButton myRebaseRadioButton;

    @NotNull
    public JComponent getContentPanel() {
        JComponent jComponent = this.myContentPanel;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/ui/HgUpdateDialog", "getContentPanel"));
        }
        return jComponent;
    }

    private void updateEnabledStates() {
        this.myCommitAfterMergeCheckBox.setEnabled(this.myMergeRadioButton.isSelected());
    }

    public void applyTo(@NotNull HgUpdateConfigurationSettings updateConfiguration) {
        if (updateConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateConfiguration", "org/zmlx/hg4idea/ui/HgUpdateDialog", "applyTo"));
        }
        updateConfiguration.setShouldPull(this.myPullCheckBox.isSelected());
        if (this.myOnlyUpdateButton.isSelected()) {
            updateConfiguration.setUpdateType(HgUpdateType.ONLY_UPDATE);
        }
        if (this.myMergeRadioButton.isSelected()) {
            updateConfiguration.setUpdateType(HgUpdateType.MERGE);
        }
        if (this.myRebaseRadioButton.isSelected()) {
            updateConfiguration.setUpdateType(HgUpdateType.REBASE);
        }
        updateConfiguration.setShouldCommitAfterMerge(this.myCommitAfterMergeCheckBox.isSelected());
    }

    @NotNull
    public JComponent createCenterPanel() {
        MigLayout migLayout = new MigLayout("flowy,ins 0, fill");
        JPanel contentPane = new JPanel((LayoutManager)migLayout);
        this.myPullCheckBox = new JBCheckBox("Pull", true);
        this.myPullCheckBox.setMnemonic('p');
        this.myPullCheckBox.setToolTipText("Pull from the default remote repository");
        this.myPullCheckBox.setSelected(true);
        this.myOnlyUpdateButton = new JRadioButton("Only Update", true);
        this.myOnlyUpdateButton.setMnemonic('u');
        this.myOnlyUpdateButton.setToolTipText("Update to the head of the current branch");
        this.myMergeRadioButton = new JRadioButton("Merge", false);
        this.myMergeRadioButton.setMnemonic('m');
        this.myMergeRadioButton.setToolTipText("Merge if pulling resulted in extra heads");
        this.myMergeRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                HgUpdateDialog.this.updateEnabledStates();
            }
        });
        this.myCommitAfterMergeCheckBox = new JCheckBox("Commit after merge without conflicts", false);
        this.myCommitAfterMergeCheckBox.setMnemonic('c');
        this.myCommitAfterMergeCheckBox.setToolTipText("Commit automatically after the merge");
        this.myCommitAfterMergeCheckBox.setSelected(false);
        this.myRebaseRadioButton = new JRadioButton("Rebase", false);
        this.myRebaseRadioButton.setToolTipText("Rebase changesets to a branch tip as destination");
        this.myRebaseRadioButton.setMnemonic('r');
        contentPane.add((Component)this.myPullCheckBox, "left");
        JPanel strategyPanel = new JPanel((LayoutManager)migLayout);
        strategyPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Update Strategy", (boolean)false));
        strategyPanel.add((Component)this.myOnlyUpdateButton, "left");
        strategyPanel.add((Component)this.myMergeRadioButton, "left");
        strategyPanel.add((Component)this.myCommitAfterMergeCheckBox, "gapx 5%");
        strategyPanel.add((Component)this.myRebaseRadioButton, "left");
        contentPane.add(strategyPanel);
        ButtonGroup group = new ButtonGroup();
        group.add(this.myOnlyUpdateButton);
        group.add(this.myRebaseRadioButton);
        group.add(this.myMergeRadioButton);
        this.updateEnabledStates();
        JPanel jPanel = contentPane;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/ui/HgUpdateDialog", "createCenterPanel"));
        }
        return jPanel;
    }

    public void updateFrom(@NotNull HgUpdateConfigurationSettings updateConfiguration) {
        if (updateConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateConfiguration", "org/zmlx/hg4idea/ui/HgUpdateDialog", "updateFrom"));
        }
        this.myPullCheckBox.setSelected(updateConfiguration.shouldPull());
        HgUpdateType updateType = updateConfiguration.getUpdateType();
        switch (updateType) {
            case ONLY_UPDATE: {
                this.myOnlyUpdateButton.setSelected(true);
                break;
            }
            case MERGE: {
                this.myMergeRadioButton.setSelected(true);
                break;
            }
            case REBASE: {
                this.myRebaseRadioButton.setSelected(true);
                break;
            }
            default: {
                assert (false) : "Unknown value of update type: " + (Object)((Object)updateType);
                break;
            }
        }
        this.myCommitAfterMergeCheckBox.setSelected(updateConfiguration.shouldCommitAfterMerge());
    }
}

