/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider.update;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.command.HgResolveCommand;
import org.zmlx.hg4idea.command.HgResolveStatusEnum;

public final class HgConflictResolver {
    @NotNull
    private final Project myProject;
    private final UpdatedFiles updatedFiles;

    public HgConflictResolver(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/provider/update/HgConflictResolver", "<init>"));
        }
        this(project, null);
    }

    public HgConflictResolver(@NotNull Project project, UpdatedFiles updatedFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/provider/update/HgConflictResolver", "<init>"));
        }
        this.myProject = project;
        this.updatedFiles = updatedFiles;
    }

    public void resolve(VirtualFile repo) {
        Map<HgFile, HgResolveStatusEnum> resolves = new HgResolveCommand(this.myProject).getListSynchronously(repo);
        final ArrayList<VirtualFile> conflicts = new ArrayList<VirtualFile>();
        for (Map.Entry<HgFile, HgResolveStatusEnum> entry : resolves.entrySet()) {
            File file = entry.getKey().getFile();
            String fileGroupId = null;
            switch (entry.getValue()) {
                case UNRESOLVED: {
                    conflicts.add(VcsUtil.getVirtualFile((File)file));
                    fileGroupId = "MERGED_WITH_CONFLICTS";
                    break;
                }
                case RESOLVED: {
                    fileGroupId = "MERGED";
                    break;
                }
            }
            if (this.updatedFiles == null || fileGroupId == null) continue;
            this.updatedFiles.getGroupById("UPDATED").remove(file.getAbsolutePath());
            this.updatedFiles.getGroupById(fileGroupId).add(file.getPath(), "hg4idea", null);
        }
        if (conflicts.isEmpty()) {
            return;
        }
        final HgVcs vcs = HgVcs.getInstance(this.myProject);
        if (vcs == null) {
            return;
        }
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                AbstractVcsHelper.getInstance((Project)HgConflictResolver.this.myProject).showMergeDialog(conflicts, vcs.getMergeProvider());
            }
        }, ModalityState.defaultModalityState());
    }

    @NotNull
    public static List<VirtualFile> findConflicts(Project project, VirtualFile repo) {
        Map<HgFile, HgResolveStatusEnum> resolves = new HgResolveCommand(project).getListSynchronously(repo);
        ArrayList<VirtualFile> conflicts = new ArrayList<VirtualFile>();
        for (Map.Entry<HgFile, HgResolveStatusEnum> entry : resolves.entrySet()) {
            File file = entry.getKey().getFile();
            switch (entry.getValue()) {
                case UNRESOLVED: {
                    conflicts.add(VcsUtil.getVirtualFile((File)file));
                    break;
                }
            }
        }
        ArrayList<VirtualFile> arrayList = conflicts;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/provider/update/HgConflictResolver", "findConflicts"));
        }
        return arrayList;
    }
}

